/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.TimeZone;

@Deprecated
public final class ISO8601ASF {
    private static final DecimalFormat XX_FORMAT = new DecimalFormat("00");
    private static final DecimalFormat XXX_FORMAT = new DecimalFormat("000");
    private static final DecimalFormat XXXX_FORMAT = new DecimalFormat("0000");

    public static Calendar parse(String text) {
        String tzID;
        int ms;
        int sec;
        int min;
        int hour;
        int day;
        int month;
        int year;
        int sign;
        block21: {
            int start;
            if (text == null) {
                throw new IllegalArgumentException("argument can not be null");
            }
            if (text.startsWith("-")) {
                sign = 45;
                start = 1;
            } else if (text.startsWith("+")) {
                sign = 43;
                start = 1;
            } else {
                sign = 43;
                start = 0;
            }
            try {
                year = Integer.parseInt(text.substring(start, start + 4));
                if (text.charAt(start += 4) != '-') {
                    return null;
                }
                month = Integer.parseInt(text.substring(++start, start + 2));
                if (text.charAt(start += 2) != '-') {
                    return null;
                }
                day = Integer.parseInt(text.substring(++start, start + 2));
                if (text.charAt(start += 2) != 'T') {
                    return null;
                }
                hour = Integer.parseInt(text.substring(++start, start + 2));
                if (text.charAt(start += 2) != ':') {
                    return null;
                }
                min = Integer.parseInt(text.substring(++start, start + 2));
                if (text.charAt(start += 2) != ':') {
                    return null;
                }
                sec = Integer.parseInt(text.substring(++start, start + 2));
                if (text.charAt(start += 2) != '.') {
                    return null;
                }
                ms = Integer.parseInt(text.substring(++start, start + 3));
                if (text.charAt(start += 3) == '+' || text.charAt(start) == '-') {
                    tzID = "GMT" + text.substring(start);
                    break block21;
                }
                if (text.substring(start).equals("Z")) {
                    tzID = "GMT";
                    break block21;
                }
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        TimeZone tz = TimeZone.getTimeZone(tzID);
        if (!tz.getID().equals(tzID)) {
            return null;
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setLenient(false);
        if (sign == 45 || year == 0) {
            cal.set(1, year + 1);
            cal.set(0, 0);
        } else {
            cal.set(1, year);
            cal.set(0, 1);
        }
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        cal.set(14, ms);
        try {
            cal.getTime();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return cal;
    }

    public static String format(Calendar cal) {
        if (cal == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        int year = cal.get(1);
        if (cal.isSet(0) && cal.get(0) == 0) {
            year = 0 - year + 1;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(XXXX_FORMAT.format(year));
        buf.append('-');
        buf.append(XX_FORMAT.format(cal.get(2) + 1));
        buf.append('-');
        buf.append(XX_FORMAT.format(cal.get(5)));
        buf.append('T');
        buf.append(XX_FORMAT.format(cal.get(11)));
        buf.append(':');
        buf.append(XX_FORMAT.format(cal.get(12)));
        buf.append(':');
        buf.append(XX_FORMAT.format(cal.get(13)));
        buf.append('.');
        buf.append(XXX_FORMAT.format(cal.get(14)));
        TimeZone tz = cal.getTimeZone();
        int offset = tz.getOffset(cal.getTimeInMillis());
        if (offset != 0) {
            int hours = Math.abs(offset / 60000 / 60);
            int minutes = Math.abs(offset / 60000 % 60);
            buf.append(offset < 0 ? (char)'-' : '+');
            buf.append(XX_FORMAT.format(hours));
            buf.append(':');
            buf.append(XX_FORMAT.format(minutes));
        } else {
            buf.append('Z');
        }
        return buf.toString();
    }
}

