/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;

public class IOUtil {
    public static String getFileContenntAsString(File file, String encoding) throws Exception {
        FileInputStream is = new FileInputStream(file);
        return new String(IOUtil.getStreamContentAsBytes(is), encoding);
    }

    public static String getFileContenntAsString(File file) throws Exception {
        FileInputStream is = new FileInputStream(file);
        return new String(IOUtil.getStreamContentAsBytes(is));
    }

    public static String getFileContenntAsString(String fileName, String encoding) throws Exception {
        FileInputStream is = new FileInputStream(fileName);
        return new String(IOUtil.getStreamContentAsBytes(is), encoding);
    }

    public static String getFileContenntAsString(String fileName) throws Exception {
        FileInputStream is = new FileInputStream(fileName);
        return new String(IOUtil.getStreamContentAsBytes(is));
    }

    public static byte[] getFileContentAsBytes(String fileName) throws Exception {
        FileInputStream is = new FileInputStream(fileName);
        return IOUtil.getStreamContentAsBytes(is);
    }

    public static String getStreamContentAsString(InputStream is) throws Exception {
        byte[] buf = new byte[is.available()];
        is.read(buf);
        return new String(buf, "UTF-8");
    }

    public static byte[] getStreamContentAsBytes(InputStream is) throws Exception {
        BufferedInputStream buffer = new BufferedInputStream(is);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] data = new byte[buffer.available()];
        int available = -1;
        while ((available = buffer.read(data)) > -1) {
            output.write(data, 0, available);
        }
        return output.toByteArray();
    }

    public static String getResourceAsString(String resource) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(resource);
        InputStream is = url.openStream();
        return IOUtil.getStreamContentAsString(is);
    }

    public static byte[] getResourceAsBytes(String resource) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(resource);
        InputStream is = url.openStream();
        return IOUtil.getStreamContentAsBytes(is);
    }

    @Deprecated
    public static byte[] serialize(Object obj) throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject(obj);
        out.close();
        byte[] ret = bytes.toByteArray();
        return ret;
    }

    @Deprecated
    public static Object deserialize(byte[] bytes) throws Exception {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(is);
        Object obj = in.readObject();
        in.close();
        return obj;
    }
}

