/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.log;

import org.exoplatform.services.log.ExoLogFactory;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.log.impl.SLF4JExoLogFactory;
import org.exoplatform.services.log.impl.SimpleExoLogFactory;

public abstract class ExoLogger {
    private static SimpleExoLogFactory failOverFactory = new SimpleExoLogFactory();
    private static ExoLogFactory loggerFactory = new SLF4JExoLogFactory();

    public static void setFactory(ExoLogFactory factory) throws NullPointerException {
        if (factory == null) {
            throw new NullPointerException("Cannot set a null logger factory");
        }
        loggerFactory = factory;
    }

    public static Log getLogger(String name) {
        return ExoLogger.getExoLogger(name);
    }

    public static Log getLogger(Class name) {
        return ExoLogger.getExoLogger(name);
    }

    public static Log getExoLogger(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        try {
            return loggerFactory.getExoLogger(name);
        }
        catch (NoClassDefFoundError e) {
            System.err.println("Could not load logger class factory " + e.getMessage() + " will use fail over logger instead");
            return failOverFactory.getExoLogger(name);
        }
    }

    public static Log getExoLogger(Class name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        try {
            return loggerFactory.getExoLogger(name);
        }
        catch (NoClassDefFoundError e) {
            System.err.println("Could not load logger class factory " + e.getMessage() + " will use fail over logger instead");
            return failOverFactory.getExoLogger(name);
        }
    }
}

