/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.exception;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.exoplatform.commons.exception.ExoException;

public class ExoMessageException
extends ExoException {
    private String messageKey_;
    private Object[] args_;

    public ExoMessageException(String messageKey) {
        this.messageKey_ = messageKey;
    }

    public ExoMessageException(String messageKey, Object[] args) {
        this.messageKey_ = messageKey;
        this.args_ = args;
    }

    public String getMessageKey() {
        return this.messageKey_;
    }

    public Object[] getArguments() {
        return this.args_;
    }

    @Override
    public String getMessage(ResourceBundle res) {
        if (this.args_ == null) {
            return res.getString(this.messageKey_);
        }
        return MessageFormat.format(res.getString(this.messageKey_), this.args_);
    }

    @Override
    public String getExceptionDescription() {
        return "Usually, this is not a critical exception. The exception is raised when unexpected condition such wrong input, object not found....The application should not crashed and it should continue working";
    }

    @Override
    public String getErrorCode() {
        return "EXO ERROR: ";
    }
}

