/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ISO8601 {
    protected static final String TZD = "TZD";
    public static final String YEAR_FORMAT = "yyyy";
    public static final String YEARMONTH_FORMAT = "yyyy-MM";
    public static final String COMPLETE_DATE_FORMAT = "yyyy-MM-dd";
    public static final String SIMPLE_DATEHOURSMINUTES_FORMAT = "yyyy-MM-dd'T'HH:mm";
    public static final String COMPLETE_DATEHOURSMINUTESZRFC822_FORMAT = "yyyy-MM-dd'T'HH:mmZ";
    public static final String COMPLETE_DATEHOURSMINUTESZ_FORMAT = "yyyy-MM-dd'T'HH:mmTZD";
    public static final String SIMPLE_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String COMPLETE_DATETIMEZRFC822_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String COMPLETE_DATETIMEZ_FORMAT = "yyyy-MM-dd'T'HH:mm:ssTZD";
    public static final String SIMPLE_DATETIMEMS_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String COMPLETE_DATETIMEMSZRFC822_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String COMPLETE_DATETIMEMSZ_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSTZD";
    public static final String[] FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSTZD", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ssTZD", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mmTZD", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd", "yyyy-MM", "yyyy"};

    public static String format(Calendar date) {
        return new ISODateFormat(COMPLETE_DATETIMEMSZ_FORMAT).format(date);
    }

    public static Calendar parse(String dateString) {
        try {
            return ISO8601.parse(dateString, FORMATS);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Calendar parseEx(String dateString) throws ParseException, NumberFormatException {
        return ISO8601.parse(dateString, FORMATS);
    }

    public static Calendar parse(String dateString, String[] formats) throws ParseException {
        StringBuilder problems = new StringBuilder();
        int errOffset = 0;
        for (String format : formats) {
            try {
                Calendar isoDate = new ISODateFormat(format).parse(dateString);
                return isoDate;
            }
            catch (ParseException e) {
                if (errOffset == 0) {
                    errOffset = e.getErrorOffset();
                }
                problems.append(format);
                problems.append(" - ");
                problems.append(e.getMessage());
                problems.append(", error offset ");
                problems.append(e.getErrorOffset());
                problems.append(" \n");
            }
            catch (NumberFormatException e) {
                errOffset = 0;
                problems.append(format);
                problems.append(" - ");
                problems.append(e.getMessage());
                problems.append(" \n");
            }
        }
        throw new ParseException("Can not parse " + dateString + " as Date. " + problems.toString(), errOffset);
    }

    protected static class ISODateFormat {
        private final SimpleDateFormat formater;
        private final String format;
        private final boolean isoTZ;

        ISODateFormat(String format) {
            this.isoTZ = format.endsWith(ISO8601.TZD);
            this.format = this.isoTZ ? format.substring(0, format.length() - ISO8601.TZD.length()) + "Z" : format;
            this.formater = new SimpleDateFormat(this.format, Locale.US);
        }

        public Calendar parse(String dateString) throws ParseException, NumberFormatException {
            Date isoDate = null;
            TimeZone timeZone = null;
            if (dateString.length() >= 16) {
                int index;
                if (this.isoTZ) {
                    if (dateString.endsWith("Z")) {
                        dateString = dateString.substring(0, dateString.length() - 1) + "+0000";
                    } else {
                        int tzsindex = dateString.length() - 6;
                        char tzsign = dateString.charAt(tzsindex);
                        if (tzsign == '+' || tzsign == '-') {
                            dateString = dateString.substring(0, tzsindex) + dateString.substring(tzsindex).replaceAll(":", "");
                        }
                    }
                }
                if ((index = dateString.lastIndexOf(45)) >= 16 || (index = dateString.lastIndexOf(43)) >= 16) {
                    String timeZoneStr = dateString.substring(index);
                    timeZone = TimeZone.getTimeZone("GMT" + timeZoneStr);
                    this.formater.setTimeZone(timeZone);
                }
            }
            isoDate = this.formater.parse(dateString);
            Calendar isoCalendar = Calendar.getInstance();
            isoCalendar.setTime(isoDate);
            if (timeZone != null) {
                isoCalendar.setTimeZone(timeZone);
            }
            return isoCalendar;
        }

        public String format(Calendar source) {
            if (this.isoTZ) {
                this.formater.setTimeZone(source.getTimeZone());
                String formatedDate = this.formater.format(source.getTime());
                if (formatedDate.endsWith("0000")) {
                    return formatedDate.substring(0, formatedDate.length() - 5) + "Z";
                }
                int dindex = formatedDate.length() - 2;
                return formatedDate.substring(0, dindex) + ":" + formatedDate.substring(dindex);
            }
            return this.formater.format(source);
        }
    }
}

