/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CachedObjectSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="cache"), @Property(key="name", value="{Name}")})
@ManagedDescription(value="Exo Cache")
public interface ExoCache {
    @Managed
    @ManagedName(value="Name")
    @ManagedDescription(value="The cache name")
    public String getName();

    public void setName(String var1);

    public String getLabel();

    public void setLabel(String var1);

    public Object get(Serializable var1) throws Exception;

    public Object remove(Serializable var1) throws Exception;

    public void put(Serializable var1, Object var2) throws Exception;

    public void putMap(Map<Serializable, Object> var1) throws Exception;

    @Managed
    @ManagedDescription(value="Evict all entries of the cache")
    public void clearCache() throws Exception;

    public void select(CachedObjectSelector var1) throws Exception;

    @Managed
    @ManagedName(value="Size")
    @ManagedDescription(value="The cache size")
    public int getCacheSize();

    @Managed
    @ManagedName(value="Capacity")
    @ManagedDescription(value="The maximum capacity")
    public int getMaxSize();

    @Managed
    public void setMaxSize(int var1);

    @Managed
    @ManagedName(value="TimeToLive")
    @ManagedDescription(value="The maximum life time of an entry in seconds")
    public long getLiveTime();

    @Managed
    public void setLiveTime(long var1);

    @Managed
    @ManagedName(value="HitCount")
    @ManagedDescription(value="The count of cache hits")
    public int getCacheHit();

    @Managed
    @ManagedName(value="MissCount")
    @ManagedDescription(value="The count of cache misses")
    public int getCacheMiss();

    public List getCachedObjects();

    public List removeCachedObjects() throws Exception;

    public void addCacheListener(CacheListener var1);

    public boolean isDistributed();

    public void setDistributed(boolean var1);

    public boolean isReplicated();

    public void setReplicated(boolean var1);

    public boolean isLogEnabled();

    public void setLogEnabled(boolean var1);
}

