/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.future;

import java.util.concurrent.Callable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.exoplatform.services.cache.future.FutureMap;
import org.exoplatform.services.cache.future.StringLoader;

public class GetTestCase
extends TestCase {
    public void testGet() {
        FutureMap<Callable<String>> futureCache = new FutureMap<Callable<String>>(new StringLoader());
        Assert.assertEquals((String)"foo_value", (String)((String)futureCache.get(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "foo_value";
            }
        }, "foo")));
        Assert.assertEquals((String)"foo_value", (String)futureCache.data.get("foo"));
    }

    public void testNullValue() {
        FutureMap<Callable<String>> futureCache = new FutureMap<Callable<String>>(new StringLoader());
        Assert.assertEquals(null, (String)((String)futureCache.get(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return null;
            }
        }, "foo")));
        Assert.assertFalse((boolean)futureCache.data.containsKey("foo"));
    }

    public void testThrowException() {
        FutureMap<Callable<String>> futureCache = new FutureMap<Callable<String>>(new StringLoader());
        Assert.assertEquals(null, (String)((String)futureCache.get(new Callable<String>(){

            @Override
            public String call() throws Exception {
                throw new Exception("DON'T FREAK OUT");
            }
        }, "foo")));
        Assert.assertFalse((boolean)futureCache.data.containsKey("foo"));
    }
}

