/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.transaction.impl;

import java.security.PrivilegedExceptionAction;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.TransactionService;

public abstract class AbstractTransactionService
implements TransactionService {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.common.AbstractTransactionService");
    private static final int DEFAULT_TIME_OUT = 60;
    protected final int defaultTimeout;
    protected final boolean forceTimeout;
    private volatile TransactionManager tm;
    private volatile UserTransaction ut;

    public AbstractTransactionService() {
        this(null);
    }

    public AbstractTransactionService(InitParams params) {
        if (params != null && params.getValueParam("timeout") != null) {
            this.defaultTimeout = Integer.parseInt(params.getValueParam("timeout").getValue());
            this.forceTimeout = true;
        } else {
            this.defaultTimeout = 60;
            this.forceTimeout = false;
        }
    }

    @Override
    public boolean delistResource(XAResource xares) throws RollbackException, SystemException {
        TransactionManager tm = this.getTransactionManager();
        Transaction tx = tm.getTransaction();
        if (tx != null) {
            int flag = 0x4000000;
            switch (tx.getStatus()) {
                case 1: 
                case 4: 
                case 9: {
                    flag = 0x20000000;
                }
            }
            return tx.delistResource(xares, flag);
        }
        throw new IllegalStateException("Could not delist the XA Resource since there is no active session");
    }

    @Override
    public boolean enlistResource(XAResource xares) throws RollbackException, SystemException {
        TransactionManager tm = this.getTransactionManager();
        Transaction tx = tm.getTransaction();
        if (tx != null) {
            return tx.enlistResource(xares);
        }
        throw new IllegalStateException("Could not enlist the XA Resource since there is no active session");
    }

    @Override
    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TransactionManager getTransactionManager() {
        if (this.tm == null) {
            AbstractTransactionService abstractTransactionService = this;
            synchronized (abstractTransactionService) {
                if (this.tm == null) {
                    TransactionManager tm;
                    try {
                        tm = (TransactionManager)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<TransactionManager>(){

                            @Override
                            public TransactionManager run() throws Exception {
                                return AbstractTransactionService.this.findTransactionManager();
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Transaction manager not found", e);
                    }
                    if (this.forceTimeout) {
                        tm = new TransactionManagerTxTimeoutAware(tm, this.defaultTimeout);
                    }
                    this.tm = tm;
                }
            }
        }
        return this.tm;
    }

    protected boolean isTMInitialized() {
        return this.tm != null;
    }

    protected abstract TransactionManager findTransactionManager() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final UserTransaction getUserTransaction() {
        if (this.ut == null) {
            AbstractTransactionService abstractTransactionService = this;
            synchronized (abstractTransactionService) {
                if (this.ut == null) {
                    UserTransaction ut;
                    try {
                        ut = (UserTransaction)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<UserTransaction>(){

                            @Override
                            public UserTransaction run() throws Exception {
                                return AbstractTransactionService.this.findUserTransaction();
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new RuntimeException("UserTransaction not found", e);
                    }
                    this.ut = ut;
                }
            }
        }
        return this.ut;
    }

    protected UserTransaction findUserTransaction() throws Exception {
        return new UserTransactionWrapper(this.getTransactionManager());
    }

    @Override
    public void setTransactionTimeout(int seconds) throws SystemException {
        TransactionManager tm = this.getTransactionManager();
        tm.setTransactionTimeout(seconds);
    }

    private static class UserTransactionWrapper
    implements UserTransaction {
        private final TransactionManager tm;

        public UserTransactionWrapper(TransactionManager tm) {
            this.tm = tm;
        }

        public void begin() throws NotSupportedException, SystemException {
            this.tm.begin();
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            this.tm.commit();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.tm.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.tm.setRollbackOnly();
        }

        public int getStatus() throws SystemException {
            return this.tm.getStatus();
        }

        public void setTransactionTimeout(int timeout) throws SystemException {
            this.tm.setTransactionTimeout(timeout);
        }
    }

    private static class TransactionManagerTxTimeoutAware
    implements TransactionManager {
        private final TransactionManager tm;
        private final int defaultTimeout;
        private final ThreadLocal<Boolean> timeoutHasBeenSet = new ThreadLocal();

        public TransactionManagerTxTimeoutAware(TransactionManager tm, int defaultTimeout) {
            this.tm = tm;
            this.defaultTimeout = defaultTimeout;
        }

        public void begin() throws NotSupportedException, SystemException {
            if (this.timeoutHasBeenSet.get() != null) {
                this.timeoutHasBeenSet.set(null);
            } else {
                try {
                    this.tm.setTransactionTimeout(this.defaultTimeout);
                }
                catch (Exception e) {
                    LOG.warn((Object)"Cannot set the transaction timeout", (Throwable)e);
                }
            }
            this.tm.begin();
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            this.tm.commit();
        }

        public int getStatus() throws SystemException {
            return this.tm.getStatus();
        }

        public Transaction getTransaction() throws SystemException {
            return this.tm.getTransaction();
        }

        public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
            this.tm.resume(tx);
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.tm.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.tm.setRollbackOnly();
        }

        public void setTransactionTimeout(int timeout) throws SystemException {
            this.tm.setTransactionTimeout(timeout);
            this.timeoutHasBeenSet.set(true);
        }

        public Transaction suspend() throws SystemException {
            return this.tm.suspend();
        }
    }
}

