/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.infinispan;

import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.cache.CacheInfo;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;

public abstract class AbstractExoCache<K extends Serializable, V>
implements ExoCache<K, V> {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.ext.cache.impl.infinispan.v5.AbstractExoCache");
    private final AtomicInteger hits = new AtomicInteger(0);
    private final AtomicInteger misses = new AtomicInteger(0);
    private String label;
    private String name;
    private boolean distributed;
    private boolean replicated;
    private boolean logEnabled;
    private final CopyOnWriteArrayList<ListenerContext<K, V>> listeners;
    protected final AdvancedCache<K, V> cache;

    public AbstractExoCache(ExoCacheConfig config, Cache<K, V> cache) {
        this.cache = cache.getAdvancedCache();
        this.listeners = new CopyOnWriteArrayList();
        this.setDistributed(config.isDistributed());
        this.setLabel(config.getLabel());
        this.setName(config.getName());
        this.setLogEnabled(config.isLogEnabled());
        this.setReplicated(config.isRepicated());
        cache.addListener((Object)new CacheEventListener());
    }

    public void addCacheListener(CacheListener<? super K, ? super V> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener cannot be null");
        }
        this.listeners.add(new ListenerContext<K, V>(listener, this));
    }

    public void clearCache() {
        this.cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).clear();
        this.onClearCache();
    }

    public V get(Serializable name) {
        if (name == null) {
            return null;
        }
        Object result = this.cache.get((Object)name);
        if (result == null) {
            this.misses.incrementAndGet();
        } else {
            this.hits.incrementAndGet();
        }
        this.onGet(name, result);
        return (V)result;
    }

    public int getCacheHit() {
        return this.hits.get();
    }

    public int getCacheMiss() {
        return this.misses.get();
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    public List<V> getCachedObjects() {
        Collection values = this.cache.values();
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList(values);
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public void put(final K key, final V value) throws IllegalArgumentException {
        Object oldValue;
        InternalCacheEntry internalCacheEntry;
        if (key == null) {
            throw new IllegalArgumentException("No null cache key accepted");
        }
        if (value == null) {
            return;
        }
        if (LOG.isDebugEnabled() && this.cache.getDataContainer().containsKey(key) && (internalCacheEntry = this.cache.getDataContainer().get(key)) != null && (oldValue = internalCacheEntry.getValue()) != null) {
            if (oldValue.equals(value)) {
                LOG.debug((Object)("Need to optimize top layer cache management propably (depends on ValueClass.equals method pertinence). The same value putted into cache, cache = " + this.cache.getName() + ", key : class= " + key.getClass() + ", hashcode= " + key.hashCode() + "/ old hashcode: " + internalCacheEntry.getKey().hashCode()));
            } else {
                try {
                    value.getClass().getDeclaredMethod("equals", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    LOG.debug((Object)("Need to implement equals method in " + value.getClass().getCanonicalName() + ". cache = " + this.cache.getName() + ", key : class= " + key.getClass() + ", hashcode= " + key.hashCode() + "/ old hashcode: " + internalCacheEntry.getKey().hashCode()));
                }
            }
        }
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                AbstractExoCache.this.putOnly(key, value);
                return null;
            }
        });
        this.onPut(key, value);
    }

    protected void putOnly(K key, V value) {
        this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES}).put(key, value);
    }

    public void putMap(final Map<? extends K, ? extends V> objs) throws IllegalArgumentException {
        if (objs == null) {
            throw new IllegalArgumentException("No null map accepted");
        }
        for (Serializable name : objs.keySet()) {
            if (name != null) continue;
            throw new IllegalArgumentException("No null cache key accepted");
        }
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (AbstractExoCache.this.cache.getTransactionManager() != null) {
                    AbstractExoCache.this.cache.startBatch();
                }
                try {
                    LinkedHashMap map = new LinkedHashMap();
                    for (Map.Entry entry : objs.entrySet()) {
                        map.put(entry.getKey(), entry.getValue());
                    }
                    AbstractExoCache.this.cache.putAll(map);
                    if (AbstractExoCache.this.cache.getTransactionManager() != null) {
                        AbstractExoCache.this.cache.endBatch(true);
                    }
                    for (Map.Entry entry : objs.entrySet()) {
                        AbstractExoCache.this.onPut((Serializable)entry.getKey(), entry.getValue());
                    }
                }
                catch (Exception e) {
                    if (AbstractExoCache.this.cache.getTransactionManager() != null) {
                        AbstractExoCache.this.cache.endBatch(false);
                    }
                    LOG.warn((Object)"An error occurs while executing the putMap method", (Throwable)e);
                }
                return null;
            }
        });
    }

    public V remove(final Serializable name) throws NullPointerException {
        if (name == null) {
            throw new IllegalArgumentException("No null cache key accepted");
        }
        Object result = SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<V>(){

            @Override
            public V run() {
                return AbstractExoCache.this.cache.remove((Object)name);
            }
        });
        this.onRemove(name, result);
        return (V)result;
    }

    public List<V> removeCachedObjects() {
        List<V> list = this.getCachedObjects();
        this.clearCache();
        return list;
    }

    public void select(CachedObjectSelector<? super K, ? super V> selector) throws Exception {
        if (selector == null) {
            throw new IllegalArgumentException("No null selector");
        }
        for (Map.Entry entry : this.cache.entrySet()) {
            Object value;
            ObjectCacheInfo info;
            Serializable key = (Serializable)entry.getKey();
            if (key == null || !selector.select(key, info = new ObjectCacheInfo<V>(value = entry.getValue()){
                final /* synthetic */ Object val$value;
                {
                    this.val$value = object;
                }

                public V get() {
                    return this.val$value;
                }

                public long getExpireTime() {
                    return -1L;
                }
            })) continue;
            selector.onSelect((ExoCache)this, key, info);
        }
    }

    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    void onExpire(K key, V obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onExpire(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onRemove(K key, V obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onRemove(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onPut(K key, V obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onPut(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onGet(K key, V obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onGet(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onClearCache() {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onClearCache();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    private static class ListenerContext<K extends Serializable, V>
    implements CacheListenerContext,
    CacheInfo {
        private final ExoCache<K, V> cache;
        final CacheListener<? super K, ? super V> listener;

        public ListenerContext(CacheListener<? super K, ? super V> listener, ExoCache<K, V> cache) {
            this.listener = listener;
            this.cache = cache;
        }

        public CacheInfo getCacheInfo() {
            return this;
        }

        public String getName() {
            return this.cache.getName();
        }

        public int getMaxSize() {
            return this.cache.getMaxSize();
        }

        public long getLiveTime() {
            return this.cache.getLiveTime();
        }

        public int getSize() {
            return this.cache.getCacheSize();
        }

        void onExpire(K key, V obj) throws Exception {
            this.listener.onExpire((CacheListenerContext)this, key, obj);
        }

        void onRemove(K key, V obj) throws Exception {
            this.listener.onRemove((CacheListenerContext)this, key, obj);
        }

        void onPut(K key, V obj) throws Exception {
            this.listener.onPut((CacheListenerContext)this, key, obj);
        }

        void onGet(K key, V obj) throws Exception {
            this.listener.onGet((CacheListenerContext)this, key, obj);
        }

        void onClearCache() throws Exception {
            this.listener.onClearCache((CacheListenerContext)this);
        }
    }

    @Listener
    public class CacheEventListener {
        @CacheEntriesEvicted
        public void cacheEntryEvicted(CacheEntriesEvictedEvent<K, V> evt) {
            if (evt.isPre()) {
                for (Map.Entry entry : evt.getEntries().entrySet()) {
                    AbstractExoCache.this.onExpire((Serializable)entry.getKey(), entry.getValue());
                }
            }
        }

        @CacheEntryRemoved
        public void cacheEntryRemoved(CacheEntryRemovedEvent<K, V> evt) {
            if (evt.isPre() && !evt.isOriginLocal()) {
                Serializable key = (Serializable)evt.getKey();
                Object value = evt.getValue();
                AbstractExoCache.this.onRemove(key, value);
            }
        }

        @CacheEntryModified
        public void cacheEntryModified(CacheEntryModifiedEvent<K, V> evt) {
            if (!evt.isOriginLocal() && !evt.isPre()) {
                Serializable key = (Serializable)evt.getKey();
                Object value = evt.getValue();
                AbstractExoCache.this.onPut(key, value);
            }
        }
    }
}

