/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss.fifo;

import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.jboss.AbstractExoCache;
import org.exoplatform.services.cache.impl.jboss.ExoCacheCreator;
import org.exoplatform.services.cache.impl.jboss.fifo.FIFOExoCacheConfig;
import org.jboss.cache.TreeCache;
import org.jboss.cache.eviction.EvictionConfiguration;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.FIFOConfiguration;
import org.jboss.cache.eviction.FIFOPolicy;
import org.jboss.cache.eviction.RegionManager;
import org.jboss.cache.eviction.RegionNameConflictException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIFOExoCacheCreator
implements ExoCacheCreator {
    public static final String EXPECTED_IMPL = "FIFO";

    @Override
    public String getExpectedImplementation() {
        return EXPECTED_IMPL;
    }

    @Override
    public Class<? extends ExoCacheConfig> getExpectedConfigType() {
        return FIFOExoCacheConfig.class;
    }

    @Override
    public ExoCache create(ExoCacheConfig config, TreeCache cache) throws ExoCacheInitException {
        if (config instanceof FIFOExoCacheConfig) {
            FIFOExoCacheConfig fifoConfig = (FIFOExoCacheConfig)config;
            return this.create(config, cache, fifoConfig.getMaxNodes());
        }
        return this.create(config, cache, config.getMaxSize());
    }

    private ExoCache create(ExoCacheConfig config, TreeCache cache, int maxNodes) throws ExoCacheInitException {
        RegionManager regionManager = cache.getEvictionRegionManager();
        final FIFOConfiguration fifo = new FIFOConfiguration();
        fifo.setMaxNodes(maxNodes);
        FIFOPolicy policy = new FIFOPolicy();
        policy.configure(cache);
        try {
            regionManager.createRegion(RegionManager.DEFAULT_REGION, (EvictionPolicy)policy, (EvictionConfiguration)fifo);
        }
        catch (RegionNameConflictException e) {
            throw new ExoCacheInitException("Cannot create the region", (Throwable)e);
        }
        return new AbstractExoCache(config, cache){

            public void setMaxSize(int max) {
                fifo.setMaxNodes(max);
            }

            public void setLiveTime(long period) {
                throw new UnsupportedOperationException();
            }

            @ManagedName(value="MaxNodes")
            @ManagedDescription(value="This is the maximum number of nodes allowed in this region. Any integer less than or equal to 0 will throw an exception when the policy provider is being configured for use.")
            public int getMaxSize() {
                return fifo.getMaxNodes();
            }

            public long getLiveTime() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

