/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss.lfu;

import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.jboss.AbstractExoCache;
import org.exoplatform.services.cache.impl.jboss.ExoCacheCreator;
import org.exoplatform.services.cache.impl.jboss.lfu.LFUExoCacheConfig;
import org.jboss.cache.TreeCache;
import org.jboss.cache.eviction.EvictionConfiguration;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.LFUConfiguration;
import org.jboss.cache.eviction.LFUPolicy;
import org.jboss.cache.eviction.RegionManager;
import org.jboss.cache.eviction.RegionNameConflictException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LFUExoCacheCreator
implements ExoCacheCreator {
    public static final String EXPECTED_IMPL = "LFU";
    protected int defaultMinNodes;

    @Override
    public ExoCache create(ExoCacheConfig config, TreeCache cache) throws ExoCacheInitException {
        if (config instanceof LFUExoCacheConfig) {
            LFUExoCacheConfig lfuConfig = (LFUExoCacheConfig)config;
            return this.create(config, cache, lfuConfig.getMaxNodes(), lfuConfig.getMinNodes());
        }
        return this.create(config, cache, config.getMaxSize(), this.defaultMinNodes);
    }

    private ExoCache create(ExoCacheConfig config, TreeCache cache, int maxNodes, int minNodes) throws ExoCacheInitException {
        RegionManager regionManager = cache.getEvictionRegionManager();
        LFUConfiguration lfu = new LFUConfiguration();
        lfu.setMaxNodes(maxNodes);
        lfu.setMinNodes(minNodes);
        LFUPolicy policy = new LFUPolicy();
        policy.configure(cache);
        try {
            regionManager.createRegion(RegionManager.DEFAULT_REGION, (EvictionPolicy)policy, (EvictionConfiguration)lfu);
        }
        catch (RegionNameConflictException e) {
            throw new ExoCacheInitException("Cannot create the region", (Throwable)e);
        }
        return new LFUExoCache(config, cache, lfu);
    }

    @Override
    public Class<? extends ExoCacheConfig> getExpectedConfigType() {
        return LFUExoCacheConfig.class;
    }

    @Override
    public String getExpectedImplementation() {
        return EXPECTED_IMPL;
    }

    public static class LFUExoCache
    extends AbstractExoCache {
        private final LFUConfiguration lfu;

        public LFUExoCache(ExoCacheConfig config, TreeCache cache, LFUConfiguration lfu) {
            super(config, cache);
            this.lfu = lfu;
        }

        public long getLiveTime() {
            throw new UnsupportedOperationException();
        }

        @ManagedName(value="MaxNodes")
        @ManagedDescription(value="This is the maximum number of nodes allowed in this region. A value of 0 for maxNodes means that there is no upper bound for the configured cache region.")
        public int getMaxSize() {
            return this.lfu.getMaxNodes();
        }

        @Managed
        @ManagedName(value="MinNodes")
        @ManagedDescription(value="This is the minimum number of nodes allowed in this region. This value determines what the eviction queue should prune down to per pass. e.g. If minNodes is 10 and the cache grows to 100 nodes, the cache is pruned down to the 10 most frequently used nodes when the eviction timer makes a pass through the eviction algorithm.")
        public long getMinNodes() {
            return this.lfu.getMinNodes();
        }

        public void setLiveTime(long period) {
            throw new UnsupportedOperationException();
        }

        public void setMaxSize(int max) {
            this.lfu.setMaxNodes(max);
        }

        @Managed
        public void setMinNodes(int minNodes) {
            this.lfu.setMinNodes(minNodes);
        }
    }
}

