/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.jboss.cache.AbstractTreeCacheListener;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.transaction.DummyUserTransaction;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExoCache
implements ExoCache {
    private static final Log LOG = ExoLogger.getLogger(AbstractExoCache.class);
    protected final AtomicInteger size = new AtomicInteger();
    private volatile int hits;
    private volatile int misses;
    private String label;
    private String name;
    private boolean distributed;
    private boolean replicated;
    private boolean logEnabled;
    private final CopyOnWriteArrayList<CacheListener> listeners;
    protected final TreeCache cache;

    public AbstractExoCache(ExoCacheConfig config, TreeCache cache) {
        this.cache = cache;
        this.listeners = new CopyOnWriteArrayList();
        this.setDistributed(config.isDistributed());
        this.setLabel(config.getLabel());
        this.setName(config.getName());
        this.setLogEnabled(config.isLogEnabled());
        this.setReplicated(config.isRepicated());
        cache.addTreeCacheListener((TreeCacheListener)new SizeManager());
    }

    public void addCacheListener(CacheListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void clearCache() throws Exception {
        try {
            Set names = this.cache.getChildrenNames(Fqn.ROOT);
            if (names != null && !names.isEmpty()) {
                for (Object name : names) {
                    Node node = this.cache.get(new Fqn(name));
                    if (node == null) continue;
                    this.remove(this.getKey(node));
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot excecute clearCache properly", (Throwable)e);
        }
        this.onClearCache();
    }

    public Object get(Serializable name) throws Exception {
        Object result = this.cache.get(new Fqn((Object)name), (Object)name);
        if (result == null) {
            ++this.misses;
        } else {
            ++this.hits;
        }
        this.onGet(name, result);
        return result;
    }

    public int getCacheHit() {
        return this.hits;
    }

    public int getCacheMiss() {
        return this.misses;
    }

    public int getCacheSize() {
        return this.cache.getNumberOfNodes();
    }

    public List<Object> getCachedObjects() {
        LinkedList<Object> list = new LinkedList<Object>();
        try {
            Set names = this.cache.getChildrenNames(Fqn.ROOT);
            if (names == null || names.isEmpty()) {
                return list;
            }
            for (Object name : names) {
                Object value;
                Node node = this.cache.get(new Fqn(name));
                if (node == null || (value = node.get((Object)this.getKey(node))) == null) continue;
                list.add(value);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot excecute getCachedObjects properly", (Throwable)e);
        }
        return list;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public void put(Serializable name, Object obj) throws Exception {
        this.putOnly(name, obj);
        this.onPut(name, obj);
    }

    private Object putOnly(Serializable name, Object obj) throws Exception {
        return this.cache.put(new Fqn((Object)name), (Object)name, obj);
    }

    public void putMap(Map<Serializable, Object> objs) throws Exception {
        DummyUserTransaction tx = new DummyUserTransaction(DummyTransactionManager.getInstance());
        try {
            tx.begin();
            for (Map.Entry<Serializable, Object> entry : objs.entrySet()) {
                this.putOnly(entry.getKey(), entry.getValue());
            }
            tx.commit();
            for (Map.Entry<Serializable, Object> entry : objs.entrySet()) {
                this.onPut(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
    }

    public Object remove(Serializable name) throws Exception {
        Fqn fqn = new Fqn((Object)name);
        Node node = this.cache.get(fqn);
        if (node != null) {
            Object result = node.get((Object)name);
            this.cache.remove(fqn);
            this.onRemove(name, result);
            return result;
        }
        return null;
    }

    public List<Object> removeCachedObjects() throws Exception {
        List<Object> list = this.getCachedObjects();
        this.clearCache();
        return list;
    }

    public void select(CachedObjectSelector selector) throws Exception {
        Set names = this.cache.getChildrenNames(Fqn.ROOT);
        if (names == null || names.isEmpty()) {
            return;
        }
        for (Object name : names) {
            Object value;
            ObjectCacheInfo info;
            Serializable key;
            Node node = this.cache.get(new Fqn(name));
            if (node == null || !selector.select(key = this.getKey(node), info = new ObjectCacheInfo(value = node.get((Object)key)){
                final /* synthetic */ Object val$value;
                {
                    this.val$value = object;
                }

                public Object get() {
                    return this.val$value;
                }

                public long getExpireTime() {
                    return -1L;
                }
            })) continue;
            selector.onSelect((ExoCache)this, key, info);
        }
    }

    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    private Serializable getKey(Node node) {
        return this.getKey(node.getFqn());
    }

    private Serializable getKey(Fqn fqn) {
        return (Serializable)fqn.get(0);
    }

    void onExpire(Serializable key, Object obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onExpire((ExoCache)this, key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onRemove(Serializable key, Object obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onRemove((ExoCache)this, key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onPut(Serializable key, Object obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onPut((ExoCache)this, key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onGet(Serializable key, Object obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onGet((ExoCache)this, key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onClearCache() {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (CacheListener listener : this.listeners) {
            try {
                listener.onClearCache((ExoCache)this);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    public class SizeManager
    extends AbstractTreeCacheListener {
        public void cacheStarted(TreeCache cache) {
        }

        public void cacheStopped(TreeCache cache) {
        }

        public void nodeEvicted(Fqn fqn) {
            AbstractExoCache.this.onExpire(AbstractExoCache.this.getKey(fqn), null);
        }

        public void nodeRemoved(Fqn fqn) {
        }

        public void nodeRemove(Fqn fqn, boolean pre, boolean isLocal) {
            if (pre && !isLocal) {
                Serializable key = AbstractExoCache.this.getKey(fqn);
                Object value = null;
                try {
                    value = AbstractExoCache.this.cache.get(fqn, (Object)key);
                }
                catch (CacheException e) {
                    // empty catch block
                }
                AbstractExoCache.this.onRemove(key, value);
            }
        }

        public void nodeCreated(Fqn fqn) {
        }

        public void nodeLoaded(Fqn fqn) {
        }

        public void nodeVisited(Fqn fqn) {
        }

        public void nodeModified(Fqn fqn) {
        }

        public void nodeModify(Fqn fqn, boolean pre, boolean isLocal) {
            if (!isLocal && !pre) {
                Serializable key = AbstractExoCache.this.getKey(fqn);
                Object value = null;
                try {
                    value = AbstractExoCache.this.cache.get(fqn, (Object)key);
                }
                catch (CacheException e) {
                    // empty catch block
                }
                AbstractExoCache.this.onPut(key, value);
            }
        }

        public void viewChange(View paramView) {
        }
    }
}

