/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss.lru;

import java.io.Serializable;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.jboss.AbstractExoCache;
import org.exoplatform.services.cache.impl.jboss.ExoCacheCreator;
import org.exoplatform.services.cache.impl.jboss.lru.LRUExoCacheConfig;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUAlgorithmConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUExoCacheCreator
implements ExoCacheCreator {
    public static final String EXPECTED_IMPL = "LRU";
    protected long defaultTimeToLive;
    protected long defaultMaxAge;

    @Override
    public ExoCache create(ExoCacheConfig config, Cache<Serializable, Object> cache) throws ExoCacheInitException {
        if (config instanceof LRUExoCacheConfig) {
            LRUExoCacheConfig lruConfig = (LRUExoCacheConfig)config;
            return this.create(config, cache, lruConfig.getMaxNodes(), lruConfig.getTimeToLive(), lruConfig.getMaxAge(), lruConfig.getMinTimeToLive());
        }
        long period = config.getLiveTime();
        return this.create(config, cache, config.getMaxSize(), this.defaultTimeToLive, this.defaultMaxAge, period > 0L ? period * 1000L : 0L);
    }

    private ExoCache create(ExoCacheConfig config, Cache<Serializable, Object> cache, int maxNodes, long timeToLive, long maxAge, long minTimeToLive) throws ExoCacheInitException {
        Configuration configuration = cache.getConfiguration();
        LRUAlgorithmConfig lru = new LRUAlgorithmConfig(timeToLive, maxAge, maxNodes);
        lru.setMinTimeToLive(minTimeToLive);
        EvictionRegionConfig erc = new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)lru);
        EvictionConfig evictionConfig = configuration.getEvictionConfig();
        evictionConfig.setDefaultEvictionRegionConfig(erc);
        return new LRUExoCache(config, cache, lru);
    }

    @Override
    public Class<? extends ExoCacheConfig> getExpectedConfigType() {
        return LRUExoCacheConfig.class;
    }

    @Override
    public String getExpectedImplementation() {
        return EXPECTED_IMPL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LRUExoCache
    extends AbstractExoCache {
        private final LRUAlgorithmConfig lru;

        public LRUExoCache(ExoCacheConfig config, Cache<Serializable, Object> cache, LRUAlgorithmConfig lru) {
            super(config, cache);
            this.lru = lru;
        }

        @ManagedName(value="MinTimeToLive")
        @ManagedDescription(value="the minimum amount of time a node must be allowed to live after being accessed before it is allowed to be considered for eviction. 0 denotes that this feature is disabled, which is the default value.")
        public long getLiveTime() {
            return this.lru.getMinTimeToLive();
        }

        @ManagedName(value="MaxNodes")
        @ManagedDescription(value="This is the maximum number of nodes allowed in this region. 0 denotes immediate expiry, -1 denotes no limit.")
        public int getMaxSize() {
            return this.lru.getMaxNodes();
        }

        @Managed
        @ManagedName(value="TimeToLive")
        @ManagedDescription(value="The amount of time a node is not written to or read (in milliseconds) before the node is swept away. 0 denotes immediate expiry, -1 denotes no limit.")
        public long getTimeToLive() {
            return this.lru.getTimeToLive();
        }

        @Managed
        @ManagedName(value="MaxAges")
        @ManagedDescription(value="Lifespan of a node (in milliseconds) regardless of idle time before the node is swept away. 0 denotes immediate expiry, -1 denotes no limit.")
        public long getMaxAge() {
            return this.lru.getMaxAge();
        }

        public void setLiveTime(long period) {
            this.lru.setMinTimeToLive(period);
        }

        public void setMaxSize(int max) {
            this.lru.setMaxNodes(max);
        }

        @Managed
        public void setTimeToLive(long timeToLive) {
            this.lru.setTimeToLive(timeToLive);
        }

        @Managed
        public void setMaxAge(long maxAge) {
            this.lru.setMaxAge(maxAge);
        }
    }
}

