/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Qualifier;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.CachingContainerMT;
import org.exoplatform.container.ComponentAdapterDependenciesAware;
import org.exoplatform.container.ComponentTask;
import org.exoplatform.container.ComponentTaskContext;
import org.exoplatform.container.ComponentTaskType;
import org.exoplatform.container.ConcurrentContainer;
import org.exoplatform.container.Dependency;
import org.exoplatform.container.DependencyByName;
import org.exoplatform.container.DependencyByProvider;
import org.exoplatform.container.DependencyByQualifier;
import org.exoplatform.container.DependencyByType;
import org.exoplatform.container.DependencyStack;
import org.exoplatform.container.DependencyStackListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.InstanceComponentAdapter;
import org.exoplatform.container.LockManager;
import org.exoplatform.container.Mode;
import org.exoplatform.container.TopExoContainer;
import org.exoplatform.container.TopExoContainerListener;
import org.exoplatform.container.management.ManageableComponentAdapterFactoryMT;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.container.spi.ComponentAdapterFactory;
import org.exoplatform.container.spi.ContainerException;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentContainerMT
extends ConcurrentContainer
implements TopExoContainerListener {
    private static final long serialVersionUID = -1059330085804288350L;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.mt.ConcurrentContainerMT");
    private static volatile transient ThreadPoolExecutor EXECUTOR;
    private final transient ThreadLocal<ComponentTaskContext> currentCtx = new ThreadLocal();
    private final transient ConcurrentMap<Object, ConcurrentContainer.CreationalContextComponentAdapter<?>> sharedMemory = new ConcurrentHashMap();
    public static final String THREAD_POOL_SIZE_PARAM_NAME = "org.exoplatform.container.mt.tps";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ThreadPoolExecutor getExecutor() {
        if (EXECUTOR != null || !Mode.hasMode(Mode.MULTI_THREADED)) return EXECUTOR;
        Class<ConcurrentContainerMT> clazz = ConcurrentContainerMT.class;
        synchronized (ConcurrentContainerMT.class) {
            int threadPoolSize;
            if (EXECUTOR != null) return EXECUTOR;
            String sValue = PropertyManager.getProperty((String)THREAD_POOL_SIZE_PARAM_NAME);
            if (sValue != null) {
                LOG.debug((Object)("A value for the thread pool size has been found, it has been set to '" + sValue + "'"));
                threadPoolSize = Integer.parseInt(sValue);
            } else {
                threadPoolSize = Math.min(2 * Runtime.getRuntime().availableProcessors(), 30);
            }
            LOG.debug((Object)("The size of the thread pool used by the kernel has been set to " + threadPoolSize));
            EXECUTOR = new KernelThreadPoolExecutor(threadPoolSize);
            // ** MonitorExit[var0] (shouldn't be in output)
            return EXECUTOR;
        }
    }

    public ConcurrentContainerMT() {
    }

    public ConcurrentContainerMT(ExoContainer holder, ExoContainer parent) {
        this.setParent(parent);
        this.setHolder(holder);
    }

    public void initialize() {
        if (this.holder instanceof TopExoContainer) {
            ((TopExoContainer)this.holder).addListener((TopExoContainerListener)this);
        }
    }

    protected ComponentAdapterFactory getDefaultComponentAdapterFactory() {
        return new ManageableComponentAdapterFactoryMT(this.holder, this);
    }

    protected <T> T getComponentInstanceFromContext(ComponentAdapter<T> componentAdapter, Class<T> bindType) {
        T result;
        ComponentTaskContext ctx = this.currentCtx.get();
        if (ctx != null && (result = ctx.getComponentInstanceFromContext(componentAdapter.getComponentKey(), bindType)) != null) {
            this.getCache().disable();
            return result;
        }
        return null;
    }

    public <T> T getComponentFromSharedMemory(Object key) {
        ConcurrentContainer.CreationalContextComponentAdapter ccca = (ConcurrentContainer.CreationalContextComponentAdapter)this.sharedMemory.get(key);
        return (T)(ccca == null ? null : ccca.get());
    }

    public <T> ConcurrentContainer.CreationalContextComponentAdapter<T> addComponentToCtx(Object key) {
        ComponentTaskContext ctx = this.currentCtx.get();
        ConcurrentContainer.CreationalContextComponentAdapter ccca = new ConcurrentContainer.CreationalContextComponentAdapter();
        this.sharedMemory.put(key, ccca);
        return ctx.addComponentToContext(key, ccca);
    }

    public void removeComponentFromCtx(Object key) {
        ComponentTaskContext ctx = this.currentCtx.get();
        ConcurrentContainer.CreationalContextComponentAdapter<?> ccca = ctx.removeComponentFromContext(key);
        this.sharedMemory.remove(key, ccca);
    }

    public <T> List<T> getComponentInstancesOfType(final Class<T> componentType) throws ContainerException {
        ThreadPoolExecutor executor;
        if (componentType == null) {
            return Collections.emptyList();
        }
        List adapters = this.getComponentAdaptersOfType(componentType);
        if (adapters == null || adapters.isEmpty()) {
            return Collections.emptyList();
        }
        boolean enableMultiThreading = Mode.hasMode(Mode.MULTI_THREADED) && adapters.size() > 1;
        ArrayList submittedTasks = null;
        final AbstractMap adapterToInstanceMap = enableMultiThreading ? new ConcurrentHashMap() : new HashMap();
        ThreadPoolExecutor threadPoolExecutor = executor = enableMultiThreading ? ConcurrentContainerMT.getExecutor() : null;
        if (enableMultiThreading && executor == null) {
            enableMultiThreading = false;
        }
        for (final ComponentAdapter adapter : adapters) {
            if (enableMultiThreading && LockManager.getInstance().getTotalUncompletedTasks() < executor.getCorePoolSize() && !(adapter instanceof InstanceComponentAdapter)) {
                final ExoContainer container = ExoContainerContext.getCurrentContainerIfPresent();
                final ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Runnable task = new Runnable(){

                    public void run() {
                        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Void run() {
                                ExoContainer oldContainer = ExoContainerContext.getCurrentContainerIfPresent();
                                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                                try {
                                    ExoContainerContext.setCurrentContainer((ExoContainer)container);
                                    Thread.currentThread().setContextClassLoader(cl);
                                    Object o = ConcurrentContainerMT.this.getInstance(adapter, componentType, false);
                                    if (o != null) {
                                        adapterToInstanceMap.put(adapter, o);
                                    }
                                    ConcurrentContainerMT.this.addOrderedComponentAdapter(adapter);
                                }
                                finally {
                                    Thread.currentThread().setContextClassLoader(oldCl);
                                    ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                                }
                                return null;
                            }
                        });
                    }
                };
                if (submittedTasks == null) {
                    submittedTasks = new ArrayList();
                }
                submittedTasks.add(executor.submit(task));
                continue;
            }
            if (enableMultiThreading) {
                Object o = this.getInstance(adapter, componentType, false);
                if (o != null) {
                    adapterToInstanceMap.put(adapter, o);
                }
                this.addOrderedComponentAdapter(adapter);
                continue;
            }
            adapterToInstanceMap.put(adapter, this.getInstance(adapter, componentType, false));
            this.addOrderedComponentAdapter(adapter);
        }
        if (submittedTasks != null) {
            int length = submittedTasks.size();
            for (int i = 0; i < length; ++i) {
                Future task = (Future)submittedTasks.get(i);
                try {
                    task.get();
                    continue;
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException(cause);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Object componentAdapter : this.orderedComponentAdapters) {
            Object componentInstance = adapterToInstanceMap.get(componentAdapter);
            if (componentInstance == null) continue;
            result.add(componentType.cast(componentInstance));
        }
        return result;
    }

    public void start() {
        List startables;
        this.holder.getContextManager();
        this.getComponentInstancesOfType(Startable.class);
        List adapters = startables = this.getComponentAdaptersOfType(Startable.class);
        ConcurrentHashMap alreadyStarted = new ConcurrentHashMap();
        AtomicReference<Exception> error = new AtomicReference<Exception>();
        this.start(adapters, alreadyStarted, new HashSet(), error, true);
        if (error.get() != null) {
            throw new RuntimeException("Could not start the container", error.get());
        }
        for (ExoContainer child : this.children) {
            child.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(Collection<ComponentAdapter<?>> adapters, final Map<ComponentAdapter<?>, Object> alreadyStarted, final Set<ComponentAdapter<?>> startInProgress, final AtomicReference<Exception> error, final boolean skippable) {
        ThreadPoolExecutor executor;
        if (adapters == null || adapters.isEmpty()) {
            return;
        }
        boolean enableMultiThreading = Mode.hasMode(Mode.MULTI_THREADED) && adapters.size() > 1;
        ArrayList submittedTasks = null;
        ThreadPoolExecutor threadPoolExecutor = executor = enableMultiThreading ? ConcurrentContainerMT.getExecutor() : null;
        if (enableMultiThreading && executor == null) {
            enableMultiThreading = false;
        }
        for (final ComponentAdapter<?> adapter : adapters) {
            ComponentAdapter<?> cada;
            if (error.get() != null) break;
            if (ExoContainer.class.isAssignableFrom(adapter.getComponentImplementation()) || alreadyStarted.containsKey(adapter) || skippable && startInProgress.contains(adapter)) continue;
            if (enableMultiThreading && LockManager.getInstance().getTotalUncompletedTasks() < executor.getCorePoolSize() && !(adapter instanceof InstanceComponentAdapter)) {
                final ExoContainer container = ExoContainerContext.getCurrentContainerIfPresent();
                final ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Runnable task = new Runnable(){

                    public void run() {
                        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Void run() {
                                if (error.get() != null) {
                                    return null;
                                }
                                if (alreadyStarted.containsKey(adapter) || skippable && startInProgress.contains(adapter)) {
                                    return null;
                                }
                                ExoContainer oldContainer = ExoContainerContext.getCurrentContainerIfPresent();
                                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                                try {
                                    ComponentAdapterDependenciesAware cada;
                                    ExoContainerContext.setCurrentContainer((ExoContainer)container);
                                    Thread.currentThread().setContextClassLoader(cl);
                                    if (adapter instanceof ComponentAdapterDependenciesAware) {
                                        cada = (ComponentAdapterDependenciesAware)adapter;
                                        ConcurrentContainerMT.this.startDependencies(alreadyStarted, startInProgress, error, cada);
                                    }
                                    if (!Startable.class.isAssignableFrom(adapter.getComponentImplementation())) {
                                        alreadyStarted.put(adapter, adapter);
                                        cada = null;
                                        return cada;
                                    }
                                    if (alreadyStarted.containsKey(adapter)) {
                                        cada = null;
                                        return cada;
                                    }
                                    cada = adapter;
                                    synchronized (cada) {
                                        block20: {
                                            if (!alreadyStarted.containsKey(adapter)) break block20;
                                            Void void_ = null;
                                            return void_;
                                        }
                                        try {
                                            Startable startable = (Startable)adapter.getComponentInstance();
                                            startable.start();
                                        }
                                        finally {
                                            alreadyStarted.put(adapter, adapter);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    error.compareAndSet(null, e);
                                }
                                finally {
                                    Thread.currentThread().setContextClassLoader(oldCl);
                                    ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                                }
                                return null;
                            }
                        });
                    }
                };
                if (submittedTasks == null) {
                    submittedTasks = new ArrayList();
                }
                submittedTasks.add(executor.submit(task));
                continue;
            }
            if (adapter instanceof ComponentAdapterDependenciesAware) {
                cada = adapter;
                this.startDependencies(alreadyStarted, startInProgress, error, (ComponentAdapterDependenciesAware<?>)cada);
            }
            if (!Startable.class.isAssignableFrom(adapter.getComponentImplementation())) {
                alreadyStarted.put(adapter, adapter);
                continue;
            }
            if (alreadyStarted.containsKey(adapter)) continue;
            cada = adapter;
            synchronized (cada) {
                if (alreadyStarted.containsKey(adapter)) {
                    continue;
                }
                try {
                    Startable startable = (Startable)adapter.getComponentInstance();
                    startable.start();
                }
                catch (Exception e) {
                    error.compareAndSet(null, e);
                }
                finally {
                    alreadyStarted.put(adapter, adapter);
                }
            }
        }
        if (submittedTasks != null) {
            int length = submittedTasks.size();
            for (int i = 0; i < length; ++i) {
                Future task = (Future)submittedTasks.get(i);
                try {
                    task.get();
                    continue;
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException(cause);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private Collection<ComponentAdapter<?>> getDependencies(Collection<Dependency> dependencies, boolean withLazy, boolean withNonLazy) {
        if (dependencies == null || dependencies.isEmpty()) {
            return null;
        }
        LinkedHashSet result = new LinkedHashSet();
        for (Dependency dep : dependencies) {
            ComponentAdapter<?> adapter;
            boolean isLocal;
            if (dep.isLazy() && !withLazy || !dep.isLazy() && !withNonLazy || !(isLocal = this.componentAdapters.contains(adapter = dep.getAdapter(this.holder)))) continue;
            result.add(adapter);
        }
        return result;
    }

    public <T> Constructor<T> getConstructor(Class<T> clazz, List<Dependency> dependencies) throws Exception {
        Constructor[] constructors = new Constructor[]{};
        try {
            constructors = ContainerUtil.getSortedConstructors(clazz);
        }
        catch (NoClassDefFoundError err) {
            throw new Exception("Cannot resolve constructor for class " + clazz.getName(), err);
        }
        Class<?> unknownParameter = null;
        for (int k = 0; k < constructors.length; ++k) {
            Constructor constructor = constructors[k];
            Class<?>[] parameters = constructor.getParameterTypes();
            Object[] args = new Object[parameters.length];
            boolean constructorWithInject = constructors.length == 1 && constructor.isAnnotationPresent(Inject.class);
            boolean satisfied = true;
            String logMessagePrefix = null;
            Type[] genericTypes = null;
            Annotation[][] parameterAnnotations = null;
            if (constructorWithInject) {
                genericTypes = constructor.getGenericParameterTypes();
                parameterAnnotations = constructor.getParameterAnnotations();
            }
            if (LOG.isDebugEnabled() && constructorWithInject) {
                logMessagePrefix = "Could not call the constructor of the class " + clazz.getName();
            }
            for (int i = 0; i < args.length; ++i) {
                if (parameters[i].equals(InitParams.class)) continue;
                if (constructorWithInject) {
                    Object result = this.resolveType(parameters[i], genericTypes[i], parameterAnnotations[i], logMessagePrefix, dependencies);
                    if (!(result instanceof Integer)) {
                        args[i] = result;
                    }
                } else {
                    Class<?> componentType = parameters[i];
                    args[i] = this.holder.getComponentAdapterOfType(componentType);
                    dependencies.add(new DependencyByType(componentType));
                }
                if (args[i] != null) continue;
                satisfied = false;
                unknownParameter = parameters[i];
                dependencies.clear();
                break;
            }
            if (!satisfied) continue;
            if (!(Modifier.isPublic(constructor.getModifiers()) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers()) || constructor.isAccessible())) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        throw new Exception("Cannot find a satisfying constructor for " + clazz + " with parameter " + unknownParameter);
    }

    public <T> boolean initializeComponent(Class<T> targetClass, List<Dependency> dependencies, List<ComponentTask<Void>> componentInitTasks, DependencyStackListener caller) {
        LinkedList<Class<T>> hierarchy = new LinkedList<Class<T>>();
        Class<T> clazz = targetClass;
        do {
            hierarchy.addFirst(clazz);
        } while (!(clazz = clazz.getSuperclass()).equals(Object.class));
        HashMap methodAlreadyRegistered = new HashMap();
        HashMap methodsPerClass = new HashMap();
        for (Class clazz2 : hierarchy) {
            this.addMethods(clazz2, methodAlreadyRegistered, methodsPerClass);
        }
        boolean isInjectPresent = !methodAlreadyRegistered.isEmpty();
        for (Class clazz3 : hierarchy) {
            if (this.initializeFields(targetClass, clazz3, dependencies, componentInitTasks, caller)) {
                isInjectPresent = true;
            }
            this.initializeMethods(targetClass, (Collection)methodsPerClass.get(clazz3), dependencies, componentInitTasks, caller);
        }
        return isInjectPresent;
    }

    private <T> void initializeMethods(final Class<T> targetClass, Collection<Method> methods, List<Dependency> dependencies, List<ComponentTask<Void>> componentInitTasks, DependencyStackListener caller) {
        if (methods == null) {
            return;
        }
        block2: for (final Method m : methods) {
            if (!m.isAnnotationPresent(Inject.class)) continue;
            if (Modifier.isAbstract(m.getModifiers())) {
                LOG.warn((Object)("Could not call the method " + m.getName() + " of the class " + targetClass.getName() + ": The method cannot be abstract"));
                continue;
            }
            if (Modifier.isStatic(m.getModifiers())) {
                LOG.warn((Object)("Could not call the method " + m.getName() + " of the class " + targetClass.getName() + ": The method cannot be static"));
                continue;
            }
            Class<?>[] paramTypes = m.getParameterTypes();
            final Object[] params = new Object[paramTypes.length];
            Type[] genericTypes = m.getGenericParameterTypes();
            Annotation[][] parameterAnnotations = m.getParameterAnnotations();
            String logMessagePrefix = null;
            if (LOG.isDebugEnabled()) {
                logMessagePrefix = "Could not call the method " + m.getName() + " of the class " + targetClass.getName();
            }
            int l = paramTypes.length;
            for (int j = 0; j < l; ++j) {
                Object result = this.resolveType(paramTypes[j], genericTypes[j], parameterAnnotations[j], logMessagePrefix, dependencies);
                if (result instanceof Integer) {
                    int r = (Integer)result;
                    if (r == 1 || r == 2) continue block2;
                    params[j] = null;
                    continue;
                }
                params[j] = dependencies.get(dependencies.size() - 1);
            }
            try {
                if (!(Modifier.isPublic(m.getModifiers()) && Modifier.isPublic(m.getDeclaringClass().getModifiers()) || m.isAccessible())) {
                    m.setAccessible(true);
                }
                componentInitTasks.add(new ComponentTask<Void>("Call the method " + m.getName() + " of the class " + targetClass.getName(), this, caller, ComponentTaskType.INIT){

                    @Override
                    public Void execute(ConcurrentContainer.CreationalContextComponentAdapter<?> cCtx) throws Exception {
                        try {
                            ConcurrentContainerMT.this.loadArguments(params);
                            m.invoke(cCtx.get(), params);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Could not call the method " + m.getName() + " of the class " + targetClass.getName() + ": " + e.getMessage(), e);
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException("Could not call the method " + m.getName() + " of the class " + targetClass.getName() + ": " + e.getMessage(), e);
            }
        }
    }

    private <T> boolean initializeFields(final Class<T> targetClass, Class<?> clazz, List<Dependency> dependencies, List<ComponentTask<Void>> componentInitTasks, DependencyStackListener caller) {
        boolean isInjectPresent = false;
        for (final Field f : clazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Inject.class)) continue;
            isInjectPresent = true;
            if (Modifier.isFinal(f.getModifiers())) {
                LOG.warn((Object)("Could not set a value to the field " + f.getName() + " of the class " + targetClass.getName() + ": The field cannot be final"));
                continue;
            }
            if (Modifier.isStatic(f.getModifiers())) {
                LOG.warn((Object)("Could not set a value to the field " + f.getName() + " of the class " + targetClass.getName() + ": The field cannot be static"));
                continue;
            }
            try {
                Object result;
                if (!(Modifier.isPublic(f.getModifiers()) && Modifier.isPublic(f.getDeclaringClass().getModifiers()) || f.isAccessible())) {
                    f.setAccessible(true);
                }
                String logMessagePrefix = null;
                if (LOG.isDebugEnabled()) {
                    logMessagePrefix = "Could not set a value to the field " + f.getName() + " of the class " + targetClass.getName();
                }
                if ((result = this.resolveType(f.getType(), f.getGenericType(), f.getAnnotations(), logMessagePrefix, dependencies)) instanceof Integer) continue;
                final Dependency dependency = dependencies.get(dependencies.size() - 1);
                componentInitTasks.add(new ComponentTask<Void>("Set a value to the field " + f.getName() + " of the class " + targetClass.getName(), this, caller, ComponentTaskType.INIT){

                    @Override
                    public Void execute(ConcurrentContainer.CreationalContextComponentAdapter<?> cCtx) throws Exception {
                        try {
                            f.set(cCtx.get(), dependency.load(ConcurrentContainerMT.this.holder));
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Could not set a value to the field " + f.getName() + " of the class " + targetClass.getName() + ": " + e.getMessage(), e);
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set a value to the field " + f.getName() + " of the class " + targetClass.getName() + ": " + e.getMessage(), e);
            }
        }
        return isInjectPresent;
    }

    private Object resolveType(Class<?> type, Type genericType, Annotation[] annotations, String logMessagePrefix, List<Dependency> dependencies) {
        if (type.isPrimitive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(logMessagePrefix + ": Primitive types are not supported"));
            }
            return 1;
        }
        Named named = null;
        Class<? extends Annotation> qualifier = null;
        for (Annotation a : annotations) {
            if (a instanceof Named) {
                named = (Named)a;
                break;
            }
            if (!a.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            qualifier = a.annotationType();
            break;
        }
        if (type.isInterface() && type.equals(Provider.class)) {
            ComponentAdapter adapter;
            Class<? extends Annotation> key;
            if (!(genericType instanceof ParameterizedType)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(logMessagePrefix + ": The generic type is not of type ParameterizedType"));
                }
                return 2;
            }
            ParameterizedType aType = (ParameterizedType)genericType;
            Type[] typeVars = aType.getActualTypeArguments();
            Class expectedType = (Class)typeVars[0];
            if (named != null) {
                key = named.value();
                adapter = this.holder.getComponentAdapter((Object)key, expectedType);
            } else if (qualifier != null) {
                key = qualifier;
                adapter = this.holder.getComponentAdapter(key, expectedType);
            } else {
                key = expectedType;
                adapter = this.holder.getComponentAdapterOfType(expectedType);
            }
            if (adapter == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(logMessagePrefix + ": We have no value to set so we skip it"));
                }
                return 3;
            }
            Provider<Object> result = new Provider<Object>(){

                public Object get() {
                    return adapter.getComponentInstance();
                }
            };
            dependencies.add(new DependencyByProvider(key, expectedType, result, adapter));
            return result;
        }
        if (named != null) {
            String name = named.value();
            dependencies.add(new DependencyByName(name, type));
            return this.holder.getComponentAdapter((Object)name, type);
        }
        if (qualifier != null) {
            dependencies.add(new DependencyByQualifier(qualifier, type));
            return this.holder.getComponentAdapter(qualifier, type);
        }
        dependencies.add(new DependencyByType(type));
        return this.holder.getComponentAdapterOfType(type);
    }

    public <T> T createComponent(Class<T> clazz) throws Exception {
        return this.createComponent(clazz, null);
    }

    public <T> T createComponent(Class<T> clazz, InitParams params) throws Exception {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        Constructor<T> constructor = this.getConstructor(clazz, dependencies);
        Object[] args = this.getArguments(constructor, params, dependencies);
        this.loadArguments(args);
        return constructor.getDeclaringClass().cast(constructor.newInstance(args));
    }

    public <T> ComponentTask<T> createComponentTask(final Constructor<T> constructor, InitParams params, List<Dependency> dependencies, DependencyStackListener caller) throws Exception {
        final Object[] args = this.getArguments(constructor, params, dependencies);
        return new ComponentTask<T>(this, caller, ComponentTaskType.CREATE){

            @Override
            public T execute(ConcurrentContainer.CreationalContextComponentAdapter<?> cCtx) throws Exception {
                ConcurrentContainerMT.this.loadArguments(args);
                return constructor.getDeclaringClass().cast(constructor.newInstance(args));
            }
        };
    }

    public void loadArguments(Object[] args) {
        try {
            int length = args.length;
            for (int i = 0; i < length; ++i) {
                if (!(args[i] instanceof Dependency)) continue;
                args[i] = ((Dependency)args[i]).load(this.holder);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load the arguments", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDependencies(Object originalComponentKey, final ComponentTaskContext ctx, Collection<Dependency> dependencies, final ComponentTaskType type) throws Exception {
        ThreadPoolExecutor executor;
        if (dependencies.isEmpty()) {
            return;
        }
        ArrayList submittedTasks = null;
        boolean enableMultiThreading = Mode.hasMode(Mode.MULTI_THREADED) && dependencies.size() > 1;
        ThreadPoolExecutor threadPoolExecutor = executor = enableMultiThreading ? ConcurrentContainerMT.getExecutor() : null;
        if (enableMultiThreading && executor == null) {
            enableMultiThreading = false;
        }
        for (final Dependency dependency : dependencies) {
            if (dependency.getKey().equals(originalComponentKey) || dependency.isLazy()) continue;
            if (enableMultiThreading && LockManager.getInstance().getTotalUncompletedTasks() < executor.getCorePoolSize() && !(dependency.getAdapter(this.holder) instanceof InstanceComponentAdapter)) {
                final ExoContainer container = ExoContainerContext.getCurrentContainerIfPresent();
                final ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Runnable task = new Runnable(){

                    public void run() {
                        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Object run() {
                                ExoContainer oldContainer = ExoContainerContext.getCurrentContainerIfPresent();
                                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                                ComponentTaskContext previousCtx = (ComponentTaskContext)ConcurrentContainerMT.this.currentCtx.get();
                                try {
                                    ExoContainerContext.setCurrentContainer((ExoContainer)container);
                                    Thread.currentThread().setContextClassLoader(cl);
                                    ConcurrentContainerMT.this.currentCtx.set(ctx.addToContext(dependency.getKey(), type));
                                    Object object = dependency.load(ConcurrentContainerMT.this.holder);
                                    return object;
                                }
                                finally {
                                    Thread.currentThread().setContextClassLoader(oldCl);
                                    ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                                    ConcurrentContainerMT.this.currentCtx.set(previousCtx);
                                }
                            }
                        });
                    }
                };
                if (submittedTasks == null) {
                    submittedTasks = new ArrayList();
                }
                submittedTasks.add(executor.submit(task));
                continue;
            }
            ComponentTaskContext previousCtx = this.currentCtx.get();
            try {
                this.currentCtx.set(ctx.addToContext(dependency.getKey(), type));
                dependency.load(this.holder);
            }
            finally {
                this.currentCtx.set(previousCtx);
            }
        }
        if (submittedTasks != null) {
            int length = submittedTasks.size();
            for (int i = 0; i < length; ++i) {
                Future task = (Future)submittedTasks.get(i);
                try {
                    task.get();
                    continue;
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    throw new Exception(cause);
                }
            }
        }
    }

    public ComponentTaskContext getComponentTaskContext() {
        return this.currentCtx.get();
    }

    public void setComponentTaskContext(ComponentTaskContext ctx) {
        this.currentCtx.set(ctx);
    }

    protected <T> T execute(ComponentTask<T> task, ConcurrentContainer.CreationalContextComponentAdapter<?> cCtx) throws Exception {
        Deque<DependencyStack> stacks = null;
        CachingContainerMT cache = (CachingContainerMT)this.getCache();
        ThreadLocal<Deque<DependencyStack>> dependencyStacks = cache.dependencyStacks;
        try {
            Object stack;
            if (dependencyStacks != null) {
                stacks = dependencyStacks.get();
                if (stacks == null) {
                    stacks = new LinkedList<DependencyStack>();
                    dependencyStacks.set(stacks);
                }
                stack = new DependencyStack(task);
                stacks.add((DependencyStack)stack);
            }
            stack = task.execute(cCtx);
            return stack;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        finally {
            if (dependencyStacks != null) {
                stacks.removeLast();
                if (stacks.isEmpty()) {
                    dependencyStacks.set(null);
                }
            }
        }
    }

    public <T> Object[] getArguments(Constructor<T> constructor, InitParams params, List<Dependency> dependencies) {
        Class<?>[] parameters = constructor.getParameterTypes();
        Object[] args = new Object[parameters.length];
        if (args.length == 0) {
            return args;
        }
        Iterator<Dependency> tasks = dependencies.iterator();
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> parameter = parameters[i];
            args[i] = parameter.equals(InitParams.class) ? params : tasks.next();
        }
        return args;
    }

    public String getId() {
        return "ConcurrentContainer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onStartupComplete() {
        if (!Mode.removeModes(Mode.MULTI_THREADED, Mode.DISABLE_MT_ON_STARTUP_COMPLETE)) return;
        Class<ConcurrentContainerMT> clazz = ConcurrentContainerMT.class;
        synchronized (ConcurrentContainerMT.class) {
            ThreadPoolExecutor executor = EXECUTOR;
            if (executor == null || executor.isShutdown()) return;
            executor.shutdown();
            EXECUTOR = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void startDependencies(Map<ComponentAdapter<?>, Object> alreadyStarted, Set<ComponentAdapter<?>> startInProgress, AtomicReference<Exception> error, ComponentAdapterDependenciesAware<?> cada) {
        HashSet startInProgressNew;
        Collection<ComponentAdapter<?>> dep;
        if (cada.getCreateDependencies() != null) {
            dep = this.getDependencies(cada.getCreateDependencies(), false, true);
            if (dep != null && !dep.isEmpty()) {
                startInProgressNew = new HashSet(startInProgress);
                startInProgressNew.add(cada);
                this.start(dep, alreadyStarted, startInProgressNew, error, false);
            }
            if ((dep = this.getDependencies(cada.getCreateDependencies(), true, false)) != null && !dep.isEmpty()) {
                startInProgressNew = new HashSet(startInProgress);
                startInProgressNew.add(cada);
                this.start(dep, alreadyStarted, startInProgressNew, error, true);
            }
        }
        if (cada.getInitDependencies() != null && (dep = this.getDependencies(cada.getInitDependencies(), true, true)) != null && !dep.isEmpty()) {
            startInProgressNew = new HashSet(startInProgress);
            startInProgressNew.add(cada);
            dep.remove(cada);
            this.start(dep, alreadyStarted, startInProgressNew, error, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KernelThreadPoolExecutor
    extends ThreadPoolExecutor {
        public KernelThreadPoolExecutor(int threadPoolSize) {
            super(threadPoolSize, threadPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new KernelThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return LockManager.getInstance().createRunnableFuture(runnable, value);
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
            return LockManager.getInstance().createRunnableFuture(callable);
        }

        @Override
        public Future<?> submit(Runnable task) {
            if (task == null) {
                throw new NullPointerException();
            }
            RunnableFuture<Object> ftask = this.newTaskFor(task, null);
            if (LockManager.getInstance().incrementAndGetTotalUncompletedTasks() <= this.getCorePoolSize()) {
                this.execute(ftask);
            } else {
                ftask.run();
            }
            return ftask;
        }
    }

    private static class KernelThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        KernelThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "kernel-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

