/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.Deque;
import org.exoplatform.container.CachingContainer;
import org.exoplatform.container.DependencyByName;
import org.exoplatform.container.DependencyByQualifier;
import org.exoplatform.container.DependencyByType;
import org.exoplatform.container.DependencyStack;
import org.exoplatform.container.Mode;
import org.exoplatform.container.spi.ContainerException;

public class CachingContainerMT
extends CachingContainer {
    private static final long serialVersionUID = -448537861455415058L;
    protected final transient ThreadLocal<Deque<DependencyStack>> dependencyStacks = Mode.hasMode(Mode.AUTO_SOLVE_DEP_ISSUES) ? new ThreadLocal() : null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getComponentInstanceOfType(Class<T> componentType, boolean autoRegistration) {
        Object instance;
        Deque<DependencyStack> stacks = this.dependencyStacks != null ? this.dependencyStacks.get() : null;
        DependencyStack stack = null;
        try {
            if (stacks != null) {
                stack = stacks.getLast();
                stack.add(new DependencyByType(componentType));
            }
            instance = super.getComponentInstanceOfType(componentType, autoRegistration);
        }
        finally {
            if (stack != null && !stack.isEmpty()) {
                stack.removeLast();
            }
        }
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getComponentInstance(Object componentKey, Class<T> bindType, boolean autoRegistration) throws ContainerException {
        Object instance;
        Deque<DependencyStack> stacks = this.dependencyStacks != null ? this.dependencyStacks.get() : null;
        DependencyStack stack = null;
        try {
            if (stacks != null) {
                stack = stacks.getLast();
                if (componentKey instanceof String) {
                    stack.add(new DependencyByName((String)componentKey, bindType));
                } else if (componentKey instanceof Class) {
                    Class type = (Class)componentKey;
                    if (type.isAnnotation()) {
                        stack.add(new DependencyByQualifier(type, bindType));
                    } else {
                        stack.add(new DependencyByType(type));
                    }
                } else {
                    stack = null;
                }
            }
            instance = super.getComponentInstance(componentKey, bindType, autoRegistration);
        }
        finally {
            if (stack != null && !stack.isEmpty()) {
                stack.removeLast();
            }
        }
        return (T)instance;
    }
}

