/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.exoplatform.container.configuration.NoKernelNamespaceSAXFilter;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationUnmarshaller {
    private static final Log log = ExoLogger.getLogger(ConfigurationUnmarshaller.class);

    public boolean isValid(URL url) throws NullPointerException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaURL = this.getClass().getResource("kernel-configuration_1_0.xsd");
        if (schemaURL != null) {
            try {
                Schema schema = factory.newSchema(schemaURL);
                Validator validator = schema.newValidator();
                Reporter reporter = new Reporter(url);
                validator.setErrorHandler(reporter);
                validator.validate(new StreamSource(url.openStream()));
                return reporter.valid;
            }
            catch (SAXException e) {
                System.err.print("Got a sax exception when doing XSD validation");
                e.printStackTrace(System.err);
                return false;
            }
        }
        return true;
    }

    public Configuration unmarshall(URL url) throws Exception {
        boolean valid = this.isValid(url);
        if (!valid) {
            System.out.println("The configuration file " + url + " was not found valid according to its XSD");
        }
        StringWriter buffer = new StringWriter();
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler hd = tf.newTransformerHandler();
        hd.setResult(new StreamResult(buffer));
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("encoding", "UTF8");
        serializer.setOutputProperty("indent", "yes");
        InputSource source = new InputSource(url.openStream());
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser saxParser = spf.newSAXParser();
        saxParser.parse(source, (DefaultHandler)new NoKernelNamespaceSAXFilter(hd));
        String document = buffer.toString();
        log.debug((Object)("About to parse configuration file " + document));
        IBindingFactory bfact = BindingDirectory.getFactory(Configuration.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        return (Configuration)uctx.unmarshalDocument((Reader)new StringReader(document), null);
    }

    private class Reporter
    implements ErrorHandler {
        private final URL url;
        private boolean valid;

        private Reporter(URL url) {
            this.url = url;
            this.valid = true;
        }

        private void log(String prefix, SAXParseException e) {
            System.err.println(prefix + " in document " + this.url + "  at (" + e.getLineNumber() + "," + e.getColumnNumber() + ") :" + e.getMessage());
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.log("Warning", exception);
        }

        public void error(SAXParseException exception) throws SAXException {
            if (exception.getMessage().equals("cvc-elt.1: Cannot find the declaration of element 'configuration'.")) {
                System.out.println("The document " + this.url + " does not contain a schema declaration, it should have an " + "XML declaration similar to\n" + "<configuration\n" + "   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n" + "   xsi:schemaLocation=\"http://www.exoplaform.org/xml/ns/kernel_1_0.xsd http://www.exoplaform.org/xml/ns/kernel_1_0.xsd\"\n" + "   xmlns=\"http://www.exoplaform.org/xml/ns/kernel_1_0.xsd\">");
            } else {
                this.log("Error", exception);
            }
            this.valid = false;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.log("Fatal error", exception);
            this.valid = false;
        }
    }
}

