/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import org.exoplatform.container.jmx.ManageableContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class ManageableComponentAdapter
implements ComponentAdapter {
    private Log log = ExoLogger.getLogger(ManageableComponentAdapter.class);
    private ComponentAdapter delegate;
    private final ManageableContainer container;
    private volatile boolean registered = false;

    public ManageableComponentAdapter(ManageableContainer container, ComponentAdapter delegate) {
        this.delegate = delegate;
        this.container = container;
    }

    public Object getComponentKey() {
        return this.delegate.getComponentKey();
    }

    public Class getComponentImplementation() {
        return this.delegate.getComponentImplementation();
    }

    public Object getComponentInstance(PicoContainer pico) throws PicoInitializationException, PicoIntrospectionException {
        Object instance = this.delegate.getComponentInstance(pico);
        if (!this.registered) {
            this.registered = true;
            if (this.container.managementContext != null) {
                this.log.debug((Object)("==> add " + instance + " to a mbean server"));
                this.container.managementContext.register(instance);
            }
        }
        return instance;
    }

    public void verify(PicoContainer container) throws PicoIntrospectionException {
        this.delegate.verify(container);
    }

    public void accept(PicoVisitor visitor) {
        this.delegate.accept(visitor);
    }
}

