/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.container.SessionManager;
import org.exoplatform.container.security.ContainerPermissions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManagerImpl
extends Hashtable<String, SessionContainer>
implements SessionManager {
    @Override
    public List<SessionContainer> getLiveSessions() {
        ArrayList<SessionContainer> list = new ArrayList<SessionContainer>(this.size() + 1);
        list.addAll(this.values());
        return list;
    }

    @Override
    public final SessionContainer getSessionContainer(String id) {
        return (SessionContainer)this.get(id);
    }

    @Override
    public final void removeSessionContainer(String id) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        this.remove(id);
    }

    @Override
    public final void addSessionContainer(SessionContainer scontainer) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        this.put(scontainer.getSessionId(), scontainer);
    }
}

