/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.context;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.SessionScoped;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.context.CreationContext;
import org.exoplatform.container.context.CreationContextStorage;
import org.exoplatform.container.context.SharedContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionContext
extends SharedContext<HttpSession> {
    private static final String ATTRIBUTE_ID = SessionContext.class.getName();

    public Class<? extends Annotation> getScope() {
        return SessionScoped.class;
    }

    @Override
    protected CreationContextStorage createStorage(HttpSession key) {
        return new SessionContextStorage(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SessionContextStorage
    implements CreationContextStorage {
        private final HttpSession session;

        public SessionContextStorage(HttpSession session) {
            this.session = session;
        }

        @Override
        public String getId() {
            return this.session.getId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Object> getObjects(boolean create) {
            ConcurrentHashMap map = (ConcurrentHashMap)this.session.getAttribute(ATTRIBUTE_ID);
            if (map == null && create) {
                SessionContextStorage sessionContextStorage = this;
                synchronized (sessionContextStorage) {
                    map = (Map)this.session.getAttribute(ATTRIBUTE_ID);
                    if (map == null) {
                        map = new ConcurrentHashMap();
                        this.session.setAttribute(ATTRIBUTE_ID, map);
                    }
                }
            }
            return map;
        }

        @Override
        public <T> T setInstance(String id, CreationContext<T> creationContext) {
            Map<String, Object> map = this.getObjects(true);
            CreationContext currentValue = (CreationContext)map.get(id);
            if (currentValue != null && currentValue.getInstance() != null) {
                return currentValue.getInstance();
            }
            map.put(id, creationContext);
            return creationContext.getInstance();
        }

        @Override
        public <T> CreationContext<T> getCreationContext(String id) {
            Map<String, Object> map = this.getObjects(false);
            return map == null ? null : (CreationContext)map.get(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeInstance(String id) {
            Map<String, Object> map = this.getObjects(false);
            if (map != null && map.remove(id) != null && map.isEmpty()) {
                SessionContextStorage sessionContextStorage = this;
                synchronized (sessionContextStorage) {
                    if (map.isEmpty()) {
                        this.session.removeAttribute(ATTRIBUTE_ID);
                    }
                }
            }
        }

        @Override
        public Set<String> getAllIds() {
            Map<String, Object> map = this.getObjects(false);
            return map == null ? Collections.emptySet() : new HashSet<String>(map.keySet());
        }
    }
}

