/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.ar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.exoplatform.container.ar.Archive;
import org.exoplatform.container.ar.ArchiveURLStreamHandler;
import org.junit.Assert;
import org.junit.Test;

public class TestArchive {
    @Test
    public void testGetConfigurationURL() throws Exception {
        try {
            Archive.getConfigurationURL(null, null, null);
            Assert.fail((String)"An IllegalArgumentException was expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String configuration = "foo/config.xml";
        URL urlArchives = this.getClass().getResource(".");
        String path = new File(urlArchives.toURI()).getAbsolutePath();
        Archive zip = new Archive("zip", true, true, Collections.singleton(new Archive("zip", true, true, null)));
        Assert.assertTrue((boolean)Archive.getConfigurationURL(null, null, (String)configuration).isEmpty());
        Assert.assertTrue((boolean)Archive.getConfigurationURL(null, Collections.emptySet(), (String)configuration).isEmpty());
        Assert.assertTrue((boolean)Archive.getConfigurationURL(null, Collections.singleton(zip), (String)configuration).isEmpty());
        Assert.assertTrue((boolean)Archive.getConfigurationURL(Collections.emptyList(), null, (String)configuration).isEmpty());
        Assert.assertTrue((boolean)Archive.getConfigurationURL(Collections.emptyList(), Collections.emptySet(), (String)configuration).isEmpty());
        Assert.assertTrue((boolean)Archive.getConfigurationURL(Collections.emptyList(), Collections.singleton(zip), (String)configuration).isEmpty());
        Assert.assertTrue((boolean)Archive.getConfigurationURL(null, null, (String)configuration).isEmpty());
        Assert.assertTrue((boolean)Archive.getConfigurationURL(null, Collections.emptySet(), (String)configuration).isEmpty());
        Assert.assertTrue((boolean)Archive.getConfigurationURL(Collections.singletonList(path), null, (String)configuration).isEmpty());
        Assert.assertTrue((boolean)Archive.getConfigurationURL(Collections.singletonList(path), Collections.emptySet(), (String)configuration).isEmpty());
        Collection result = Archive.getConfigurationURL(Collections.singletonList(path), Collections.singleton(zip), (String)configuration);
        String[] aResult1 = new String[]{"ar-with-dir-and-ar-with-config-dir.zip!/ar-without-dir.zip!/foo/config.xml", "ar-with-dir-and-ar-with-config-dir.zip!/dir-with-ext.zip/foo/config.xml", "ar-with-dir-and-ar-with-config-file.zip!/foo/config.xml", "ar-with-dir-and-ar.zip!/ar-without-dir.zip!/foo/config.xml", "ar-with-dir-and-ar.zip!/dir-with-ext.zip/foo/config.xml", "ar-without-dir.zip!/foo/config.xml", "dir-with-dir-and-ar-with-config-dir.zip/ar-without-dir.zip!/foo/config.xml", "dir-with-dir-and-ar-with-config-dir.zip/dir-with-ext.zip/foo/config.xml", "dir-with-dir-and-ar-with-config-file.zip/foo/config.xml", "dir-with-dir-and-ar.zip/ar-without-dir.zip!/foo/config.xml", "dir-with-dir-and-ar.zip/dir-with-ext.zip/foo/config.xml", "dir-with-ext.zip/foo/config.xml", "dir-without-ext/foo/config.xml", "dir-without-ext-with-ar/foo/config.xml"};
        Assert.assertEquals((long)aResult1.length, (long)result.size());
        Iterator it = result.iterator();
        int i = 0;
        while (it.hasNext()) {
            String p = ((URL)it.next()).toString();
            Assert.assertTrue((String)(p + " doesn't end with " + aResult1[i]), (boolean)p.endsWith(aResult1[i]));
            ++i;
        }
        zip = new Archive("zip", false, true, Collections.singleton(new Archive("zip", false, true, null)));
        result = Archive.getConfigurationURL(Collections.singletonList(path), Collections.singleton(zip), (String)configuration);
        String[] aResult2 = new String[]{"ar-with-dir-and-ar-with-config-dir.zip!/ar-without-dir.zip!/foo/config.xml", "ar-with-dir-and-ar-with-config-dir.zip!/dir-with-ext.zip/foo/config.xml", "ar-with-dir-and-ar-with-config-file.zip!/foo/config.xml", "ar-with-dir-and-ar.zip!/ar-without-dir.zip!/foo/config.xml", "ar-with-dir-and-ar.zip!/dir-with-ext.zip/foo/config.xml", "ar-without-dir.zip!/foo/config.xml", "dir-with-dir-and-ar-with-config-dir.zip/ar-without-dir.zip!/foo/config.xml", "dir-with-dir-and-ar-with-config-dir.zip/dir-with-ext.zip/foo/config.xml", "dir-with-dir-and-ar-with-config-file.zip/foo/config.xml", "dir-with-dir-and-ar.zip/ar-without-dir.zip!/foo/config.xml", "dir-with-dir-and-ar.zip/dir-with-ext.zip/foo/config.xml", "dir-with-ext.zip/foo/config.xml", "dir-without-ext-with-ar.zip!/foo/config.xml"};
        Assert.assertEquals((long)aResult2.length, (long)result.size());
        it = result.iterator();
        int i2 = 0;
        while (it.hasNext()) {
            String p = ((URL)it.next()).toString();
            Assert.assertTrue((String)(p + " doesn't end with " + aResult2[i2]), (boolean)p.endsWith(aResult2[i2]));
            ++i2;
        }
        zip = new Archive("zip", false, false, Collections.singleton(new Archive("zip", false, false, null)));
        result = Archive.getConfigurationURL(Collections.singletonList(path), Collections.singleton(zip), (String)configuration);
        String[] aResult3 = new String[]{"ar-with-dir-and-ar-with-config-dir.zip!/ar-without-dir.zip!/foo/config.xml", "ar-with-dir-and-ar-with-config-file.zip!/foo/config.xml", "ar-with-dir-and-ar.zip!/ar-without-dir.zip!/foo/config.xml", "ar-without-dir.zip!/foo/config.xml", "dir-without-ext-with-ar.zip!/foo/config.xml"};
        Assert.assertEquals((long)aResult3.length, (long)result.size());
        it = result.iterator();
        int i3 = 0;
        while (it.hasNext()) {
            String p = ((URL)it.next()).toString();
            Assert.assertTrue((String)(p + " doesn't end with " + aResult3[i3]), (boolean)p.endsWith(aResult3[i3]));
            ++i3;
        }
        zip = new Archive("zip", false, false, null);
        result = Archive.getConfigurationURL(Collections.singletonList(path), Collections.singleton(zip), (String)configuration);
        String[] aResult4 = new String[]{"ar-with-dir-and-ar-with-config-file.zip!/foo/config.xml", "ar-without-dir.zip!/foo/config.xml", "dir-without-ext-with-ar.zip!/foo/config.xml"};
        Assert.assertEquals((long)aResult4.length, (long)result.size());
        it = result.iterator();
        int i4 = 0;
        while (it.hasNext()) {
            String p = ((URL)it.next()).toString();
            Assert.assertTrue((String)(p + " doesn't end with " + aResult4[i4]), (boolean)p.endsWith(aResult4[i4]));
            ++i4;
        }
        zip = new Archive("zip", true, false, Collections.singleton(new Archive("zip", true, false, null)));
        result = Archive.getConfigurationURL(Collections.singletonList(path), Collections.singleton(zip), (String)configuration);
        String[] aResult5 = new String[]{"ar-with-dir-and-ar-with-config-dir.zip!/ar-without-dir.zip!/foo/config.xml", "ar-with-dir-and-ar-with-config-file.zip!/foo/config.xml", "ar-with-dir-and-ar.zip!/ar-without-dir.zip!/foo/config.xml", "ar-without-dir.zip!/foo/config.xml", "dir-without-ext/foo/config.xml", "dir-without-ext-with-ar/foo/config.xml"};
        Assert.assertEquals((long)aResult5.length, (long)result.size());
        it = result.iterator();
        int i5 = 0;
        while (it.hasNext()) {
            String p = ((URL)it.next()).toString();
            Assert.assertTrue((String)(p + " doesn't end with " + aResult5[i5]), (boolean)p.endsWith(aResult5[i5]));
            ++i5;
        }
        zip = new Archive("zip", true, false, null);
        result = Archive.getConfigurationURL(Collections.singletonList(path), Collections.singleton(zip), (String)configuration);
        String[] aResult6 = new String[]{"ar-with-dir-and-ar-with-config-file.zip!/foo/config.xml", "ar-without-dir.zip!/foo/config.xml", "dir-without-ext/foo/config.xml", "dir-without-ext-with-ar/foo/config.xml"};
        Assert.assertEquals((long)aResult6.length, (long)result.size());
        it = result.iterator();
        int i6 = 0;
        while (it.hasNext()) {
            String p = ((URL)it.next()).toString();
            Assert.assertTrue((String)(p + " doesn't end with " + aResult6[i6]), (boolean)p.endsWith(aResult6[i6]));
            ++i6;
        }
    }

    @Test
    public void testURL() throws Exception {
        URL url = new URL("file", null, "/");
        ArchiveURLStreamHandler handler = new ArchiveURLStreamHandler();
        try {
            handler.openConnection(url);
            Assert.fail((String)"A MalformedURLException was expected");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        url = new URL("ar", "localhost", -1, "/", (URLStreamHandler)handler);
        try {
            url.openConnection();
            Assert.fail((String)"A MalformedURLException was expected");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        url = new URL("ar", "", -1, "/", (URLStreamHandler)handler);
        try {
            url.openConnection();
            Assert.fail((String)"A MalformedURLException was expected");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        url = Archive.parse((String)"//");
        try {
            url.openConnection();
            Assert.fail((String)"A MalformedURLException was expected");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        url = Archive.parse((String)"/foo!/foo2!/foo3!/foo4");
        try {
            url.openConnection();
            Assert.fail((String)"A MalformedURLException was expected");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        url = Archive.parse((String)"/foo!/");
        try {
            url.openConnection();
            Assert.fail((String)"A MalformedURLException was expected");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        url = Archive.parse((String)"/foo/");
        try {
            url.openConnection();
            Assert.fail((String)"A MalformedURLException was expected");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        url = new URL("ar", null, -1, "foo", (URLStreamHandler)handler);
        try {
            url.openConnection();
            Assert.fail((String)"A MalformedURLException was expected");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        url = Archive.parse((String)"foo");
        url.openConnection();
        url = new URL("ar", null, -1, "/foo", (URLStreamHandler)handler);
        url.openConnection();
        url = Archive.parse((String)"/foo");
        url.openConnection();
    }

    @Test
    public void testConnect() throws Exception {
        URL url = Archive.parse((String)"/foo");
        URLConnection connection = url.openConnection();
        try {
            connection.connect();
            Assert.fail((String)"A FileNotFoundException was expected");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        URL urlArchives = this.getClass().getResource(".");
        String root = new File(urlArchives.toURI()).getAbsolutePath();
        url = Archive.parse((String)root);
        connection = url.openConnection();
        try {
            connection.connect();
            Assert.fail((String)"A IOException was expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String path = root + "/ar-with-dir-and-ar-with-config-file.zip";
        url = Archive.parse((String)path);
        connection = url.openConnection();
        connection.connect();
        path = root + "/foo.zip!/foo/config.xml";
        url = Archive.parse((String)path);
        connection = url.openConnection();
        try {
            connection.connect();
            Assert.fail((String)"A FileNotFoundException was expected");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        path = root + "/dir-with-dir-and-ar-with-config-file.zip!/foo/config.xml";
        url = Archive.parse((String)path);
        connection = url.openConnection();
        try {
            connection.connect();
            Assert.fail((String)"A IOException was expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        path = root + "/ar-with-dir-and-ar-with-config-file.zip!/foo/foo.xml";
        url = Archive.parse((String)path);
        connection = url.openConnection();
        try {
            connection.connect();
            Assert.fail((String)"A FileNotFoundException was expected");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        path = root + "/ar-with-dir-and-ar-with-config-file.zip!/foo";
        url = Archive.parse((String)path);
        connection = url.openConnection();
        try {
            connection.connect();
            Assert.fail((String)"A IOException was expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        path = root + "/ar-with-dir-and-ar-with-config-dir.zip!/foo.zip!/foo/config.xml";
        url = Archive.parse((String)path);
        connection = url.openConnection();
        try {
            connection.connect();
            Assert.fail((String)"A FileNotFoundException was expected");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        path = root + "/ar-with-dir-and-ar-with-config-dir.zip!/dir-with-ext.zip!/foo/config.xml";
        url = Archive.parse((String)path);
        connection = url.openConnection();
        try {
            connection.connect();
            Assert.fail((String)"A IOException was expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetStream() throws Exception {
        URL urlArchives = this.getClass().getResource(".");
        String root = new File(urlArchives.toURI()).getAbsolutePath();
        String path = root + "/ar-with-dir-and-ar-with-config-dir.zip!/ar-without-dir.zip!/foo/foo.xml";
        URL url = Archive.parse((String)path);
        try {
            TestArchive.getContent(url);
            Assert.fail((String)"A FileNotFoundException was expected");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        path = root + "/ar-with-dir-and-ar-with-config-dir.zip!/ar-without-dir.zip!/foo";
        url = Archive.parse((String)path);
        try {
            TestArchive.getContent(url);
            Assert.fail((String)"A IOException was expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        path = root + "/dir-without-ext/foo/config.xml";
        url = Archive.parse((String)path);
        String contentRef = TestArchive.getContent(url);
        Assert.assertNotNull((Object)contentRef);
        Assert.assertFalse((boolean)contentRef.isEmpty());
        path = root + "/ar-without-dir.zip!/foo/config.xml";
        url = Archive.parse((String)path);
        String content = TestArchive.getContent(url);
        Assert.assertNotNull((Object)content);
        Assert.assertFalse((boolean)content.isEmpty());
        Assert.assertEquals((Object)contentRef, (Object)content);
        path = root + "/ar-with-dir-and-ar-with-config-dir.zip!/ar-without-dir.zip!/foo/config.xml";
        url = Archive.parse((String)path);
        content = TestArchive.getContent(url);
        Assert.assertNotNull((Object)content);
        Assert.assertFalse((boolean)content.isEmpty());
        Assert.assertEquals((Object)contentRef, (Object)content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContent(URL url) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream is = null;){
            int n;
            is = url.openStream();
            byte[] buffer = new byte[2048];
            while ((n = is.read(buffer, 0, 2048)) > -1) {
                baos.write(buffer, 0, n);
            }
        }
        return new String(baos.toByteArray(), "ISO-8859-1");
    }
}

