/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.configuration.AbstractProfileTest;
import org.exoplatform.container.configuration.ConfigParam;
import org.exoplatform.container.configuration.InitParamsHolder;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.xml.object.XMLCollection;
import org.exoplatform.xml.object.XMLField;
import org.exoplatform.xml.object.XMLObject;

public class TestCollectionValue
extends AbstractProfileTest {
    public void testNoProfile() throws Exception {
        XMLCollection xc = this.getConfiguredCollection(new String[0]);
        Collection coll = xc.getCollection();
        TestCollectionValue.assertEquals((int)1, (int)coll.size());
    }

    public void testNoProfileKernel() throws Exception {
        List l = this.getCollection(new String[0]);
        TestCollectionValue.assertEquals(Arrays.asList("manager"), (Object)l);
    }

    public void testFooProfile() throws Exception {
        XMLCollection xc = this.getConfiguredCollection("foo");
        Collection coll = xc.getCollection();
        TestCollectionValue.assertEquals((int)3, (int)coll.size());
    }

    public void testFooProfileKernel() throws Exception {
        List l = this.getCollection("foo");
        TestCollectionValue.assertEquals(Arrays.asList("manager", "foo_manager", "foo_bar_manager"), (Object)l);
    }

    public void testBarProfile() throws Exception {
        XMLCollection xc = this.getConfiguredCollection("bar");
        Collection coll = xc.getCollection();
        TestCollectionValue.assertEquals((int)2, (int)coll.size());
    }

    public void testBarProfileKernel() throws Exception {
        List l = this.getCollection("bar");
        TestCollectionValue.assertEquals(Arrays.asList("manager", "foo_bar_manager"), (Object)l);
    }

    public void testFooBarProfile() throws Exception {
        XMLCollection xc = this.getConfiguredCollection("foo", "bar");
        Collection coll = xc.getCollection();
        TestCollectionValue.assertEquals((int)3, (int)coll.size());
    }

    public void testFooBarProfileKernel() throws Exception {
        List l = this.getCollection("foo", "bar");
        TestCollectionValue.assertEquals(Arrays.asList("manager", "foo_manager", "foo_bar_manager"), (Object)l);
    }

    private XMLCollection getConfiguredCollection(String ... profiles) throws Exception {
        Configuration config = this.getConfiguration("collection-configuration.xml", profiles);
        Component a = config.getComponent(InitParamsHolder.class.getName());
        ObjectParameter op = a.getInitParams().getObjectParam("test.configuration");
        XMLObject o = op.getXMLObject();
        XMLField xf = o.getField("role");
        return xf.getCollection();
    }

    private List getCollection(String ... profiles) throws Exception {
        RootContainer config = this.getKernel("collection-configuration.xml", profiles);
        InitParamsHolder holder = (InitParamsHolder)config.getComponentInstanceOfType(InitParamsHolder.class);
        InitParams params = holder.getParams();
        ObjectParameter op = params.getObjectParam("test.configuration");
        ConfigParam cp = (ConfigParam)op.getObject();
        return cp.getRole();
    }
}

