/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.monitor.jvm;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.TestCase;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;

public class TestJ2EEServerInfo
extends TestCase {
    private static URL configurationURL = null;
    private File confFile;
    private String confPath;
    private String confDir;

    public void setUp() {
        try {
            this.confFile = new File("exo-configuration.xml");
            if (this.confFile.createNewFile()) {
                this.confPath = this.confFile.getAbsolutePath();
                this.confDir = this.confPath.replace(System.getProperty("file.separator") + "exo-configuration.xml", "");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testConfigDirName() {
        this.testConfigDirName(null, "jonas.base");
        this.testConfigDirName(null, "jboss.home.dir");
        this.testConfigDirName(null, "jboss.home.dir", "jboss.server.config.url");
        this.testConfigDirName(null, "jetty.home");
        this.testConfigDirName(null, "was.install.root");
        this.testConfigDirName(null, "wls.home");
        this.testConfigDirName(null, "catalina.home");
        this.testConfigDirName(null, "maven.exoplatform.dir");
        this.testConfigDirName(null, new String[0]);
        this.testConfigDirName("foo", "jonas.base");
        this.testConfigDirName("foo", "jboss.home.dir");
        this.testConfigDirName("foo", "jboss.home.dir", "jboss.server.config.url");
        this.testConfigDirName("foo", "jetty.home");
        this.testConfigDirName("foo", "was.install.root");
        this.testConfigDirName("foo", "wls.home");
        this.testConfigDirName("foo", "catalina.home");
        this.testConfigDirName("foo", "maven.exoplatform.dir");
        this.testConfigDirName("foo", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConfigDirName(String confDirName, String ... asVMParams) {
        if (confDirName != null) {
            System.setProperty("exo.conf.dir.name", confDirName);
        }
        if (asVMParams != null) {
            for (String asVMParam : asVMParams) {
                System.setProperty(asVMParam, this.confDir);
            }
        }
        try {
            TestJ2EEServerInfo.assertTrue((boolean)new J2EEServerInfo().getExoConfigurationDirectory().contains(confDirName == null ? "exo-conf" : confDirName));
        }
        finally {
            if (confDirName != null) {
                System.getProperties().remove("exo.conf.dir.name");
            }
            if (asVMParams != null) {
                for (String asVMParam : asVMParams) {
                    System.getProperties().remove(asVMParam);
                }
            }
        }
    }

    public void testServerDirs() throws Exception {
        try {
            this.testServerDir("catalina.home");
            this.testServerDir("jonas.base");
            this.testServerDir("jboss.home.dir");
            this.testServerDir("jetty.home");
            this.testServerDir("was.install.root");
            this.testServerDir("wls.home");
            this.testServerDir("maven.exoplatform.dir");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void testServerDir(String systemProperty) throws Exception {
        System.setProperty(systemProperty, this.confDir);
        TestJ2EEServerInfo.initConfigurationURL(null);
        if (!System.getProperty("file.separator").equals("/")) {
            String sTemp = this.confPath.replace(System.getProperty("file.separator"), "/");
            TestJ2EEServerInfo.assertEquals((String)configurationURL.getFile(), (String)sTemp);
        } else {
            TestJ2EEServerInfo.assertEquals((String)configurationURL.getFile(), (String)this.confPath);
        }
        System.clearProperty(systemProperty);
    }

    public void tearDown() {
        this.confFile.delete();
    }

    private static void initConfigurationURL(ClassLoader configClassLoader) throws MalformedURLException, ConfigurationException {
        if (configurationURL == null && !TestJ2EEServerInfo.fileExists(configurationURL = new URL("file:" + new J2EEServerInfo().getServerHome() + "/exo-configuration.xml")) && configClassLoader != null) {
            configurationURL = configClassLoader.getResource("conf/exo-configuration.xml");
        }
    }

    private static boolean fileExists(URL url) {
        try {
            url.openStream().close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

