/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.management.jmx.impl;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.commons.reflect.AnnotationIntrospector;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.NamingContext;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.jmx.impl.MBeanScopingData;
import org.exoplatform.management.jmx.impl.PropertyInfo;

public class PropertiesInfo {
    private final Map<String, PropertyInfo> properties;

    public PropertiesInfo(Map<String, PropertyInfo> properties) {
        this.properties = properties;
    }

    public static PropertiesInfo resolve(Class clazz, Class<? extends Annotation> annotationClass) {
        Annotation tpl2 = AnnotationIntrospector.resolveClassAnnotations((Class)clazz, annotationClass);
        Property[] blah = null;
        if (tpl2 instanceof NamingContext) {
            blah = ((NamingContext)tpl2).value();
        } else if (tpl2 instanceof NameTemplate) {
            blah = ((NameTemplate)tpl2).value();
        }
        if (blah != null) {
            LinkedHashMap<String, PropertyInfo> properties = new LinkedHashMap<String, PropertyInfo>();
            for (Property property : blah) {
                PropertyInfo propertyInfo = new PropertyInfo(clazz, property);
                properties.put(propertyInfo.getKey(), propertyInfo);
            }
            return new PropertiesInfo(properties);
        }
        return null;
    }

    public Collection<PropertyInfo> getProperties() {
        return this.properties.values();
    }

    public MBeanScopingData resolve(Object instance) {
        MBeanScopingData props = new MBeanScopingData();
        for (PropertyInfo propertyInfo : this.properties.values()) {
            String key = propertyInfo.getKey();
            String value = propertyInfo.resolveValue(instance);
            props.put(key, value);
        }
        return props;
    }
}

