/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.context;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.exoplatform.container.context.AbstractContext;
import org.exoplatform.container.context.CreationContextStorage;

public abstract class SharedContext<K>
extends AbstractContext<K> {
    private final ConcurrentMap<String, Lock> locks = new ConcurrentHashMap<String, Lock>(64, 0.75f, 64);

    @Override
    protected final boolean isSharable() {
        return true;
    }

    @Override
    protected Lock getLock(String id) {
        CreationContextStorage storage = this.getStorage();
        String idStorage = storage.getId();
        if (idStorage == null) {
            throw new IllegalArgumentException("The id of a storage cannot be null");
        }
        String fullID = id + '#' + idStorage;
        Lock lock = (Lock)this.locks.get(fullID);
        if (lock != null) {
            return lock;
        }
        lock = new SharedContextLock(fullID);
        Lock o = this.locks.putIfAbsent(fullID, lock);
        return o == null ? lock : o;
    }

    private class SharedContextLock
    extends ReentrantLock {
        private static final long serialVersionUID = 4963739847878774832L;
        private final String id;

        public SharedContextLock(String id) {
            this.id = id;
        }

        @Override
        public void unlock() {
            if (!this.hasQueuedThreads()) {
                SharedContext.this.locks.remove(this.id, this);
            }
            super.unlock();
        }
    }
}

