/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.TestCase;
import org.exoplatform.container.ContainerBuilder;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.configuration.ConfigurationUnmarshaller;
import org.exoplatform.container.configuration.TestValidation;

public class TestXSD_1_2
extends TestCase {
    public void testValidation() throws Exception {
        ConfigurationUnmarshaller unmarshaller = new ConfigurationUnmarshaller();
        URL urlSampleConfig = ((Object)((Object)this)).getClass().getResource("../../../../xsd_1_2/sample-configuration-01.xml");
        File baseDir = new File(urlSampleConfig.toURI()).getParentFile();
        int count = 0;
        for (File f : baseDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".xml");
            }
        })) {
            ++count;
            try {
                URL url = f.toURI().toURL();
                TestXSD_1_2.assertTrue((String)("XML configuration file " + url + " is not valid"), (boolean)unmarshaller.isValid(url));
            }
            catch (MalformedURLException e) {
                TestXSD_1_2.fail((String)("Was not expecting such exception " + e.getMessage()));
            }
        }
        TestXSD_1_2.assertEquals((int)21, (int)count);
        try {
            File f = new File(baseDir, "invalid-configuration.xml.bad");
            URL url = f.toURI().toURL();
            TestXSD_1_2.assertFalse((String)("XML configuration file " + url + " is valid"), (boolean)unmarshaller.isValid(url));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void testInitParams() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("../../../../xsd_1_2/test-validation.xml");
        TestXSD_1_2.assertNotNull((Object)url);
        RootContainer container = new ContainerBuilder().withRoot(url).build();
        container.getComponentInstanceOfType(TestValidation.class);
    }
}

