/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.ExoProfileExtension;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.TopExoContainer;
import org.exoplatform.container.TopExoContainerListener;
import org.exoplatform.container.WebAppInitContext;
import org.exoplatform.container.ar.Archive;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.container.monitor.jvm.OperatingSystemInfo;
import org.exoplatform.container.security.ContainerPermissions;
import org.exoplatform.container.spi.ContainerException;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.test.MockConfigurationManagerImpl;
import org.exoplatform.test.MockServletContext;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.authentication.AuthenticationEvent;
import org.gatein.wci.authentication.AuthenticationListener;

@Managed
@NameTemplate(value={@Property(key="container", value="root")})
@RESTEndpoint(path="rcontainer")
public class RootContainer
extends ExoContainer
implements WebAppListener,
AuthenticationListener,
TopExoContainer {
    private static final long serialVersionUID = 812448359436635438L;
    public static final String SESSION_TO_BE_INVALIDATED_ATTRIBUTE_NAME = RootContainer.class.getName() + "_TO_BE_INVALIDATED";
    private static volatile RootContainer singleton_;
    private OperatingSystemInfo osenv_;
    private PortalContainerConfig config_;
    private static final Log LOG;
    private static final AtomicBoolean booting;
    private final J2EEServerInfo serverenv_ = new J2EEServerInfo(true);
    private static Set<String> profiles;
    private final Thread hook = new ShutdownThread(this);
    private final AtomicBoolean reloading = new AtomicBoolean();
    private final AtomicLong lastUpdateTime = new AtomicLong();
    private final List<TopExoContainerListener> listeners = new CopyOnWriteArrayList<TopExoContainerListener>();
    private ClassLoader loadingCL;
    private Properties loadingSystemProperties;
    private volatile Thread reloadingThread;
    private ConcurrentMap<String, ConcurrentMap<String, Queue<PortalContainerInitTaskContext>>> initTasks = new ConcurrentHashMap<String, ConcurrentMap<String, Queue<PortalContainerInitTaskContext>>>();
    private Set<WebAppInitContext> portalContexts = new CopyOnWriteArraySet<WebAppInitContext>();
    private final Set<WeakHttpSession> sessions = new CopyOnWriteArraySet<WeakHttpSession>();
    private final Set<String> portalContainer2Reload = new CopyOnWriteArraySet<String>();

    public RootContainer() {
        profiles = new HashSet<String>();
        String envProfile = this.serverenv_.getServerName();
        if (envProfile != null) {
            profiles.add(envProfile);
        }
        try {
            ServiceLoader<ExoProfileExtension> profilesServiceLoader = ServiceLoader.load(ExoProfileExtension.class);
            profilesServiceLoader.forEach(profileExtension -> {
                Set<String> additionalProfiles = profileExtension.getProfiles();
                if (additionalProfiles != null) {
                    profiles.addAll(additionalProfiles);
                }
            });
        }
        catch (Exception e) {
            LOG.info((Object)"No product edition was found");
        }
        profiles.addAll(ExoContainer.getProfilesFromProperty());
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Runtime.getRuntime().addShutdownHook(RootContainer.this.hook);
                return null;
            }
        });
        LOG.info((Object)("Active profiles for Root container: " + profiles));
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                RootContainer.this.registerComponentInstance(J2EEServerInfo.class, RootContainer.this.serverenv_);
                if (PropertyManager.isDevelopping()) {
                    RootContainer.this.loadingCL = Thread.currentThread().getContextClassLoader();
                    RootContainer.this.loadingSystemProperties = (Properties)System.getProperties().clone();
                }
                return null;
            }
        });
    }

    public OperatingSystemInfo getOSEnvironment() {
        if (this.osenv_ == null) {
            this.osenv_ = this.getComponentInstanceOfType(OperatingSystemInfo.class);
        }
        return this.osenv_;
    }

    PortalContainerConfig getPortalContainerConfig() {
        if (this.config_ == null) {
            this.config_ = this.getComponentInstanceOfType(PortalContainerConfig.class);
        }
        return this.config_;
    }

    public boolean isPortalContainerConfigAware() {
        return this.getPortalContainerConfig().hasDefinition();
    }

    public J2EEServerInfo getServerEnvironment() {
        return this.serverenv_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getComponentInstance(Object componentKey) throws ContainerException {
        if (!this.reloading.get()) return super.getComponentInstance(componentKey);
        Class<RootContainer> clazz = RootContainer.class;
        synchronized (RootContainer.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return super.getComponentInstance(componentKey);
        }
    }

    public PortalContainer getPortalContainer(final String name) {
        J2EEServerInfo senv;
        PortalContainer pcontainer = this.getComponentInstance(name, PortalContainer.class);
        if (pcontainer == null && ("standalone".equals((senv = this.getServerEnvironment()).getServerName()) || "test".equals(senv.getServerName()))) {
            try {
                MockServletContext scontext = new MockServletContext(name);
                final PortalContainer currentPortalContainer = pcontainer = new PortalContainer(this, scontext);
                SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        PortalContainer.setInstance(currentPortalContainer);
                        return null;
                    }
                });
                final MockConfigurationManagerImpl cService = new MockConfigurationManagerImpl(scontext);
                cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/configuration.xml"));
                cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/test-configuration.xml"));
                cService.processRemoveConfiguration();
                SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        currentPortalContainer.registerComponentInstance(ConfigurationManager.class, cService);
                        RootContainer.this.registerComponentInstance(name, currentPortalContainer);
                        currentPortalContainer.start(true);
                        RootContainer.this.onStartupComplete();
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return pcontainer;
    }

    public void registerPortalContainer(ServletContext context) {
        PortalContainerConfig config;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if ((config = this.getPortalContainerConfig()).hasDefinition()) {
            if (config.isPortalContainerName(ContainerUtil.getServletContextName(context))) {
                this.portalContexts.add(new WebAppInitContext(context));
            } else {
                if (PropertyManager.isDevelopping()) {
                    LOG.info((Object)("We assume that the ServletContext '" + ContainerUtil.getServletContextName(context) + "' is not a portal since no portal container definition with the same name has been registered to the component PortalContainerConfig. The related portal container will be declared as disabled."));
                }
                config.disablePortalContainer(ContainerUtil.getServletContextName(context));
            }
            PortalContainer.addInitTask(context, new PortalContainer.RegisterTask());
        } else {
            config.registerPortalContainerName(ContainerUtil.getServletContextName(context));
            this.createPortalContainer(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createPortalContainers() {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        boolean hasChanged = false;
        try {
            for (WebAppInitContext context : this.portalContexts) {
                Thread.currentThread().setContextClassLoader(context.getWebappClassLoader());
                hasChanged = true;
                this.createPortalContainer(context.getServletContext());
            }
        }
        finally {
            if (hasChanged) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        if (PropertyManager.isDevelopping()) {
            ServletContainerFactory.getServletContainer().addWebAppListener((WebAppListener)this);
            ServletContainerFactory.getServletContainer().addAuthenticationListener((AuthenticationListener)this);
            this.checkDependencies();
        } else {
            PortalContainerConfig config = this.getPortalContainerConfig();
            for (String portalContainerName : this.initTasks.keySet()) {
                if (!config.isPortalContainerName(portalContainerName)) continue;
                LOG.warn((Object)("The portal container '" + portalContainerName + "' doesn't exist or it has not yet been registered, please check your PortalContainerDefinitions and the loading order."));
                config.unregisterPortalContainerName(portalContainerName);
            }
            this.portalContexts.clear();
            this.initTasks.clear();
        }
        this.onStartupComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDependencies() {
        PortalContainerConfig config = this.getPortalContainerConfig();
        if (!config.hasDefinition()) {
            return;
        }
        final HashSet existingWebApp = new HashSet();
        WebAppListener listener = new WebAppListener(){

            public void onEvent(WebAppEvent event) {
                if (event instanceof WebAppLifeCycleEvent && ((WebAppLifeCycleEvent)event).getType() == 1) {
                    existingWebApp.add(ContainerUtil.getServletContextName(event.getWebApp().getServletContext()));
                }
            }
        };
        try {
            ServletContainerFactory.getServletContainer().addWebAppListener(listener);
            for (WebAppInitContext context : this.portalContexts) {
                String portalContainer = context.getServletContextName();
                List<String> dependencies = config.getDependencies(portalContainer);
                for (String dep : dependencies) {
                    if (existingWebApp.contains(dep)) continue;
                    LOG.warn("The web app '{}' has been defined as a dependency of the portal container '{}' but it doesn't exist.", new Object[]{dep, portalContainer});
                }
            }
        }
        finally {
            ServletContainerFactory.getServletContainer().removeWebAppListener(listener);
        }
    }

    public void onEvent(WebAppEvent event) {
        if (event instanceof WebAppLifeCycleEvent && !this.stopping.get()) {
            WebAppLifeCycleEvent waEvent = (WebAppLifeCycleEvent)event;
            if (waEvent.getType() == 0) {
                String contextName = ContainerUtil.getServletContextName(event.getWebApp().getServletContext());
                boolean updated = false;
                for (Map.Entry entry : this.initTasks.entrySet()) {
                    String portalContainer = (String)entry.getKey();
                    ConcurrentMap queues = (ConcurrentMap)entry.getValue();
                    for (Queue queue : queues.values()) {
                        Iterator it = queue.iterator();
                        block2: while (it.hasNext()) {
                            PortalContainerInitTaskContext context = (PortalContainerInitTaskContext)it.next();
                            if (!context.getServletContextName().equals(contextName)) continue;
                            it.remove();
                            updated = true;
                            if (this.portalContainer2Reload.contains(portalContainer)) {
                                this.lastUpdateTime.set(System.currentTimeMillis());
                                continue;
                            }
                            PortalContainer container = this.getPortalContainer(portalContainer);
                            if (container == null) continue;
                            Set<WebAppInitContext> contexts = container.getWebAppInitContexts();
                            for (WebAppInitContext webappctx : contexts) {
                                ServletContext ctx = webappctx.getServletContext();
                                if (!context.getServletContextName().equals(ContainerUtil.getServletContextName(ctx))) continue;
                                this.portalContainer2Reload.add(portalContainer);
                                this.lastUpdateTime.set(System.currentTimeMillis());
                                continue block2;
                            }
                        }
                    }
                }
                if (updated) {
                    LOG.info((Object)("The webapp '" + contextName + "' has been undeployed, the related init tasks have been removed"));
                }
            } else if (waEvent.getType() == 1 && this.lastUpdateTime.get() > 0L && this.reloadingThread == null) {
                this.reloadingThread = new Thread("Reloading"){

                    @Override
                    public void run() {
                        long pause = 5000L;
                        do {
                            try {
                                6.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                6.interrupted();
                            }
                        } while (System.currentTimeMillis() < RootContainer.this.lastUpdateTime.get() + pause);
                        RootContainer.this.dynamicReload();
                        RootContainer.this.reloadingThread = null;
                    }
                };
                this.reloadingThread.setDaemon(true);
                this.reloadingThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dynamicReload() {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Properties currentSystemProperties = System.getProperties();
        boolean hasChanged = false;
        Configuration newConfig = null;
        try {
            Thread.currentThread().setContextClassLoader(this.loadingCL);
            hasChanged = true;
            System.setProperties(this.loadingSystemProperties);
            ConfigurationManager cm = RootContainer.loadConfigurationManager(this, false);
            if (cm != null) {
                newConfig = cm.getConfiguration();
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Could not load the new configuration of the root container", (Throwable)e);
            }
        }
        finally {
            if (hasChanged) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                System.setProperties(currentSystemProperties);
            }
        }
        if (newConfig == null) {
            LOG.info((Object)"The new configuration of the root container could not be loaded, thus everything will be reloaded");
            this.reload();
            return;
        }
        Configuration currentConfig = this.getConfiguration();
        if (currentConfig == null) {
            LOG.info((Object)"The current configuration of the root container could not be loaded, thus everything will be reloaded");
            this.reload();
            return;
        }
        if (newConfig.getCurrentSize() != currentConfig.getCurrentSize() || newConfig.getCurrentHash() != currentConfig.getCurrentHash()) {
            LOG.info((Object)"The configuration of the root container has changed, thus everything will be reloaded");
            this.reload();
            return;
        }
        LOG.info((Object)"The configuration of the root container did not change, thus only affected portal containers will be reloaded");
        for (String pc : this.portalContainer2Reload) {
            this.reload(pc);
        }
        this.onStartupComplete();
    }

    private void markSessionsAsToBeInvalidated(String portalContainerName) {
        for (WeakHttpSession wSess : this.sessions) {
            HttpSession sess = (HttpSession)wSess.get();
            if (sess == null || portalContainerName != null && !portalContainerName.equals(ContainerUtil.getServletContextName(sess.getServletContext()))) continue;
            try {
                sess.setAttribute(SESSION_TO_BE_INVALIDATED_ATTRIBUTE_NAME, (Object)Boolean.TRUE);
            }
            catch (IllegalStateException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)"Could not set the flag indicating that the session must be invalidated", (Throwable)e);
            }
        }
        this.sessions.clear();
    }

    public void onEvent(AuthenticationEvent evt) {
        HttpSession sess = evt.getRequest().getSession(false);
        if (sess == null || !this.getPortalContainerConfig().isPortalContainerName(ContainerUtil.getServletContextName(sess.getServletContext()))) {
            return;
        }
        switch (evt.getType()) {
            case LOGIN: {
                this.cleanupSessions();
                this.sessions.add(new WeakHttpSession(sess));
                break;
            }
        }
    }

    private void cleanupSessions() {
        HashSet<WeakHttpSession> sessionsToBeRemoved = new HashSet<WeakHttpSession>();
        for (WeakHttpSession wSess : this.sessions) {
            HttpSession sess = (HttpSession)wSess.get();
            if (sess != null) continue;
            sessionsToBeRemoved.add(wSess);
        }
        this.sessions.removeAll(sessionsToBeRemoved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createPortalContainer(ServletContext context) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        boolean hasChanged = false;
        String portalContainerName = ContainerUtil.getServletContextName(context);
        try {
            LOG.info((Object)("Trying to create the portal container '" + portalContainerName + "'"));
            PortalContainer pcontainer = new PortalContainer(this, context);
            PortalContainer.setInstance(pcontainer);
            this.executeInitTasks(pcontainer, "pre-init");
            Thread.currentThread().setContextClassLoader(pcontainer.getPortalClassLoader());
            hasChanged = true;
            LOG.info("Active profiles for Portal container '{}': {}", new Object[]{pcontainer.getName(), profiles});
            ConfigurationManagerImpl cService = new ConfigurationManagerImpl(pcontainer.getPortalContext(), profiles);
            if (ConfigurationManager.LOG_DEBUG) {
                this.showDependencies(portalContainerName);
            }
            try {
                cService.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/configuration.xml"));
            }
            catch (Exception ex) {
                LOG.error((Object)("Cannot add configuration conf/portal/configuration.xml. ServletContext: " + context), (Throwable)ex);
            }
            String uri = this.serverenv_.isJBoss() ? "conf/portal/jboss-configuration.xml" : "conf/portal/generic-configuration.xml";
            Collection<URL> envConf = ContainerUtil.getConfigurationURL(uri);
            try {
                cService.addConfiguration(envConf);
            }
            catch (Exception ex) {
                LOG.error((Object)("Cannot add configuration " + uri + ". ServletContext: " + context), (Throwable)ex);
            }
            Set<WebAppInitContext> contexts = pcontainer.getWebAppInitContexts();
            for (WebAppInitContext webappctx : contexts) {
                ServletContext ctx = webappctx.getServletContext();
                try {
                    cService.addConfiguration(ctx, "war:/conf/configuration.xml");
                }
                catch (Exception ex) {
                    LOG.error((Object)("Cannot add configuration war:/conf/configuration.xml. ServletContext: " + ctx), (Throwable)ex);
                }
            }
            String overrideConfig = this.getServerEnvironment().getExoConfigurationDirectory() + "/portal/" + portalContainerName + "/configuration.xml";
            try {
                File file = new File(overrideConfig);
                if (file.exists()) {
                    cService.addConfiguration(file.toURI().toURL());
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("Cannot add configuration " + overrideConfig + ". ServletContext: " + context), (Throwable)ex);
            }
            cService.processRemoveConfiguration();
            pcontainer.registerComponentInstance(ConfigurationManager.class, cService);
            this.registerComponentInstance(portalContainerName, pcontainer);
            pcontainer.start(true);
            this.getManagementContext().register(pcontainer);
            this.executeInitTasks(pcontainer, "post-init");
            this.executeInitTasks(pcontainer, "post-create");
            LOG.info((Object)("The portal container '" + portalContainerName + "' has been created successfully"));
        }
        catch (Exception ex) {
            LOG.error((Object)("Cannot create the portal container '" + portalContainerName + "' . ServletContext: " + context), (Throwable)ex);
        }
        finally {
            if (hasChanged) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
            try {
                PortalContainer.setInstance(null);
            }
            catch (Exception e) {
                LOG.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
        }
    }

    private void showDependencies(String portalContainerName) {
        List<String> dependencies;
        PortalContainerConfig config = this.getPortalContainerConfig();
        List<String> list = dependencies = config == null ? null : config.getDependencies(portalContainerName);
        if (dependencies == null || dependencies.isEmpty()) {
            LOG.info("No dependencies have been defined for the portal container '{}'", new Object[]{portalContainerName});
        } else {
            StringBuilder listDep = new StringBuilder();
            boolean first = true;
            for (String dep : dependencies) {
                if (first) {
                    first = false;
                } else {
                    listDep.append(", ");
                }
                listDep.append(dep);
            }
            LOG.info("The dependencies ordered by priority of the portal container '{}' are: {}", new Object[]{portalContainerName, listDep.toString()});
        }
    }

    public synchronized void removePortalContainer(ServletContext servletContext) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        this.unregisterComponent(ContainerUtil.getServletContextName(servletContext));
    }

    public static Object getComponent(Class<?> key) {
        return RootContainer.getInstance().getComponentInstanceOfType(key);
    }

    private static RootContainer buildRootContainer() {
        try {
            return (RootContainer)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<RootContainer>(){

                @Override
                public RootContainer run() throws Exception {
                    RootContainer rootContainer = new RootContainer();
                    ConfigurationManager service = RootContainer.loadConfigurationManager(rootContainer, true);
                    rootContainer.registerComponentInstance(ConfigurationManager.class, service);
                    rootContainer.start(true);
                    return rootContainer;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            LOG.error((Object)"Could not build root container", (Throwable)cause);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)cause);
            return null;
        }
    }

    private static ConfigurationManager loadConfigurationManager(RootContainer rootContainer, boolean logEnabled) throws Exception {
        Configuration conf;
        ConfigurationManagerImpl service = new ConfigurationManagerImpl(profiles, logEnabled);
        service.addConfiguration(ContainerUtil.getConfigurationURL("conf/configuration.xml"));
        if (System.getProperty("maven.exoplatform.dir") != null) {
            service.addConfiguration(ContainerUtil.getConfigurationURL("conf/test-configuration.xml"));
        }
        J2EEServerInfo serverEnv = rootContainer.getServerEnvironment();
        service.addConfiguration(Archive.getConfigurationURL(serverEnv.getApplicationDeployDirectories(), serverEnv.getApplicationDeployArchives(), "META-INF/exo-conf/configuration.xml"));
        String confDir = serverEnv.getExoConfigurationDirectory();
        String overrideConf = confDir + "/configuration.xml";
        File file = new File(overrideConf);
        if (PrivilegedFileHelper.exists((File)file)) {
            service.addConfiguration("file:" + overrideConf);
        }
        service.processRemoveConfiguration();
        if (PropertyManager.isDevelopping() && (conf = service.getConfiguration()) != null) {
            conf.keepCurrentState();
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RootContainer getInstance() {
        RootContainer result = singleton_;
        if (result != null) return result;
        Class<RootContainer> clazz = RootContainer.class;
        synchronized (RootContainer.class) {
            result = singleton_;
            if (result != null) return result;
            if (booting.get()) {
                throw new IllegalStateException("Already booting by the same thread");
            }
            booting.set(true);
            try {
                LOG.info((Object)"Building root container");
                long time = -System.currentTimeMillis();
                result = RootContainer.buildRootContainer();
                if (result != null) {
                    LOG.info((Object)("Root container is built (build time " + (time += System.currentTimeMillis()) + "ms)"));
                    singleton_ = result;
                    SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            ExoContainerContext.setTopContainer(singleton_);
                            return null;
                        }
                    });
                    LOG.info((Object)"Root container booted");
                } else {
                    LOG.error((Object)"Failed to boot root container");
                }
            }
            finally {
                booting.set(false);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static void setInstance(RootContainer rcontainer) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        singleton_ = rcontainer;
    }

    @Managed
    @ManagedDescription(value="The configuration of the container in XML format.")
    public String getConfigurationXML() {
        Configuration config = this.getConfiguration();
        if (config == null) {
            LOG.warn((Object)"The configuration of the RootContainer could not be found");
            return null;
        }
        return config.toXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="Make the RootContainer reloads itself and all the portal containers.")
    public void reload() {
        if (!PropertyManager.isDevelopping()) {
            LOG.debug((Object)"The containers can be reloaded only in developping mode, please set the system property 'exo.product.developing' to 'true'");
            return;
        }
        if (this.stopping.get()) {
            LOG.debug((Object)"The containers cannot be reloaded as we are currently stopping the root container.");
            return;
        }
        try {
            long time = System.currentTimeMillis();
            LOG.info((Object)"Trying to reload all the containers");
            LOG.info((Object)"Trying to stop all the containers");
            this.stop();
            this.markSessionsAsToBeInvalidated(null);
            Class<RootContainer> clazz = RootContainer.class;
            synchronized (RootContainer.class) {
                singleton_ = null;
                LOG.info((Object)"All the containers have been stopped successfully");
                SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        Runtime.getRuntime().removeShutdownHook(RootContainer.this.hook);
                        return null;
                    }
                });
                ServletContainerFactory.getServletContainer().removeWebAppListener((WebAppListener)this);
                ServletContainerFactory.getServletContainer().removeAuthenticationlistener((AuthenticationListener)this);
                LOG.info((Object)"Trying to restart the root container");
                RootContainer rootContainer = null;
                ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                boolean hasChanged = false;
                try {
                    Thread.currentThread().setContextClassLoader(this.loadingCL);
                    hasChanged = true;
                    System.setProperties(this.loadingSystemProperties);
                    rootContainer = RootContainer.getInstance();
                    rootContainer.reloading.set(true);
                    rootContainer.initTasks = this.initTasks;
                    rootContainer.portalContexts = this.portalContexts;
                    PortalContainer.reloadConfig();
                    LOG.info((Object)"Trying to restart all the portal containers");
                    rootContainer.createPortalContainers();
                }
                finally {
                    if (rootContainer != null) {
                        rootContainer.reloading.set(false);
                    }
                    if (hasChanged) {
                        Thread.currentThread().setContextClassLoader(currentClassLoader);
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                LOG.info((Object)("All the containers have been reloaded successfully in " + (System.currentTimeMillis() - time) + " ms"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not reload the containers", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="Make the RootContainer reloads only a given portal container.")
    public void reload(String portalContainerName) {
        if (!PropertyManager.isDevelopping()) {
            LOG.debug((Object)("The portal container '" + portalContainerName + "' can be reloaded only in developping mode, please set the system property 'exo.product.developing' to 'true'"));
            return;
        }
        if (this.stopping.get()) {
            LOG.debug((Object)("The portal container '" + portalContainerName + "' cannot be reloaded as we are currently stopping the root container."));
            return;
        }
        try {
            long time = System.currentTimeMillis();
            LOG.info((Object)("Trying to reload the portal container '" + portalContainerName + "'"));
            PortalContainer pc = this.getPortalContainer(portalContainerName);
            if (pc == null) {
                throw new IllegalArgumentException("The portal container '" + portalContainerName + "' doesn't exists or has not yet been created");
            }
            LOG.info((Object)("Trying to stop the portal container '" + portalContainerName + "'"));
            pc.stop();
            this.markSessionsAsToBeInvalidated(portalContainerName);
            Class<RootContainer> clazz = RootContainer.class;
            synchronized (RootContainer.class) {
                LOG.info((Object)("The portal container '" + portalContainerName + "' has been stopped successfully"));
                ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                boolean hasChanged = false;
                try {
                    this.reloading.set(true);
                    this.unregisterComponent(portalContainerName);
                    LOG.info((Object)("Trying to restart the portal container '" + portalContainerName + "'"));
                    for (WebAppInitContext context : this.portalContexts) {
                        if (!context.getServletContextName().equals(portalContainerName)) continue;
                        Thread.currentThread().setContextClassLoader(context.getWebappClassLoader());
                        hasChanged = true;
                        this.createPortalContainer(context.getServletContext());
                        break;
                    }
                }
                finally {
                    if (hasChanged) {
                        Thread.currentThread().setContextClassLoader(currentClassLoader);
                    }
                    this.reloading.set(false);
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                LOG.info((Object)("The portal container '" + portalContainerName + "' has been reloaded in " + (System.currentTimeMillis() - time) + " ms"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Could not reload the portal container '" + portalContainerName + "'"), (Throwable)e);
        }
    }

    public void addInitTask(ServletContext context, PortalContainerInitTask task) {
        this.addInitTask(context, task, ContainerUtil.getServletContextName(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitTask(ServletContext context, PortalContainerInitTask task, String portalContainer) {
        PortalContainer container;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_CONTAINER_PERMISSION);
        }
        if (!task.alreadyExists(container = this.getPortalContainer(portalContainer)) || this.lastUpdateTime.get() > 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The portal container '" + portalContainer + "' has not yet been initialized, thus the task can be added"));
            }
            this.addInitTaskToQueue(context, task, portalContainer);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The portal container '" + portalContainer + "' has already been initialized, thus we call onAlreadyExists"));
            }
            PortalContainer oldPortalContainer = PortalContainer.getInstanceIfPresent();
            try {
                PortalContainer.setInstance(container);
                task.onAlreadyExists(context, container);
            }
            finally {
                PortalContainer.setInstance(oldPortalContainer);
            }
            if (PropertyManager.isDevelopping()) {
                this.addInitTaskToQueue(context, task, portalContainer);
            }
        }
    }

    private void addInitTaskToQueue(ServletContext context, PortalContainerInitTask task, String portalContainer) {
        Queue<PortalContainerInitTaskContext> queue;
        block4: {
            block3: {
                String type;
                ConcurrentMap q;
                ConcurrentMap<String, ConcurrentLinkedQueue<PortalContainerInitTaskContext>> queues = (ConcurrentHashMap)this.initTasks.get(portalContainer);
                if (queues == null && (q = (ConcurrentMap)this.initTasks.putIfAbsent(portalContainer, queues = new ConcurrentHashMap())) != null) {
                    queues = q;
                }
                if ((queue = (ConcurrentLinkedQueue<PortalContainerInitTaskContext>)queues.get(type = task.getType())) != null) break block3;
                List<String> dependencies = this.getPortalContainerConfig().getDependencies(portalContainer);
                queue = dependencies == null || dependencies.isEmpty() ? new ConcurrentLinkedQueue<PortalContainerInitTaskContext>() : new PriorityBlockingQueue<PortalContainerInitTaskContext>(10, new PortalContainerInitTaskContextComparator(dependencies));
                Queue q2 = queues.putIfAbsent(type, (ConcurrentLinkedQueue<PortalContainerInitTaskContext>)queue);
                if (q2 == null) break block4;
                queue = q2;
                break block4;
            }
            if (this.reloading.get()) {
                String contextName = ContainerUtil.getServletContextName(context);
                Class<?> c = task.getClass();
                Iterator it = queue.iterator();
                while (it.hasNext()) {
                    PortalContainerInitTaskContext ctx = (PortalContainerInitTaskContext)it.next();
                    if (!ctx.getServletContextName().equals(contextName) || !ctx.getTask().getClass().equals(c)) continue;
                    it.remove();
                    break;
                }
            }
        }
        queue.add(new PortalContainerInitTaskContext(context, task));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInitTasks(PortalContainer portalContainer, String type) {
        String portalContainerName = portalContainer.getName();
        ConcurrentMap queues = (ConcurrentMap)this.initTasks.get(portalContainerName);
        if (queues == null) {
            return;
        }
        Queue queue = (Queue)queues.get(type);
        if (queue == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Start launching the " + type + " tasks of the portal container '" + portalContainer + "'"));
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        boolean hasChanged = false;
        ArrayList bckCollection = null;
        if (PropertyManager.isDevelopping()) {
            bckCollection = new ArrayList(queue);
        }
        try {
            PortalContainerInitTaskContext context;
            while ((context = (PortalContainerInitTaskContext)queue.poll()) != null) {
                Thread.currentThread().setContextClassLoader(context.getWebappClassLoader());
                hasChanged = true;
                context.getTask().execute(context.getServletContext(), portalContainer);
            }
        }
        finally {
            if (hasChanged) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        if (PropertyManager.isDevelopping()) {
            queue.addAll(bckCollection);
        } else {
            queue.clear();
            queues.remove(type);
            if (queues.isEmpty()) {
                this.initTasks.remove(portalContainerName);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("End launching the " + type + " tasks of the portal container '" + portalContainer + "'"));
        }
    }

    private void onStartupComplete() {
        if (!this.listeners.isEmpty()) {
            for (TopExoContainerListener listener : this.listeners) {
                listener.onStartupComplete();
            }
        }
    }

    @Override
    public void addListener(TopExoContainerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void stop() {
        super.stop();
        super.dispose();
        ExoContainerContext.setTopContainer(null);
    }

    public static void addProfiles(Collection<String> newProfiles) {
        profiles.addAll(newProfiles);
    }

    static {
        LOG = ExoLogger.getLogger((String)"exo.kernel.container.RootContainer");
        booting = new AtomicBoolean();
    }

    static class ShutdownThread
    extends Thread {
        RootContainer container_;

        ShutdownThread(RootContainer container) {
            this.container_ = container;
        }

        @Override
        public void run() {
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    container_.stop();
                    return null;
                }
            });
        }
    }

    public static interface PortalContainerInitTask {
        public boolean alreadyExists(PortalContainer var1);

        public void onAlreadyExists(ServletContext var1, PortalContainer var2);

        public void execute(ServletContext var1, PortalContainer var2);

        public String getType();
    }

    static class PortalContainerInitTaskContext
    extends WebAppInitContext {
        private final PortalContainerInitTask task;

        PortalContainerInitTaskContext(ServletContext context, PortalContainerInitTask task) {
            super(context);
            this.task = task;
        }

        public PortalContainerInitTask getTask() {
            return this.task;
        }
    }

    private static class WeakHttpSession
    extends WeakReference<HttpSession> {
        public WeakHttpSession(HttpSession session) {
            super(session);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WeakHttpSession other = (WeakHttpSession)obj;
            HttpSession session = (HttpSession)this.get();
            HttpSession otherSession = (HttpSession)other.get();
            if (session == null) {
                return otherSession == null;
            }
            if (otherSession == null) {
                return false;
            }
            return session.getId().equals(otherSession.getId());
        }

        public int hashCode() {
            HttpSession session = (HttpSession)this.get();
            return session == null ? 0 : session.getId().hashCode();
        }
    }

    public static abstract class PortalContainerPreInitTask
    implements PortalContainerInitTask {
        public static final String TYPE = "pre-init";

        @Override
        public final boolean alreadyExists(PortalContainer portalContainer) {
            return portalContainer != null;
        }

        @Override
        public final void onAlreadyExists(ServletContext context, PortalContainer portalContainer) {
            if (PropertyManager.isDevelopping()) {
                this.execute(context, portalContainer);
                return;
            }
            throw new IllegalStateException("No pre init tasks can be added to the portal container '" + portalContainer.getName() + "', because it has already been initialized. Check the webapp '" + ContainerUtil.getServletContextName(context) + "'");
        }

        @Override
        public final String getType() {
            return TYPE;
        }
    }

    public static abstract class PortalContainerPostInitTask
    implements PortalContainerInitTask {
        public static final String TYPE = "post-init";

        @Override
        public final boolean alreadyExists(PortalContainer portalContainer) {
            return portalContainer != null && portalContainer.isStarted();
        }

        @Override
        public final void onAlreadyExists(ServletContext context, PortalContainer portalContainer) {
            this.execute(context, portalContainer);
        }

        @Override
        public final String getType() {
            return TYPE;
        }
    }

    public static abstract class PortalContainerPostCreateTask
    implements PortalContainerInitTask {
        public static final String TYPE = "post-create";

        @Override
        public final boolean alreadyExists(PortalContainer portalContainer) {
            return portalContainer != null && portalContainer.isStarted();
        }

        @Override
        public final void onAlreadyExists(ServletContext context, PortalContainer portalContainer) {
            this.execute(context, portalContainer);
        }

        @Override
        public final String getType() {
            return TYPE;
        }
    }

    static class PortalContainerInitTaskContextComparator
    implements Comparator<PortalContainerInitTaskContext> {
        private final List<String> dependencies;

        PortalContainerInitTaskContextComparator(List<String> dependencies) {
            this.dependencies = dependencies;
        }

        @Override
        public int compare(PortalContainerInitTaskContext ctx1, PortalContainerInitTaskContext ctx2) {
            int idx1 = this.dependencies.indexOf(ctx1.getServletContextName());
            int idx2 = this.dependencies.indexOf(ctx2.getServletContextName());
            if (idx1 == -1 && idx2 != -1) {
                return 1;
            }
            if (idx1 != -1 && idx2 == -1) {
                return -1;
            }
            if (idx1 == -1 && idx2 == -1) {
                return ctx1.getServletContextName().compareTo(ctx2.getServletContextName());
            }
            return idx1 - idx2;
        }
    }
}

