/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.management;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;
import org.exoplatform.container.ContainerBuilder;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.management.Foo;
import org.exoplatform.container.management.ManagedResource;
import org.exoplatform.container.management.ManagementProviderImpl;
import org.exoplatform.container.management.ScopedData;

public class TestManagementProvider
extends TestCase {
    public void testProviderRegistration() {
        URL url = ((Object)((Object)this)).getClass().getResource("configuration1.xml");
        RootContainer container = new ContainerBuilder().withRoot(url).build();
        ManagementProviderImpl provider = (ManagementProviderImpl)container.getComponentInstanceOfType(ManagementProviderImpl.class);
        TestManagementProvider.assertNotNull((Object)provider);
    }

    public void testManagedRegistrationAfterProviderRegistration() {
        URL url = ((Object)((Object)this)).getClass().getResource("configuration1.xml");
        RootContainer container = new ContainerBuilder().withRoot(url).build();
        ManagementProviderImpl provider = (ManagementProviderImpl)container.getComponentInstanceOfType(ManagementProviderImpl.class);
        TestManagementProvider.assertEquals((int)1, (int)provider.managedResources.size());
        Object foo = container.getComponentInstance((Object)"Foo");
        TestManagementProvider.assertNotNull((Object)foo);
        TestManagementProvider.assertEquals((int)2, (int)provider.managedResources.size());
        ManagedResource fooMR = provider.managedResources.get(1);
        TestManagementProvider.assertSame((Object)foo, (Object)fooMR.resource);
        TestManagementProvider.assertEquals(Collections.emptyList(), (Object)fooMR.context.getScopingData(ScopedData.class));
        fooMR.register();
        TestManagementProvider.assertEquals(Collections.singletonList(fooMR.data), (Object)fooMR.context.getScopingData(ScopedData.class));
    }

    public void testManagedRegistrationBeforeProviderRegistration() {
        URL url = ((Object)((Object)this)).getClass().getResource("configuration2.xml");
        RootContainer container = new ContainerBuilder().withRoot(url).build();
        ManagementProviderImpl provider = (ManagementProviderImpl)container.getComponentInstanceOfType(ManagementProviderImpl.class);
        TestManagementProvider.assertNull((Object)provider);
        Object foo = container.getComponentInstance((Object)"Foo");
        TestManagementProvider.assertNotNull((Object)foo);
        provider = new ManagementProviderImpl();
        container.registerComponentInstance((Object)provider);
        TestManagementProvider.assertEquals((int)2, (int)provider.managedResources.size());
        ManagedResource fooMR = provider.managedResources.get(1);
        TestManagementProvider.assertSame((Object)foo, (Object)fooMR.resource);
        TestManagementProvider.assertEquals(Collections.emptyList(), (Object)fooMR.context.getScopingData(ScopedData.class));
        fooMR.register();
        TestManagementProvider.assertEquals(Collections.singletonList(fooMR.data), (Object)fooMR.context.getScopingData(ScopedData.class));
    }

    public void testManagementAware() {
        URL url = ((Object)((Object)this)).getClass().getResource("configuration1.xml");
        RootContainer container = new ContainerBuilder().withRoot(url).build();
        ManagementProviderImpl provider = (ManagementProviderImpl)container.getComponentInstanceOfType(ManagementProviderImpl.class);
        Foo foo = (Foo)container.getComponentInstance((Object)"Foo");
        TestManagementProvider.assertEquals((int)2, (int)provider.managedResources.size());
        ManagedResource fooMR = provider.managedResources.get(1);
        fooMR.register();
        TestManagementProvider.assertTrue((boolean)foo.isAware());
        foo.deploy();
        TestManagementProvider.assertEquals((int)3, (int)provider.managedResources.size());
        ManagedResource barMR = provider.managedResources.get(2);
        TestManagementProvider.assertSame((Object)foo.bar, (Object)barMR.resource);
        barMR.register();
        TestManagementProvider.assertEquals(Arrays.asList(barMR.data, fooMR.data), (Object)barMR.context.getScopingData(ScopedData.class));
        foo.undeploy();
        TestManagementProvider.assertEquals((int)2, (int)provider.managedResources.size());
        TestManagementProvider.assertEquals((Object)fooMR, (Object)provider.managedResources.get(1));
    }

    public void testContainerScopedRegistration() {
        URL rootURL = ((Object)((Object)this)).getClass().getResource("root-configuration.xml");
        URL portal1URL = ((Object)((Object)this)).getClass().getResource("portal-configuration1.xml");
        URL portal2URL = ((Object)((Object)this)).getClass().getResource("portal-configuration2.xml");
        RootContainer root = new ContainerBuilder().withRoot(rootURL).withPortal("portal1", portal1URL).withPortal("portal2", portal2URL).build();
        Foo fooRoot = (Foo)root.getComponentInstanceOfType(Foo.class);
        ManagementProviderImpl provider = (ManagementProviderImpl)root.getComponentInstanceOfType(ManagementProviderImpl.class);
        PortalContainer portal1 = root.getPortalContainer("portal1");
        Foo fooPortal1 = (Foo)portal1.getComponentInstanceOfType(Foo.class);
        ManagementProviderImpl provider1 = (ManagementProviderImpl)portal1.getComponentInstanceOfType(ManagementProviderImpl.class);
        PortalContainer portal2 = root.getPortalContainer("portal2");
        Foo fooPortal2 = (Foo)portal2.getComponentInstanceOfType(Foo.class);
        ManagementProviderImpl provider2 = (ManagementProviderImpl)portal2.getComponentInstanceOfType(ManagementProviderImpl.class);
        TestManagementProvider.assertEquals((int)6, (int)provider.managedResources.size());
        TestManagementProvider.assertTrue((boolean)provider.resources.contains(root));
        TestManagementProvider.assertTrue((boolean)provider.resources.contains(root));
        TestManagementProvider.assertTrue((boolean)provider.resources.contains(portal1));
        TestManagementProvider.assertTrue((boolean)provider.resources.contains(portal2));
        TestManagementProvider.assertTrue((boolean)provider.resources.contains(fooRoot));
        TestManagementProvider.assertTrue((boolean)provider.resources.contains(fooPortal1));
        TestManagementProvider.assertTrue((boolean)provider.resources.contains(fooPortal2));
        TestManagementProvider.assertEquals((int)2, (int)provider1.managedResources.size());
        TestManagementProvider.assertEquals((Object)portal1, (Object)provider1.managedResources.get((int)0).resource);
        TestManagementProvider.assertEquals((Object)fooPortal1, (Object)provider1.managedResources.get((int)1).resource);
        TestManagementProvider.assertEquals((int)2, (int)provider2.managedResources.size());
        TestManagementProvider.assertEquals((Object)portal2, (Object)provider2.managedResources.get((int)0).resource);
        TestManagementProvider.assertEquals((Object)fooPortal2, (Object)provider2.managedResources.get((int)1).resource);
    }
}

