/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.jira;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.xwiki.properties.annotation.PropertyDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraIssueMacroParameters {
    private static final List<String> DEFAULT_COLUMNS = new ArrayList<String>();
    private String query = null;
    private List<String> columns;
    private String title = "JIRA Issues";

    public List<String> getColumnsInList() {
        if (this.columns == null) {
            this.columns = new ArrayList<String>(DEFAULT_COLUMNS);
        }
        return this.columns;
    }

    public String getColumns() {
        StringBuilder builder = new StringBuilder();
        List<String> columns = this.getColumnsInList();
        for (String column : columns) {
            builder.append(column);
            builder.append(",");
        }
        return builder.toString();
    }

    @PropertyDescription(value="JIRA Field Columns to Display. Sample: type,key,summary")
    public void setColumns(String columns) {
        if (StringUtils.isEmpty((String)columns)) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(columns, ",");
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        } else {
            this.columns.clear();
        }
        while (tokenizer.hasMoreElements()) {
            String field = ((String)tokenizer.nextElement()).trim();
            if (StringUtils.isEmpty((String)field)) continue;
            this.columns.add(field);
        }
    }

    public String getUrl() {
        return this.query;
    }

    @PropertyDescription(value="Url refer to Jira data. Sample: https://jira.side.org/jira.issueviews:path/data.xml?jqlQuery=query")
    public void setUrl(String querry) {
        this.query = querry;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    static {
        DEFAULT_COLUMNS.add("Type");
        DEFAULT_COLUMNS.add("Key");
        DEFAULT_COLUMNS.add("Summary");
    }
}

