/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.table;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.TableBlock;
import org.xwiki.rendering.block.TableRowBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="table")
public class TableMacro
extends AbstractMacro<Object> {
    private static final String DESCRIPTION = "Inserts a table.";
    @Requirement
    private ComponentManager componentManager;

    public TableMacro() {
        super("Table", DESCRIPTION);
        this.setDefaultCategory("Formatting");
    }

    public List<Block> execute(Object parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM parsedDom;
        Parser parser = this.getSyntaxParser(context.getSyntax().toIdString());
        try {
            parsedDom = parser.parse((Reader)new StringReader(content));
        }
        catch (ParseException e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "] with Syntax parser [" + parser.getSyntax() + "]", (Throwable)e);
        }
        List potentialRows = parsedDom.getChildrenByType(MacroBlock.class, false);
        int count = this.countRows(potentialRows);
        if (count == 0) {
            throw new MacroExecutionException("Table macro expect at least one row macro as first-level children");
        }
        this.makeRows(potentialRows);
        LinkedHashMap tableParameters = new LinkedHashMap();
        TableBlock tableRoot = new TableBlock(parsedDom.getChildren(), tableParameters);
        return Collections.singletonList(tableRoot);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    protected Parser getSyntaxParser(String syntaxId) throws MacroExecutionException {
        try {
            return (Parser)this.componentManager.lookup(Parser.class, syntaxId);
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find source parser", (Throwable)e);
        }
    }

    private int countRows(List<MacroBlock> blocks) {
        int result = 0;
        for (MacroBlock maybeRow : blocks) {
            if (!maybeRow.getId().equals("table-row") && !maybeRow.getId().equals("thead") && !maybeRow.getId().equals("tr")) continue;
            ++result;
        }
        return result;
    }

    private void makeRows(List<MacroBlock> blocks) {
        for (MacroBlock probablyRow : blocks) {
            if (!probablyRow.getId().equals("table-row") && !probablyRow.getId().equals("thead") && !probablyRow.getId().equals("tr")) continue;
            LinkedHashMap params = new LinkedHashMap();
            TableRowBlock rowBlock = new TableRowBlock(Collections.singletonList(probablyRow.clone()), params);
            probablyRow.getParent().replaceChild((Block)rowBlock, (Block)probablyRow);
        }
    }
}

