/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.PropertyReader;
import org.exoplatform.ks.upgrade.UpgradeUtils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeForumPlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger(UpgradeForumPlugin.class);
    private static final String NEW_DOAMIN_FORUM = "new.domain.forum";
    private static final String GROUP_SPACE_ID = "/spaces";
    private String newDomain = "";
    private KSDataLocation dataLocation;

    public UpgradeForumPlugin(InitParams initParams) {
        super(initParams);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.dataLocation = (KSDataLocation)container.getComponentInstance(KSDataLocation.class);
        this.getNewDomain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        log.info((Object)"\n\n\n\n -----------> processUpgrade Forum Migration......\n\n\n");
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            log.info((Object)"\n\nRegister new nodeTypes...\n");
            UpgradeUtils.registerNodeTypes("jar:/conf/portal/forum-nodetypes.xml", 0);
            UpgradeUtils.registerNodeTypes("jar:/conf/portal/forum-migrate-nodetypes.xml", 4);
            log.info((Object)"\n\nMigration forum data....\n");
            this.migrationForumData(sProvider);
            log.info((Object)"\n\nMigration space....\n");
            this.migrationSpaceOfPLF(sProvider);
        }
        catch (Exception e) {
            log.warn((Object)"[UpgradeForumPlugin] Exception when migrate data from 2.1.x to 2.2.3 for Forum.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        log.info((Object)"\n\n\n\n -----------> The end Forum Migration......\n\n\n");
    }

    private void getNewDomain() {
        log.info((Object)"\nGet new domain for migration forum datas...");
        try {
            Properties props = new Properties(System.getProperties());
            this.newDomain = props.getProperty(NEW_DOAMIN_FORUM);
            log.info((Object)("\nnewDomain: " + this.newDomain));
        }
        catch (Exception e) {
            log.warn((Object)"Failed to get new domain in system configation. ", (Throwable)e);
        }
    }

    private void migrationForumData(SessionProvider sProvider) throws Exception {
        Node forumHome = this.getForumHomeNode(sProvider);
        NodeIterator pIter = this.getNodeIterator(sProvider, forumHome, "exo:post", new StringBuilder(""));
        log.info((Object)("\nThe size of list post migration: " + pIter.getSize()));
        while (pIter.hasNext()) {
            Node pNode = pIter.nextNode();
            try {
                pNode.getProperty("exo:isWaiting");
            }
            catch (Exception e) {
                pNode.addMixin("exo:forumMigrate");
                pNode.setProperty("exo:isWaiting", false);
                log.info((Object)String.format("Migration node %s property: exo:isWatting=false", pNode.getName()));
            }
            if (Utils.isEmpty((String)this.newDomain)) continue;
            this.saveLink(pNode);
        }
        if (!Utils.isEmpty((String)this.newDomain)) {
            NodeIterator tIter = this.getNodeIterator(sProvider, forumHome, "exo:topic", new StringBuilder(""));
            log.info((Object)("The size of list topic migration: " + tIter.getSize()));
            while (tIter.hasNext()) {
                this.saveLink(tIter.nextNode());
            }
        }
        forumHome.getSession().save();
    }

    private void saveLink(Node node) throws Exception {
        try {
            String link = node.getProperty("exo:link").getString();
            if (!Utils.isEmpty((String)link) && link.indexOf(this.newDomain) < 0) {
                link = this.newDomain + link.substring(link.indexOf("/", 8));
                node.setProperty("exo:link", link);
                log.info((Object)String.format("Migration node %s property: exo:link=%s", node.getName(), link));
            }
        }
        catch (Exception e) {
            log.warn((Object)String.format("Can not migration node %s with property exo:link", node.getName()));
        }
    }

    private void migrationSpaceOfPLF(SessionProvider sProvider) throws Exception {
        Node forumHome = this.getForumHomeNode(sProvider);
        NodeIterator cIter = this.getOldAllNodeCateSpace(sProvider, forumHome);
        log.info((Object)("\nNumber categories space migration: " + cIter.getSize()));
        if (cIter.getSize() > 0L) {
            String nodeName = null;
            Node newSpNode = this.getCatNSPNode(sProvider, false);
            String newSpPath = newSpNode.getPath();
            log.info((Object)("\nPath of category Spaces: " + newSpPath));
            Session session = forumHome.getSession();
            List<String> groups = this.getAllGroupOfSpaces();
            ArrayList<String> lastGroupIds = new ArrayList<String>();
            for (String string : groups) {
                lastGroupIds.add(string.replaceFirst("/spaces/", ""));
            }
            log.info((Object)("\nGet all groups of spaces: " + ((Object)lastGroupIds).toString()));
            while (cIter.hasNext()) {
                Node cNode = cIter.nextNode();
                PropertyReader reader = new PropertyReader(cNode);
                String[] permission = reader.strings("exo:userPrivate", new String[]{""});
                log.info((Object)("\nMigration category : " + cNode.getName()));
                NodeIterator fIter = cNode.getNodes();
                while (fIter.hasNext()) {
                    Node fNode = fIter.nextNode();
                    nodeName = fNode.getName();
                    log.info((Object)("\nMigration forum : " + nodeName));
                    try {
                        if (!fNode.isNodeType("exo:forum")) continue;
                        String fName = this.getGroupId(permission);
                        log.info((Object)("\n Forum migration has group: " + fName));
                        if (lastGroupIds.contains(fName)) {
                            fNode.setProperty("exo:poster", permission);
                            fNode.setProperty("exo:createTopicRole", permission);
                            fNode.setProperty("exo:viewer", permission);
                            fNode.save();
                            fName = Utils.FORUM_SPACE_ID_PREFIX + fName;
                        } else {
                            fNode.setProperty("exo:forumOrder", 100L);
                            fNode.save();
                            fName = nodeName;
                        }
                        if (!this.hasNodeInSP(sProvider, fName)) {
                            session.move(fNode.getPath(), newSpPath + "/" + fName);
                            session.save();
                            log.info((Object)String.format("Move forum %s in to category Spaces with new node name %s", nodeName, fName));
                            continue;
                        }
                        this.moveTopicsToForumSpace(session, fNode, newSpPath + "/" + fName);
                        log.info((Object)String.format("Move all topics from %s in to forum category spaces %s", nodeName, fName));
                    }
                    catch (Exception e) {
                        log.info((Object)String.format("Can not moving the forum %s in to category Spaces...", nodeName));
                    }
                }
                log.info((Object)String.format("Remove old category space: %s ", cNode.getName()));
                cNode.remove();
                session.save();
            }
            newSpNode.setProperty("exo:userPrivate", groups.toArray(new String[groups.size()]));
            forumHome.save();
        }
    }

    private void moveTopicsToForumSpace(Session session, Node fNode, String fpatch) throws Exception {
        try {
            NodeIterator tIter = fNode.getNodes();
            while (tIter.hasNext()) {
                Node tNode = tIter.nextNode();
                if (!tNode.isNodeType("exo:topic")) continue;
                session.move(fNode.getPath(), fpatch + "/" + tNode.getName());
            }
            session.save();
        }
        catch (Exception e) {
            log.info((Object)String.format("Failed to move all topics from %s in to forum category spaces %s", fNode.getName(), fpatch));
        }
    }

    private String getGroupId(String[] grs) throws Exception {
        for (int i = 0; i < grs.length; ++i) {
            String s = grs[i];
            if (s.indexOf("/spaces/") < 0 || Utils.isEmpty((String)(s = s.substring(s.lastIndexOf("/") + 1)))) continue;
            return s;
        }
        return "";
    }

    private boolean hasNodeInSP(SessionProvider sProvider, String id) {
        try {
            this.getCatNSPNode(sProvider, false).getNode(id);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Node getForumHomeNode(SessionProvider sProvider) throws Exception {
        return this.getNodeByPath(this.dataLocation.getForumHomeLocation(), sProvider);
    }

    private Node getCatNSPNode(SessionProvider sProvider, boolean isClear) throws Exception {
        Node categoryHome = this.getNodeByPath(this.dataLocation.getForumCategoriesLocation(), sProvider);
        Node catNode = null;
        String id = Utils.CATEGORY + "spaces";
        try {
            catNode = categoryHome.getNode(id);
            if (isClear) {
                catNode.remove();
                categoryHome.getSession().save();
            }
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        if (catNode == null) {
            catNode = categoryHome.addNode(id, "exo:forumCategory");
            catNode.setProperty("exo:id", id);
            catNode.setProperty("exo:owner", "");
            catNode.setProperty("exo:createdDate", GregorianCalendar.getInstance());
            catNode.setProperty("exo:name", "Spaces");
            catNode.setProperty("exo:categoryOrder", 100L);
            catNode.setProperty("exo:description", "The category sotorage all forums of spaces.");
            catNode.setProperty("exo:modifiedBy", "");
            catNode.setProperty("exo:modifiedDate", GregorianCalendar.getInstance());
            catNode.setProperty("exo:userPrivate", new String[]{""});
            catNode.getSession().save();
        }
        return catNode;
    }

    private NodeIterator getOldAllNodeCateSpace(SessionProvider sProvider, Node forumHome) throws Exception {
        StringBuilder strQuery = new StringBuilder("[(@").append("exo:name").append("='spaces') or (jcr:contains(@").append("exo:userPrivate").append(", 'spaces'))]");
        return this.getNodeIterator(sProvider, forumHome, "exo:forumCategory", strQuery);
    }

    private NodeIterator getNodeIterator(SessionProvider sProvider, Node node, String nodeType, StringBuilder strQuery) throws Exception {
        QueryManager qm = node.getSession().getWorkspace().getQueryManager();
        StringBuilder pathQuery = new StringBuilder("/jcr:root").append(node.getPath()).append("//element(*,").append(nodeType).append(")").append((CharSequence)strQuery).append(" order by @").append("exo:name").append(" descending");
        Query query = qm.createQuery(pathQuery.toString(), "xpath");
        QueryResult result = query.execute();
        return result.getNodes();
    }

    public Node getNodeByPath(String nodePath, SessionProvider sessionProvider) throws Exception {
        if (nodePath.indexOf("/") == 0) {
            nodePath = nodePath.substring(1);
        }
        return this.getSession(sessionProvider).getRootNode().getNode(nodePath);
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isBefore((String)previousVersion, (String)newVersion);
    }

    private Session getSession(SessionProvider sProvider) throws Exception {
        return this.dataLocation.getSessionManager().getSession(sProvider);
    }

    private List<String> getAllGroupOfSpaces() throws Exception {
        ArrayList<String> groupIds = new ArrayList<String>();
        try {
            PortalContainer container = PortalContainer.getInstance();
            OrganizationService organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            ((ComponentRequestLifecycle)organizationService).startRequest((ExoContainer)container);
            Group group = organizationService.getGroupHandler().findGroupById(GROUP_SPACE_ID);
            if (group != null) {
                Collection groups = organizationService.getGroupHandler().findGroups(group);
                for (Group gr : groups) {
                    groupIds.add(gr.getId());
                }
            }
            ((ComponentRequestLifecycle)organizationService).endRequest((ExoContainer)container);
        }
        catch (Exception e) {
            log.warn((Object)"\nFailed to get all groups in spaces.", (Throwable)e);
        }
        return groupIds;
    }
}

