/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.rss;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ks.rss.RSS;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RSSGenerate {
    public static NodeHierarchyCreator nodeHierarchyCreator_;
    public Node appHomeNode;
    public final String KS_RSS = "ks.rss".intern();
    public final String feedType = "rss_2.0".intern();
    public final String descriptionType = "text/plain".intern();
    public final String eXoLink = "http://www.exoplatform.com".intern();
    protected final String contentProperty = "exo:content".intern();
    public RSS data;
    public int maxSize = 20;
    public final String FAQ_RSS_TYPE = "exo:faqRSS".intern();
    public final String FORUM_RSS_TYPE = "exo:forumRSS".intern();
    public final String KS_FAQ = "faq".intern();
    public final String KS_FORUM = "forum".intern();
    public final String FAQ_APP = "faqApp".intern();
    public final String FORUM_APP = "ForumService".intern();

    public RSSGenerate(NodeHierarchyCreator nodeHierarchyCreator) {
        nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.data = new RSS();
    }

    public Node getKSServiceHome(SessionProvider sProvider, String serviceType) throws Exception {
        if (nodeHierarchyCreator_ == null) {
            PortalContainer.getInstance();
            nodeHierarchyCreator_ = (NodeHierarchyCreator)PortalContainer.getComponent(NodeHierarchyCreator.class);
        }
        Node tmpNode = nodeHierarchyCreator_.getPublicApplicationNode(sProvider).getNode(serviceType);
        PortalContainer.getInstance();
        RepositoryService rService = (RepositoryService)PortalContainer.getComponent(RepositoryService.class);
        Session session = sProvider.getSession(rService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), rService.getCurrentRepository());
        return (Node)session.getItem(tmpNode.getPath());
    }

    public String getPageLink() throws Exception {
        try {
            PortalRequestContext portalContext = Util.getPortalRequestContext();
            return portalContext.getRequest().getRequestURL().toString().replaceFirst("private", "public");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Node getNodeById(String objectId, SessionProvider sProvider) throws Exception {
        Node parentNode = this.getKSServiceHome(sProvider, this.FORUM_APP);
        QueryManager qm = parentNode.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + parentNode.getPath() + "//*[@exo:id='").append(objectId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        parentNode = result.getNodes().nextNode();
        return parentNode;
    }

    public void addNodeRSS(Node nodeIsAdded, Node rssNode, RSS data, boolean isNew) throws Exception {
        try {
            rssNode.setProperty(this.contentProperty, data.getContent());
            if (isNew) {
                nodeIsAdded.getSession().save();
            } else {
                nodeIsAdded.save();
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
    }

    public void getRSSData(Node rssNode, RSS data) throws Exception {
        if (rssNode.hasProperty(this.contentProperty)) {
            data.setContent(rssNode.getProperty(this.contentProperty).getValue().getStream());
        }
    }

    public SyndFeed updateRSSFeed(RSS data, String removeItemId, SyndEntry newEntry) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(data.getContent());
        doc.getDocumentElement().normalize();
        SyndFeedInput input = new SyndFeedInput();
        SyndFeed feed = input.build(doc);
        List entries = feed.getEntries();
        if (removeItemId != null && removeItemId.trim().length() > 0) {
            for (SyndEntry syndEntry : entries) {
                if (!syndEntry.getUri().equals(removeItemId)) continue;
                entries.remove(syndEntry);
                break;
            }
        }
        if (newEntry != null) {
            entries.add(0, newEntry);
        }
        feed.setEntries(entries);
        return feed;
    }

    public void removeRSSItem(String objectid, Node node, String feedDescription) throws Exception {
        RSS data = new RSS();
        Node RSSNode = null;
        try {
            RSSNode = node.getNode(this.KS_RSS);
        }
        catch (PathNotFoundException pn) {
            return;
        }
        this.getRSSData(RSSNode, data);
        SyndFeed feed = this.updateRSSFeed(data, objectid, null);
        try {
            feed.setTitle(node.getProperty("exo:name").getString());
        }
        catch (PathNotFoundException pn) {
            feed.setTitle("Root");
        }
        feed.setDescription(feedDescription);
        SyndFeedOutput output = new SyndFeedOutput();
        data.setContent(new ByteArrayInputStream(output.outputString(feed).getBytes()));
        this.addNodeRSS(node, RSSNode, data, false);
    }

    public SyndFeed createNewFedd(String title, Date pubDate) {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setLink(this.eXoLink);
        feed.setFeedType(this.feedType);
        feed.setTitle(title);
        feed.setPublishedDate(pubDate);
        return feed;
    }

    public SyndEntry createNewEntry(String uri, String title, String link, List<String> listContent, SyndContent description, Date pubDate, String author) {
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setUri(uri);
        entry.setTitle(title);
        entry.setLink(link + uri);
        entry.setContributors(listContent);
        entry.setDescription(description);
        entry.setPublishedDate(pubDate);
        entry.setAuthor(author);
        return entry;
    }

    public abstract void generateFAQRSS(String var1, int var2, SessionProvider var3);

    public abstract void generateForumsRSS(String var1, int var2, SessionProvider var3) throws Exception;
}

