/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.jcr;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyReader {
    Node node = null;

    public PropertyReader(Node node) {
        this.node = node;
    }

    public Double d(String name) {
        try {
            return this.node.getProperty(name).getDouble();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public long l(String name) {
        try {
            return this.node.getProperty(name).getLong();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public String string(String name, String defaultValue) {
        try {
            return this.node.getProperty(name).getString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String string(String name) {
        return this.string(name, null);
    }

    public Date date(String name) {
        try {
            return this.node.getProperty(name).getDate().getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Boolean bool(String name) {
        return this.bool(name, false);
    }

    public Boolean bool(String name, boolean defaultValue) {
        try {
            return this.node.getProperty(name).getBoolean();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String[] strings(String name) {
        return this.strings(name, null);
    }

    public String[] strings(String name, String[] defaultValue) {
        try {
            return this.valuesToArray(this.node.getProperty(name).getValues());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public List<String> list(String name) {
        return this.list(name, null);
    }

    public List<String> list(String name, List<String> defaultValue) {
        try {
            return this.valuesToList(this.node.getProperty(name).getValues());
        }
        catch (Exception e) {
            return null;
        }
    }

    String[] valuesToArray(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new String[0];
        }
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    List<String> valuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (values.length < 1) {
            return list;
        }
        if (values.length == 1) {
            list.add(values[0].getString());
            return list;
        }
        for (int i = 0; i < values.length; ++i) {
            list.add(values[i].getString());
        }
        return list;
    }
}

