/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.impl.GroupImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserHelper {
    private static OrganizationService getOrganizationService() {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        return organizationService;
    }

    private static UserHandler getUserHandler() {
        return UserHelper.getOrganizationService().getUserHandler();
    }

    private static GroupHandler getGroupHandler() {
        return UserHelper.getOrganizationService().getGroupHandler();
    }

    public static List<Group> getAllGroup() throws Exception {
        PageList pageList = (PageList)UserHelper.getGroupHandler().getAllGroups();
        List list = pageList.getAll();
        return list;
    }

    public static String checkValueUser(String values) throws Exception {
        String erroUser = null;
        if (values != null && values.trim().length() > 0) {
            String[] userIds;
            for (String str : userIds = values.split(",")) {
                if ((str = str.trim()).indexOf("/") >= 0) {
                    if (UserHelper.hasGroupIdAndMembershipId(str)) continue;
                    if (erroUser == null) {
                        erroUser = str;
                        continue;
                    }
                    erroUser = erroUser + ", " + str;
                    continue;
                }
                if (UserHelper.getUserHandler().findUserByName(str) != null) continue;
                erroUser = erroUser == null ? str : erroUser + ", " + str;
            }
        }
        return erroUser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasGroupIdAndMembershipId(String str) throws Exception {
        if (str.indexOf(":") >= 0) {
            String[] array = str.split(":");
            try {
                UserHelper.getGroupHandler().findGroupById(array[1]).getId();
            }
            catch (Exception e) {
                return false;
            }
            if (array[0].length() == 1 && array[0].charAt(0) == '*') {
                return true;
            }
            if (array[0].length() <= 0) return false;
            if (UserHelper.getOrganizationService().getMembershipTypeHandler().findMembershipType(array[0]) != null) return true;
            return false;
        }
        try {
            UserHelper.getGroupHandler().findGroupById(str).getId();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasUserInGroup(String groupId, String userId) throws Exception {
        List users = UserHelper.getUserHandler().findUsersByGroup(groupId).getAll();
        for (User user : users) {
            if (!user.getUserName().equals(userId)) continue;
            return true;
        }
        return false;
    }

    public static List<User> getUserByGroupId(String groupId) throws Exception {
        return UserHelper.getUserHandler().findUsersByGroup(groupId).getAll();
    }

    public static User getUserByUserId(String userId) throws Exception {
        return UserHelper.getUserHandler().findUserByName(userId);
    }

    public static List<User> getAllUser() throws Exception {
        PageList pageList = UserHelper.getUserHandler().getUserPageList(0);
        List list = pageList.getAll();
        return list;
    }

    public static String[] getUserGroups() throws Exception {
        Object[] objGroupIds = UserHelper.getGroupHandler().findGroupsOfUser(UserHelper.getCurrentUser()).toArray();
        String[] groupIds = new String[objGroupIds.length];
        for (int i = 0; i < groupIds.length; ++i) {
            groupIds[i] = ((GroupImpl)objGroupIds[i]).getId();
        }
        return groupIds;
    }

    public static PageList getPageListUser() throws Exception {
        return UserHelper.getUserHandler().getUserPageList(0);
    }

    public static boolean isAnonim() throws Exception {
        String userId = UserHelper.getCurrentUser();
        return userId == null;
    }

    public static List<String> getAllGroupAndMembershipOfUser(String userId) throws Exception {
        ArrayList<String> listOfUser = new ArrayList<String>();
        if (userId == null) {
            return listOfUser;
        }
        listOfUser.add(userId);
        String value = "";
        Collection memberships = UserHelper.getOrganizationService().getMembershipHandler().findMembershipsByUser(userId);
        for (Membership membership : memberships) {
            value = membership.getGroupId();
            listOfUser.add(value);
            value = membership.getMembershipType() + ":" + value;
            listOfUser.add(value);
        }
        return listOfUser;
    }

    public static String getEmailUser(String userName) throws Exception {
        User user = UserHelper.getUserHandler().findUserByName(userName);
        String email = user.getEmail();
        return email;
    }

    public static String getCurrentUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }
}

