/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.jcr;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ks.common.jcr.JCRSessionManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCRListAccess<E>
implements ListAccess<E> {
    protected JCRSessionManager manager;

    public JCRListAccess(JCRSessionManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E[] load(int index, int length) throws Exception, IllegalArgumentException {
        Session session = this.manager.openSession();
        try {
            E[] EArray = this.load(session, index, length);
            return EArray;
        }
        finally {
            this.manager.closeSession();
        }
    }

    private Session acquireSession() throws RepositoryException, RepositoryConfigurationException {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        String defaultWS = repositoryService.getDefaultRepository().getConfiguration().getDefaultWorkspaceName();
        return sProvider.getSession(defaultWS, repositoryService.getCurrentRepository());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws Exception {
        Session session = this.manager.openSession();
        try {
            int n = this.getSize(session);
            return n;
        }
        finally {
            this.manager.closeSession();
        }
    }

    protected abstract E[] load(Session var1, int var2, int var3) throws Exception, IllegalArgumentException;

    protected abstract int getSize(Session var1) throws Exception;
}

