/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.rss;

import java.util.Arrays;
import java.util.List;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.rss.RSSProcess;

public class ForumRSSEventListener
implements EventListener {
    private String path_;
    private String workspace_;
    private String repository_;
    private List<String> listPropertyNotGetEvent = Arrays.asList("exo:rssWatching", "ks.rss", "exo:emailWatching", "exo:userWatching");
    private KSDataLocation locator;

    public ForumRSSEventListener(KSDataLocation dataLocator) throws Exception {
        this.locator = dataLocator;
        this.workspace_ = dataLocator.getWorkspace();
        this.repository_ = dataLocator.getRepository();
    }

    public String getSrcWorkspace() {
        return this.workspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    public void onEvent(EventIterator evIter) {
        try {
            RSSProcess process = new RSSProcess(this.locator);
            String path = null;
            if (evIter.hasNext()) {
                Event ev = evIter.nextEvent();
                path = ev.getPath();
                if (ev.getType() == 1) {
                    process.generateRSS(ev.getPath(), 1);
                } else if (ev.getType() == 16) {
                    process.generateRSS(path.substring(0, path.lastIndexOf("/")), 16);
                } else if (ev.getType() == 2) {
                    process.generateRSS(ev.getPath(), 2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

