/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.rss;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.ks.rss.FeedContentProvider;
import org.exoplatform.ks.rss.FeedResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class KSRSSServlet
extends AbstractHttpServlet {
    private static Log LOG = ExoLogger.getLogger(KSRSSServlet.class);
    private FeedResolver feedResolver;

    public void afterInit(ServletConfig config) throws ServletException {
    }

    public void onService(ExoContainer container, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Cache-Control", "private max-age=600, s-maxage=120");
        String objectId = this.extractObjectId(request);
        String appType = this.extractAppType(request);
        FeedContentProvider provider = this.resolveFeedContentProvider(container, appType);
        if (provider == null) {
            throw new ServletException("'" + appType + "' is not a recognized application");
        }
        InputStream is = provider.getFeedContent(objectId);
        byte[] buf = this.readStream(is);
        if (buf == null) {
            throw new ServletException("The feed '" + objectId + "' is not available");
        }
        response.setContentType("text/xml");
        ServletOutputStream os = response.getOutputStream();
        os.write(buf);
    }

    String extractAppType(HttpServletRequest request) {
        String pathInfo = this.checkPathInfo(request);
        int idx = pathInfo.indexOf("/");
        String appType = idx <= 0 ? "" : pathInfo.substring(0, idx);
        return appType;
    }

    String checkPathInfo(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.length() == 0) {
            throw new IllegalArgumentException("Invalid null path in URL");
        }
        pathInfo = pathInfo.substring(1);
        return pathInfo;
    }

    String extractObjectId(HttpServletRequest request) {
        String pathInfo = this.checkPathInfo(request);
        int idx = pathInfo.indexOf("/");
        String objectId = idx <= 0 ? pathInfo : pathInfo.substring(idx + 1);
        return objectId;
    }

    private FeedContentProvider resolveFeedContentProvider(ExoContainer container, String appType) {
        FeedResolver resolver = this.getFeedResolver();
        FeedContentProvider provider = resolver.resolve(appType);
        return provider;
    }

    private byte[] readStream(InputStream is) throws IOException {
        byte[] buf = null;
        if (is != null) {
            buf = new byte[is.available()];
            is.read(buf);
        }
        return buf;
    }

    public FeedResolver getFeedResolver() {
        if (this.feedResolver == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.feedResolver = (FeedResolver)container.getComponentInstanceOfType(FeedResolver.class);
        }
        return this.feedResolver;
    }

    public void setFeedResolver(FeedResolver feedResolver) {
        this.feedResolver = feedResolver;
    }
}

