/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.PropertyReader;
import org.exoplatform.ks.rss.RSS;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class RSSProcess {
    public int maxSize = 20;
    protected KSDataLocation dataLocator;
    private static final Log LOG = ExoLogger.getLogger(RSSProcess.class);

    public RSSProcess() {
        this.dataLocator = (KSDataLocation)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(KSDataLocation.class);
    }

    public RSSProcess(KSDataLocation dataLocator) {
        this.dataLocator = dataLocator;
    }

    public RSSProcess(InitParams params, KSDataLocation dataLocator) {
        this.dataLocator = dataLocator;
        this.init(params);
    }

    private void init(InitParams params) {
        String maximum;
        if (params == null) {
            return;
        }
        PropertiesParam proParams = params.getPropertiesParam("rss-limit-config");
        if (proParams != null && (maximum = proParams.getProperty("maximum.rss")) != null && maximum.length() > 0) {
            try {
                this.maxSize = Integer.parseInt(maximum);
            }
            catch (Exception e) {
                this.maxSize = 10;
            }
        }
    }

    protected Session getCurrentSession() {
        return this.dataLocator.getSessionManager().getCurrentSession();
    }

    protected String getPageLink() throws Exception {
        try {
            PortalRequestContext portalContext = Util.getPortalRequestContext();
            return portalContext.getRequest().getRequestURL().toString().replaceFirst("private", "public");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected InputStream getFeedStream(Node parentNode, String feedNodetype, String feedTitle) throws Exception {
        RSS feed = this.loadOrCreateFeed(parentNode, feedNodetype, feedTitle);
        return feed.getContent();
    }

    protected RSS loadOrCreateFeed(Node parentNode, String feedNodetype) throws Exception {
        return this.loadOrCreateFeed(parentNode, feedNodetype, null);
    }

    protected RSS loadOrCreateFeed(Node parentNode, String feedNodetype, String feedTitle) throws Exception {
        RSS rss = new RSS(parentNode);
        if (!rss.feedExists()) {
            PropertyReader reader = new PropertyReader(parentNode);
            String title = reader.string("exo:name", feedTitle);
            String description = reader.string("exo:description", " ");
            SyndFeed feed = RSS.createNewFeed(title, new Date());
            ArrayList entries = new ArrayList();
            feed.setDescription(description);
            feed.setEntries(entries);
            rss = new RSS(parentNode);
            rss.saveFeed(feed, feedNodetype);
        }
        return rss;
    }

    protected Node getNodeById(String objectId) throws Exception {
        Node parentNode = this.getForumServiceHome();
        QueryManager qm = this.dataLocator.getSessionManager().getCurrentSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root" + parentNode.getPath() + "//*[@exo:id='").append(objectId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        parentNode = result.getNodes().nextNode();
        return parentNode;
    }

    protected Node getForumServiceHome() throws Exception {
        String path = this.dataLocator.getForumHomeLocation();
        return this.dataLocator.getSessionManager().getCurrentSession().getRootNode().getNode(path);
    }

    public KSDataLocation getDataLocator() {
        return this.dataLocator;
    }

    public void setDataLocator(KSDataLocation dataLocator) {
        this.dataLocator = dataLocator;
    }
}

