/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQFormSearch;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.service.Watch;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuestionPageList
extends JCRPageList {
    private NodeIterator iter_ = null;
    private boolean isQuery_ = false;
    private String value_;
    private boolean isNotYetAnswered = false;
    private List<Question> listQuestions_ = null;
    private List<FAQFormSearch> listFAQFormSearchS_ = null;
    private List<Watch> listWatchs_ = null;
    private List<Category> listCategories_ = null;
    private String questionQuery_ = new String();
    private Node nodeCategory_ = null;
    private List<Object> listObject_ = new ArrayList<Object>();
    private FAQSetting faqSetting_ = null;

    public void setNotYetAnswered(boolean isNotYetAnswered) {
        this.isNotYetAnswered = isNotYetAnswered;
        this.setTotalQuestion();
    }

    private void setTotalQuestion() {
        this.listQuestions_ = new ArrayList<Question>();
        String[] response = new String[]{""};
        NodeIterator nodeIterator = this.iter_;
        NodeIterator languageIter = null;
        Node questionNode = null;
        Node languageNode = null;
        String languages = null;
        while (nodeIterator.hasNext()) {
            languages = new String();
            questionNode = nodeIterator.nextNode();
            try {
                response = this.ValuesToStrings(questionNode.getProperty("exo:responses").getValues());
                if (response[0] == null || response[0].trim().length() < 1) {
                    languages = questionNode.getProperty("exo:language").getValue().getString();
                }
                if (questionNode.hasNode("languages")) {
                    languageNode = questionNode.getNode("languages");
                    languageIter = languageNode.getNodes();
                    while (languageIter.hasNext()) {
                        Node language = languageIter.nextNode();
                        try {
                            response = this.ValuesToStrings(language.getProperty("exo:responses").getValues());
                        }
                        catch (Exception e) {
                            response = new String[]{language.getProperty("exo:responses").getValue().getString()};
                        }
                        if (response[0] != null && response[0].trim().length() >= 1) continue;
                        if (languages != null && languages.trim().length() > 0) {
                            languages = languages + ",";
                        }
                        languages = languages + language.getName();
                    }
                }
                if (languages == null || languages.trim().length() <= 0) continue;
                this.listQuestions_.add(this.getQuestion(questionNode).setLanguagesNotYetAnswered(languages));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setAvailablePage(this.listQuestions_.size());
    }

    public QuestionPageList(NodeIterator iter, long pageSize, String value, boolean isQuery) throws Exception {
        super(pageSize);
        this.iter_ = iter;
        this.value_ = value;
        this.isQuery_ = isQuery;
        this.setAvailablePage(iter.getSize());
    }

    public QuestionPageList(List<FAQFormSearch> faqFormSearchs, long pageSize) throws Exception {
        super(pageSize);
        this.listFAQFormSearchS_ = faqFormSearchs;
        this.setAvailablePage(faqFormSearchs.size());
    }

    public QuestionPageList(List<Watch> listWatch, double page) throws Exception {
        super(10L);
        this.listWatchs_ = listWatch;
        this.setAvailablePage(listWatch.size());
    }

    public QuestionPageList(List<Category> listCategories) throws Exception {
        super(10L);
        this.listCategories_ = listCategories;
        this.setAvailablePage(listCategories.size());
    }

    public QuestionPageList(List<Question> listQuestions, int size) throws Exception {
        super(10L);
        this.listQuestions_ = listQuestions;
        this.setAvailablePage(size);
    }

    public QuestionPageList(Node categoryNode, String quesQuerry, List<Object> listObject, FAQSetting setting) throws Exception {
        super(10L);
        this.questionQuery_ = quesQuerry;
        this.nodeCategory_ = categoryNode;
        this.listObject_.addAll(listObject);
        this.faqSetting_ = setting;
        this.setAvailablePage(listObject.size());
    }

    @Override
    protected void populateCurrentPage(long page, String username) throws Exception {
        if (this.iter_ == null || !this.iter_.hasNext()) {
            Session session = this.getJCRSession();
            if (this.isQuery_) {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            } else {
                Node node = (Node)session.getItem(this.value_);
                this.iter_ = node.getNodes();
            }
            if (this.isNotYetAnswered) {
                this.setTotalQuestion();
            }
            session.logout();
        }
        if (this.isNotYetAnswered) {
            this.setAvailablePage(this.listQuestions_.size());
        } else {
            this.setAvailablePage(this.iter_.getSize());
        }
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        this.currentListPage_ = new ArrayList();
        if (!this.isNotYetAnswered) {
            this.iter_.skip(position);
            Question question = new Question();
            int i = 0;
            while ((long)i < pageSize && this.iter_ != null && this.iter_.hasNext()) {
                question = this.getQuestion(this.iter_.nextNode());
                this.currentListPage_.add(question);
                ++i;
            }
        } else {
            pageSize += position;
            for (int i = (int)position; (long)i < pageSize && i < this.listQuestions_.size(); ++i) {
                this.currentListPage_.add(this.listQuestions_.get(i));
            }
        }
        this.iter_ = null;
    }

    @Override
    protected void populateCurrentPageWatch(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        pageSize *= page;
        this.currentListWatch_ = new ArrayList();
        for (int i = (int)position; (long)i < pageSize && i < this.listWatchs_.size(); ++i) {
            this.currentListWatch_.add(this.listWatchs_.get(i));
        }
    }

    @Override
    protected void populateCurrentPageResultSearch(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        pageSize *= page;
        this.currentListResultSearch_ = new ArrayList();
        for (int i = (int)position; (long)i < pageSize && i < this.listFAQFormSearchS_.size(); ++i) {
            this.currentListResultSearch_.add(this.listFAQFormSearchS_.get(i));
        }
    }

    @Override
    protected void populateCurrentPageCategoriesSearch(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        pageSize *= page;
        this.currentListCategory_ = new ArrayList();
        for (int i = (int)position; (long)i < pageSize && i < this.listCategories_.size(); ++i) {
            this.currentListCategory_.add(this.listCategories_.get(i));
        }
    }

    @Override
    protected void populateCurrentPageQuestionsSearch(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        pageSize *= page;
        this.currentListPage_ = new ArrayList();
        for (int i = (int)position; (long)i < pageSize && i < this.listQuestions_.size(); ++i) {
            this.currentListPage_.add(this.listQuestions_.get(i));
        }
    }

    @Override
    protected void populateCurrentPageCategoriesQuestionsSearch(long page, String username) throws Exception {
        String idSearch = this.getObjectRepare_();
        int posSearch = 0;
        if (this.listObject_ == null || this.listObject_.isEmpty()) {
            this.listObject_ = new ArrayList<Object>();
            int size = 0;
            Session session = this.getJCRSession();
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(this.questionQuery_, "xpath");
            QueryResult result = query.execute();
            this.iter_ = result.getNodes();
            Question question = null;
            while (this.iter_.hasNext()) {
                question = this.getQuestion(this.iter_.nextNode());
                if (!question.getId().equals(idSearch)) {
                    ++size;
                } else {
                    posSearch = size + 1;
                }
                this.listObject_.add(question);
            }
            this.iter_ = null;
            this.iter_ = this.nodeCategory_.getNodes();
            ArrayList<Category> listCategory = new ArrayList<Category>();
            while (this.iter_.hasNext()) {
                listCategory.add(this.getCategory(this.iter_.nextNode()));
            }
            if (this.faqSetting_.getOrderBy().equals("created")) {
                if (this.faqSetting_.getOrderType().equals("asc")) {
                    Collections.sort(listCategory, new Utils.DatetimeComparatorASC());
                } else {
                    Collections.sort(listCategory, new Utils.DatetimeComparatorDESC());
                }
            } else if (this.faqSetting_.getOrderType().equals("asc")) {
                Collections.sort(listCategory, new Utils.NameComparatorASC());
            } else {
                Collections.sort(listCategory, new Utils.NameComparatorDESC());
            }
            this.listObject_.addAll(listCategory);
            if (this.getAvailablePage() < (long)this.listObject_.size()) {
                this.setAvailablePage(this.listObject_.size());
            }
            this.iter_ = null;
        }
        long pageSize = this.getPageSize();
        long position = 0L;
        if (posSearch > 0) {
            int t = (posSearch /= (int)pageSize) % (int)pageSize;
            if (t > 0 || posSearch == 0) {
                ++posSearch;
            }
            page = posSearch;
            this.setObjectRepare_(null);
        }
        this.setPageJump(page);
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        pageSize *= page;
        this.currentListObject_ = new ArrayList();
        for (int i = (int)position; (long)i < pageSize && i < this.listObject_.size(); ++i) {
            this.currentListObject_.add(this.listObject_.get(i));
        }
        this.listObject_ = null;
    }

    private Question getQuestion(Node questionNode) throws Exception {
        Question question = new Question();
        question.setId(questionNode.getName());
        if (questionNode.hasProperty("exo:language")) {
            question.setLanguage(questionNode.getProperty("exo:language").getString());
        }
        if (questionNode.hasProperty("exo:name")) {
            question.setQuestion(questionNode.getProperty("exo:name").getString());
        }
        if (questionNode.hasProperty("exo:author")) {
            question.setAuthor(questionNode.getProperty("exo:author").getString());
        }
        if (questionNode.hasProperty("exo:email")) {
            question.setEmail(questionNode.getProperty("exo:email").getString());
        }
        if (questionNode.hasProperty("exo:createdDate")) {
            question.setCreatedDate(questionNode.getProperty("exo:createdDate").getDate().getTime());
        }
        if (questionNode.hasProperty("exo:categoryId")) {
            question.setCategoryId(questionNode.getProperty("exo:categoryId").getString());
        }
        if (questionNode.hasProperty("exo:isActivated")) {
            question.setActivated(questionNode.getProperty("exo:isActivated").getBoolean());
        }
        if (questionNode.hasProperty("exo:isApproved")) {
            question.setApproved(questionNode.getProperty("exo:isApproved").getBoolean());
        }
        if (questionNode.hasProperty("exo:responses")) {
            question.setResponses(this.ValuesToStrings(questionNode.getProperty("exo:responses").getValues()));
        }
        if (questionNode.hasProperty("exo:relatives")) {
            question.setRelations(this.ValuesToStrings(questionNode.getProperty("exo:relatives").getValues()));
        }
        if (questionNode.hasProperty("exo:responseBy")) {
            question.setResponseBy(this.ValuesToStrings(questionNode.getProperty("exo:responseBy").getValues()));
        }
        if (questionNode.hasProperty("exo:dateResponse")) {
            question.setDateResponse(this.ValuesToDate(questionNode.getProperty("exo:dateResponse").getValues()));
        }
        ArrayList<FileAttachment> attList = new ArrayList<FileAttachment>();
        NodeIterator nodeIterator = questionNode.getNodes();
        FileAttachment attachment = null;
        String workspace = "";
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            if (!node.isNodeType("nt:file")) continue;
            attachment = new FileAttachment();
            Node nodeFile = node.getNode("jcr:content");
            attachment.setId(node.getPath());
            attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
            attachment.setNodeName(node.getName());
            attachment.setName(node.getProperty("exo:fileName").getValue().getString());
            workspace = node.getSession().getWorkspace().getName();
            attachment.setWorkspace(workspace);
            attachment.setPath("/" + workspace + node.getPath());
            try {
                if (nodeFile.hasProperty("jcr:data")) {
                    attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                } else {
                    attachment.setSize(0L);
                }
            }
            catch (Exception e) {
                attachment.setSize(0L);
                e.printStackTrace();
            }
            attList.add(attachment);
        }
        question.setAttachMent(attList);
        return question;
    }

    private Category getCategory(Node categoryNode) throws Exception {
        Category cat = new Category();
        cat.setId(categoryNode.getName());
        if (categoryNode.hasProperty("exo:name")) {
            cat.setName(categoryNode.getProperty("exo:name").getString());
        }
        if (categoryNode.hasProperty("exo:description")) {
            cat.setDescription(categoryNode.getProperty("exo:description").getString());
        }
        if (categoryNode.hasProperty("exo:createdDate")) {
            cat.setCreatedDate(categoryNode.getProperty("exo:createdDate").getDate().getTime());
        }
        if (categoryNode.hasProperty("exo:moderators")) {
            cat.setModerators(this.ValuesToStrings(categoryNode.getProperty("exo:moderators").getValues()));
        }
        if (categoryNode.hasProperty("exo:isModerateQuestions")) {
            cat.setModerateQuestions(categoryNode.getProperty("exo:isModerateQuestions").getBoolean());
        }
        return cat;
    }

    private String[] ValuesToStrings(Value[] Val) throws Exception {
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    private Date[] ValuesToDate(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new Date[0];
        }
        Date[] dates = new Date[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            dates[i] = Val[i].getDate().getTime();
        }
        return dates;
    }

    @Override
    public List<Question> getAll() throws Exception {
        if (this.iter_ == null) {
            Session session = this.getJCRSession();
            if (this.isQuery_) {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            } else {
                Node node = (Node)session.getItem(this.value_);
                this.iter_ = node.getNodes();
            }
            session.logout();
        }
        ArrayList<Question> questions = new ArrayList<Question>();
        while (this.iter_.hasNext()) {
            Node questionNode = this.iter_.nextNode();
            questions.add(this.getQuestion(questionNode));
        }
        return questions;
    }

    @Override
    public void setList(List<Question> contacts) {
    }

    private Session getJCRSession() throws Exception {
        RepositoryService repositoryService = (RepositoryService)PortalContainer.getComponent(RepositoryService.class);
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        String defaultWS = repositoryService.getDefaultRepository().getConfiguration().getDefaultWorkspaceName();
        return sessionProvider.getSession(defaultWS, repositoryService.getCurrentRepository());
    }
}

