/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service.notify;

import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.faq.service.FAQService;

public class RSSEventListener
implements EventListener {
    private String workspace_;
    private String repository_;
    private final int EVENT_ADDNEW = 0;
    private final int EVENT_EDIT = 1;
    private final int EVENT_REMOVE = 2;

    public RSSEventListener(String ws, String repo) throws Exception {
        this.workspace_ = ws;
        this.repository_ = repo;
    }

    public String getSrcWorkspace() {
        return this.workspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public void onEvent(EventIterator evIter) {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            FAQService faqService = (FAQService)container.getComponentInstanceOfType(FAQService.class);
            if (evIter.hasNext()) {
                Event ev = evIter.nextEvent();
                if (ev.getType() == 1) {
                    faqService.generateRSS(ev.getPath(), 0);
                } else if (ev.getType() == 16) {
                    String propertyPath = ev.getPath();
                    String nodePath = propertyPath.substring(0, propertyPath.lastIndexOf("/"));
                    faqService.generateRSS(nodePath, 1);
                } else if (ev.getType() == 2) {
                    faqService.generateRSS(ev.getPath(), 2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

