/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.JcrInputProperty;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormUploadInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FAQUtils {
    public static String DISPLAYAPPROVED = "approved";
    public static String DISPLAYBOTH = "both";
    private static String AKONG = "@";
    public static String[] specialString = new String[]{"!", "#", "$", "%", "^", "&", ":", ">", "<", "~", "`", "]", "'", "/"};

    public static FAQService getFAQService() throws Exception {
        return (FAQService)PortalContainer.getComponent(FAQService.class);
    }

    public static String filterString(String text, boolean isEmail) {
        for (String str : specialString) {
            text = text.replaceAll(str, "");
        }
        if (!isEmail) {
            text = text.replaceAll(AKONG, "");
        }
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '?' || text.charAt(i) == '[' || text.charAt(i) == '(' || text.charAt(i) == '|' || text.charAt(i) == ')' || text.charAt(i) == '*' || text.charAt(i) == '\\' || text.charAt(i) == '+' || text.charAt(i) == '}' || text.charAt(i) == '{' || text.charAt(i) == '^' || text.charAt(i) == '$' || text.charAt(i) == '\"') {
                text = text.replace(text.charAt(i) + "", "");
                continue;
            }
            ++i;
        }
        return text;
    }

    public static boolean CheckSpecial(String text) {
        Boolean check = false;
        if (text != null && text.trim().length() > 0) {
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) == '?' || text.charAt(i) == '[' || text.charAt(i) == '(' || text.charAt(i) == '|' || text.charAt(i) == ')' || text.charAt(i) == '*' || text.charAt(i) == '\\' || text.charAt(i) == '+' || text.charAt(i) == '}' || text.charAt(i) == '{' || text.charAt(i) == '^' || text.charAt(i) == '$' || text.charAt(i) == '\"' || text.charAt(i) == '!' || text.charAt(i) == '#' || text.charAt(i) == '%' || text.charAt(i) == ':' || text.charAt(i) == '&' || text.charAt(i) == '>' || text.charAt(i) == '<' || text.charAt(i) == '~' || text.charAt(i) == '`' || text.charAt(i) == ']' || text.charAt(i) == '/') {
                    text = text.replace(text.charAt(i) + "", "");
                    check = true;
                    continue;
                }
                ++i;
            }
            return check;
        }
        return false;
    }

    public static User getUserByUserId(String userId) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        return organizationService.getUserHandler().findUserByName(userId);
    }

    public static List<User> getAllUser() throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        PageList pageList = organizationService.getUserHandler().getUserPageList(0);
        List list = pageList.getAll();
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasGroupIdAndMembershipId(String str, OrganizationService organizationService) throws Exception {
        if (str.indexOf(":") >= 0) {
            String[] array = str.split(":");
            try {
                organizationService.getGroupHandler().findGroupById(array[1]).getId();
            }
            catch (Exception e) {
                return false;
            }
            if (array[0].length() <= 0) return false;
            if (array[0].charAt(0) == '*' && array[0].length() == 1) {
                return true;
            }
            if (organizationService.getMembershipTypeHandler().findMembershipType(array[0]) != null) return true;
            return false;
        }
        try {
            organizationService.getGroupHandler().findGroupById(str).getId();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String checkValueUser(String values) throws Exception {
        String erroUser = null;
        if (values != null && values.trim().length() > 0) {
            OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
            String[] userIds = values.split(",");
            boolean isUser = false;
            List users = FAQUtils.getAllUser();
            for (String str : userIds) {
                if ((str = str.trim()).indexOf("/") >= 0) {
                    if (FAQUtils.hasGroupIdAndMembershipId((String)str, (OrganizationService)organizationService)) continue;
                    if (erroUser == null) {
                        erroUser = str;
                        continue;
                    }
                    erroUser = erroUser + ", " + str;
                    continue;
                }
                isUser = false;
                for (User user : users) {
                    if (!user.getUserName().equals(str)) continue;
                    isUser = true;
                    break;
                }
                if (isUser) continue;
                erroUser = erroUser == null ? str : erroUser + ", " + str;
            }
        }
        return erroUser;
    }

    public static String[] splitForFAQ(String str) throws Exception {
        if (str != null && str.length() > 0) {
            if (str.contains(",")) {
                return str.trim().split(",");
            }
            return str.trim().split(";");
        }
        return new String[0];
    }

    public static SessionProvider getSystemProvider() {
        return SessionProviderFactory.createSystemProvider();
    }

    public static String getCurrentUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public static String getEmailUser(String userName) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        User user = organizationService.getUserHandler().findUserByName(userName);
        String email = user.getEmail();
        return email;
    }

    public static String getFullName(String userName) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        User user = organizationService.getUserHandler().findUserByName(userName);
        String fullName = user.getFullName();
        return fullName;
    }

    public static boolean isFieldEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isValidEmailAddresses(String addressList) throws Exception {
        if (FAQUtils.isFieldEmpty((String)addressList)) {
            return true;
        }
        boolean isInvalid = true;
        try {
            InternetAddress[] iAdds = InternetAddress.parse((String)addressList, (boolean)true);
            String emailRegex = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+\\.[A-Za-z]{2,5}";
            for (int i = 0; i < iAdds.length; ++i) {
                if (iAdds[i].getAddress().toString().matches(emailRegex)) continue;
                isInvalid = false;
            }
        }
        catch (AddressException e) {
            return false;
        }
        return isInvalid;
    }

    public static String[] getQuestionLanguages() {
        return null;
    }

    public static Map prepareMap(List inputs, Map properties) throws Exception {
        HashMap<String, JcrInputProperty> rawinputs = new HashMap<String, JcrInputProperty>();
        HashMap<String, JcrInputProperty> hasMap = new HashMap<String, JcrInputProperty>();
        for (int i = 0; i < inputs.size(); ++i) {
            JcrInputProperty property = null;
            if (inputs.get(i) instanceof UIFormMultiValueInputSet) {
                String inputName = ((UIFormMultiValueInputSet)inputs.get(i)).getName();
                if (!hasMap.containsKey(inputName)) {
                    List values = ((UIFormMultiValueInputSet)inputs.get(i)).getValue();
                    property = (JcrInputProperty)properties.get(inputName);
                    if (property != null) {
                        property.setValue((Object)values.toArray(new String[values.size()]));
                    }
                }
                hasMap.put(inputName, property);
                continue;
            }
            UIFormInputBase input = (UIFormInputBase)inputs.get(i);
            property = (JcrInputProperty)properties.get(input.getName());
            if (property == null) continue;
            if (input instanceof UIFormUploadInput) {
                byte[] content = ((UIFormUploadInput)input).getUploadData();
                property.setValue((Object)content);
                continue;
            }
            if (input instanceof UIFormDateTimeInput) {
                property.setValue((Object)((UIFormDateTimeInput)input).getCalendar());
                continue;
            }
            property.setValue(input.getValue());
        }
        for (JcrInputProperty property : properties.values()) {
            rawinputs.put(property.getJcrPath(), property);
        }
        return rawinputs;
    }

    public static String getSubString(String str, int max) {
        int l;
        if (!FAQUtils.isFieldEmpty((String)str) && (l = str.length()) > max) {
            int space = (str = str.substring(0, max - 3)).lastIndexOf(" ");
            str = space > 0 ? str.substring(0, space) + "..." : str + "...";
        }
        return str;
    }

    public static String getTitle(String text) {
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\"') {
                text = text.replace(text.charAt(i) + "", "&quot;");
                continue;
            }
            ++i;
        }
        return text;
    }

    public static void getPorletPreference(FAQSetting faqSetting) {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        faqSetting.setDisplayMode(portletPref.getValue("display", ""));
        faqSetting.setOrderBy(portletPref.getValue("orderBy", ""));
        faqSetting.setOrderType(portletPref.getValue("orderType", ""));
    }

    public static void getEmailSetting(FAQSetting faqSetting, boolean isNew, boolean isSettingForm) {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String emailContent = "";
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        emailContent = isNew ? portletPref.getValue("SendMailAddNewQuestion", "") : portletPref.getValue("SendMailEditResponseQuestion", "");
        if (emailContent == null || emailContent.trim().length() < 1) {
            emailContent = isNew ? res.getString("SendEmail.AddNewQuestion.Default") : res.getString("SendEmail.EditOrResponseQuestion.Default");
        }
        faqSetting.setEmailSettingSubject(res.getString("SendEmail.Default.Subject"));
        faqSetting.setEmailSettingContent(emailContent);
    }

    public static void savePortletPreference(FAQSetting setting, String emailAddNewQuestion, String emailEditResponseQuestion) {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        try {
            portletPref.setValue("display", setting.getDisplayMode());
            portletPref.setValue("orderBy", setting.getOrderBy());
            portletPref.setValue("orderType", setting.getOrderType());
            portletPref.setValue("SendMailAddNewQuestion", emailAddNewQuestion);
            portletPref.setValue("SendMailEditResponseQuestion", emailEditResponseQuestion);
            portletPref.store();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

