/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UIQuestionForm;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIQuestionForm.gtmpl", events={@EventConfig(listeners={AddLanguageActionListener.class}), @EventConfig(listeners={AttachmentActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={RemoveAttachmentActionListener.class})})
public class UIQuestionForm
extends UIForm
implements UIPopupComponent {
    public static final String AUTHOR = "Author";
    public static final String EMAIL_ADDRESS = "EmailAddress";
    public static final String WYSIWYG_INPUT = "Question";
    public static final String LIST_WYSIWYG_INPUT = "ListQuestion";
    public static final String ATTACHMENTS = "Attachment";
    public static final String FILE_ATTACHMENTS = "FileAttach";
    public static final String REMOVE_FILE_ATTACH = "RemoveFile";
    public static final String IS_APPROVED = "IsApproved";
    public static final String IS_ACTIVATED = "IsActivated";
    private UIFormStringInput inputAuthor = null;
    private UIFormStringInput inputEmailAddress = null;
    private static UIFormInputWithActions listFormWYSIWYGInput = null;
    private UIFormCheckBoxInput<Boolean> inputIsApproved = null;
    private UIFormCheckBoxInput<Boolean> inputIsActivated = null;
    private UIFormInputWithActions inputAttachcment = null;
    private static FAQService fAQService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    private static Question question_ = null;
    private Map<String, List<UIFormInputWithActions.ActionData>> actionField_;
    private List<String> LIST_LANGUAGE = new ArrayList();
    private List<FileAttachment> listFileAttach_ = new ArrayList();
    private Map<String, QuestionLanguage> mapLanguageNode_ = new HashMap();
    private String categoryId_ = null;
    private String questionId_ = null;
    private String defaultLanguage_ = "";
    private String link_ = "";
    private String author_ = "";
    private String email_ = "";
    private List<String> questionContents_ = new ArrayList();
    private boolean isApproved_ = true;
    private boolean isActivated_ = true;
    private boolean isChildOfManager = false;
    private FAQSetting faqSetting_;

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getLink() {
        return this.link_;
    }

    public void setLink(String link) {
        this.link_ = link;
    }

    public void setFAQSetting(FAQSetting faqSetting) {
        this.faqSetting_ = faqSetting;
    }

    public UIQuestionForm() throws Exception {
        this.LIST_LANGUAGE.clear();
        this.listFileAttach_.clear();
        this.mapLanguageNode_.clear();
        this.questionContents_.clear();
        this.listFileAttach_ = new ArrayList();
        this.actionField_ = new HashMap();
        this.questionId_ = new String();
        question_ = null;
    }

    public void refresh() throws Exception {
        this.listFileAttach_.clear();
    }

    public void initPage(boolean isEdit) {
        if (isEdit) {
            this.removeChildById(AUTHOR);
            this.removeChildById(EMAIL_ADDRESS);
            this.removeChildById(LIST_WYSIWYG_INPUT);
            this.removeChildById(IS_APPROVED);
            this.removeChildById(IS_ACTIVATED);
            this.removeChildById(ATTACHMENTS);
        } else {
            this.inputAuthor = new UIFormStringInput(AUTHOR, AUTHOR, this.author_);
            this.inputEmailAddress = new UIFormStringInput(EMAIL_ADDRESS, EMAIL_ADDRESS, this.email_);
            this.inputIsApproved = new UIFormCheckBoxInput(IS_APPROVED, IS_APPROVED, (Object)false);
            this.inputIsActivated = new UIFormCheckBoxInput(IS_ACTIVATED, IS_ACTIVATED, (Object)false);
            this.inputAttachcment = new UIFormInputWithActions(ATTACHMENTS);
            this.inputAttachcment.addUIFormInput((UIFormInput)new UIFormInputInfo(FILE_ATTACHMENTS, FILE_ATTACHMENTS, null));
            try {
                this.inputAttachcment.setActionField(FILE_ATTACHMENTS, this.getActionList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        listFormWYSIWYGInput = new UIFormInputWithActions(LIST_WYSIWYG_INPUT);
        for (int i = 0; i < this.LIST_LANGUAGE.size(); ++i) {
            UIFormTextAreaInput textAreaInput = new UIFormTextAreaInput(WYSIWYG_INPUT + i, WYSIWYG_INPUT + i, null);
            textAreaInput.setColumns(80);
            if (i < this.questionContents_.size()) {
                String input = (String)this.questionContents_.get(i);
                if (input != null && input.indexOf("<p>") >= 0 && input.indexOf("</p>") >= 0) {
                    input = input.replace("<p>", "");
                    input = input.substring(0, input.lastIndexOf("</p>") - 1);
                }
                textAreaInput.setValue((Object)input);
            }
            listFormWYSIWYGInput.addUIFormInput((UIFormInput)textAreaInput);
        }
        this.addChild((UIComponent)this.inputAuthor);
        this.addChild((UIComponent)this.inputEmailAddress);
        this.addChild((UIComponent)listFormWYSIWYGInput);
        if (this.questionId_ != null && this.questionId_.trim().length() > 0) {
            this.addChild((UIComponent)this.inputIsApproved.setChecked(this.isApproved_));
            this.addChild((UIComponent)this.inputIsActivated.setChecked(this.isActivated_));
        }
        this.addUIFormInput((UIFormInputSet)this.inputAttachcment);
        if (question_ != null && !isEdit) {
            this.setListFileAttach(question_.getAttachMent());
            try {
                this.refreshUploadFileList();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setIsChildOfManager(boolean isChild) {
        this.isChildOfManager = isChild;
        this.removeChildById(AUTHOR);
        this.removeChildById(EMAIL_ADDRESS);
        this.removeChildById(LIST_WYSIWYG_INPUT);
        this.removeChildById(ATTACHMENTS);
        this.removeChildById(IS_APPROVED);
        this.removeChildById(IS_ACTIVATED);
        this.listFileAttach_.clear();
        this.mapLanguageNode_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuestionId(Question question) {
        List questionLanguages = new ArrayList();
        this.questionId_ = question.getId();
        this.categoryId_ = null;
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            question_ = question;
            this.defaultLanguage_ = question_.getLanguage();
            this.LIST_LANGUAGE.clear();
            this.LIST_LANGUAGE.add(this.defaultLanguage_);
            questionLanguages = fAQService_.getQuestionLanguages(this.questionId_, sessionProvider);
            for (QuestionLanguage questionLanguage : questionLanguages) {
                this.mapLanguageNode_.put(questionLanguage.getLanguage(), questionLanguage);
                this.LIST_LANGUAGE.add(questionLanguage.getLanguage());
            }
            this.isApproved_ = question_.isApproved();
            this.isActivated_ = question_.isActivated();
            this.initPage(false);
            UIFormStringInput authorQ = (UIFormStringInput)this.getChildById(AUTHOR);
            authorQ.setValue((Object)question_.getAuthor());
            UIFormStringInput emailQ = (UIFormStringInput)this.getChildById(EMAIL_ADDRESS);
            emailQ.setValue((Object)question_.getEmail());
            ((UIFormTextAreaInput)listFormWYSIWYGInput.getChild(0)).setValue((Object)question_.getQuestion());
            int i = 1;
            for (QuestionLanguage questionLanguage : questionLanguages) {
                ((UIFormTextAreaInput)listFormWYSIWYGInput.getChild(i++)).setValue((Object)questionLanguage.getQuestion());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.initPage(false);
        }
        finally {
            sessionProvider.close();
        }
    }

    public String getQuestionId() {
        return this.questionId_;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage_ = defaultLanguage;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage_;
    }

    private String getAuthor() {
        return this.author_;
    }

    public void setAuthor(String author) {
        this.author_ = author;
    }

    private String getEmail() {
        return this.email_;
    }

    public void setEmail(String email) {
        this.email_ = email;
    }

    private String getCategoryId() {
        return this.categoryId_;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId_ = categoryId;
        this.questionId_ = null;
        LocaleConfigService configService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        Iterator i$ = configService.getLocalConfigs().iterator();
        while (i$.hasNext()) {
            LocaleConfig object;
            LocaleConfig localeConfig = object = (LocaleConfig)i$.next();
            Locale locale = localeConfig.getLocale();
            this.defaultLanguage_ = locale.getDefault().getDisplayLanguage();
        }
        if (!this.LIST_LANGUAGE.isEmpty()) {
            this.LIST_LANGUAGE.clear();
        }
        this.LIST_LANGUAGE.add(this.defaultLanguage_);
        this.initPage(false);
    }

    protected UIForm getParentForm() {
        UIForm form = (UIForm)this.getParent();
        return form;
    }

    public List<UIFormInputWithActions.ActionData> getActionList() {
        ArrayList<UIFormInputWithActions.ActionData> uploadedFiles = new ArrayList<UIFormInputWithActions.ActionData>();
        for (FileAttachment attachdata : this.listFileAttach_) {
            UIFormInputWithActions.ActionData uploadAction = new UIFormInputWithActions.ActionData();
            uploadAction.setActionListener("Download");
            uploadAction.setActionParameter(attachdata.getPath());
            uploadAction.setActionType(0);
            uploadAction.setCssIconClass("AttachmentIcon");
            uploadAction.setActionName(attachdata.getName() + " (" + attachdata.getSize() + " B)");
            uploadAction.setShowLabel(true);
            uploadedFiles.add(uploadAction);
            UIFormInputWithActions.ActionData removeAction = new UIFormInputWithActions.ActionData();
            removeAction.setActionListener("RemoveAttachment");
            removeAction.setActionName(REMOVE_FILE_ATTACH);
            removeAction.setActionParameter(attachdata.getPath());
            removeAction.setCssIconClass("LabelLink");
            removeAction.setActionType(1);
            uploadedFiles.add(removeAction);
        }
        return uploadedFiles;
    }

    public void setListFileAttach(List<FileAttachment> listFileAttachment) {
        this.listFileAttach_.addAll(listFileAttachment);
    }

    public void setListFileAttach(FileAttachment fileAttachment) {
        this.listFileAttach_.add(fileAttachment);
    }

    private List<FileAttachment> getListFile() {
        return this.listFileAttach_;
    }

    public void refreshUploadFileList() throws Exception {
        ((UIFormInputWithActions)this.getChildById(ATTACHMENTS)).setActionField(FILE_ATTACHMENTS, this.getActionList());
    }

    public void setActionField(String fieldName, List<UIFormInputWithActions.ActionData> actions) throws Exception {
        this.actionField_.put(fieldName, actions);
    }

    public List<UIFormInputWithActions.ActionData> getActionField(String fieldName) {
        return (List)this.actionField_.get(fieldName);
    }

    public String[] getListLanguage() {
        return this.LIST_LANGUAGE.toArray(new String[0]);
    }

    public void setListLanguage(List<String> listLanguage) {
        if (this.questionContents_.size() == 1) {
            this.LIST_LANGUAGE.clear();
            this.LIST_LANGUAGE.addAll(listLanguage);
        } else {
            int i = 0;
            while (i < this.questionContents_.size()) {
                if (!listLanguage.contains(this.LIST_LANGUAGE.get(i))) {
                    this.LIST_LANGUAGE.remove(i);
                    this.questionContents_.remove(i);
                    continue;
                }
                ++i;
            }
            for (String language : listLanguage) {
                if (this.LIST_LANGUAGE.contains(language)) continue;
                this.LIST_LANGUAGE.add(language);
            }
        }
    }

    static /* synthetic */ String access$000(UIQuestionForm x0) {
        return x0.questionId_;
    }

    static /* synthetic */ Question access$102(Question x0) {
        question_ = x0;
        return question_;
    }

    static /* synthetic */ String access$200(UIQuestionForm x0) {
        return x0.getCategoryId();
    }

    static /* synthetic */ Question access$100() {
        return question_;
    }

    static /* synthetic */ String access$300(UIQuestionForm x0) {
        return x0.categoryId_;
    }

    static /* synthetic */ FAQService access$400() {
        return fAQService_;
    }

    static /* synthetic */ List access$500(UIQuestionForm x0) {
        return x0.listFileAttach_;
    }

    static /* synthetic */ FAQSetting access$600(UIQuestionForm x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ List access$700(UIQuestionForm x0) {
        return x0.LIST_LANGUAGE;
    }

    static /* synthetic */ Map access$800(UIQuestionForm x0) {
        return x0.mapLanguageNode_;
    }

    static /* synthetic */ boolean access$900(UIQuestionForm x0) {
        return x0.isChildOfManager;
    }

    static /* synthetic */ String access$1002(UIQuestionForm x0, String x1) {
        x0.author_ = x1;
        return x0.author_;
    }

    static /* synthetic */ String access$1102(UIQuestionForm x0, String x1) {
        x0.email_ = x1;
        return x0.email_;
    }

    static /* synthetic */ boolean access$1202(UIQuestionForm x0, boolean x1) {
        x0.isApproved_ = x1;
        return x0.isApproved_;
    }

    static /* synthetic */ boolean access$1302(UIQuestionForm x0, boolean x1) {
        x0.isActivated_ = x1;
        return x0.isActivated_;
    }

    static /* synthetic */ List access$1400(UIQuestionForm x0) {
        return x0.questionContents_;
    }
}

