/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQServiceUtils;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.service.Watch;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UICategories;
import org.exoplatform.faq.webui.UIFAQContainer;
import org.exoplatform.faq.webui.UIFAQPageIterator;
import org.exoplatform.faq.webui.UIQuestions;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/faq/webui/UIQuestions.gtmpl", events={@EventConfig(listeners={DownloadAttachActionListener.class}), @EventConfig(listeners={DeleteCategoryActionListener.class}, confirm="UIQuestions.msg.confirm-delete-category"), @EventConfig(listeners={ChangeStatusAnswerActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={AddNewQuestionActionListener.class}), @EventConfig(listeners={SettingActionListener.class}), @EventConfig(listeners={WatchActionListener.class}), @EventConfig(listeners={RSSFAQActionListener.class}), @EventConfig(listeners={WatchManagerActionListener.class}), @EventConfig(listeners={UnWatchQuestionActionListener.class}), @EventConfig(listeners={QuestionManagamentActionListener.class}), @EventConfig(listeners={ViewQuestionActionListener.class}), @EventConfig(listeners={ViewUserProfileActionListener.class}), @EventConfig(listeners={ResponseQuestionActionListener.class}), @EventConfig(listeners={EditAnswerActionListener.class}), @EventConfig(listeners={EditQuestionActionListener.class}), @EventConfig(listeners={DeleteQuestionActionListener.class}), @EventConfig(listeners={MoveQuestionActionListener.class}), @EventConfig(listeners={SendQuestionActionListener.class}), @EventConfig(listeners={CommentQuestionActionListener.class}), @EventConfig(listeners={DeleteCommentActionListener.class}, confirm="UIQuestions.msg.confirm-delete-comment"), @EventConfig(listeners={DeleteAnswerActionListener.class}, confirm="UIQuestions.msg.confirm-delete-answer"), @EventConfig(listeners={UnVoteQuestionActionListener.class}, confirm="UIQuestions.msg.confirm-unvote-question"), @EventConfig(listeners={CommentToAnswerActionListener.class}), @EventConfig(listeners={VoteQuestionActionListener.class}), @EventConfig(listeners={ChangeQuestionActionListener.class}), @EventConfig(listeners={SortAnswerActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={RSSActionListener.class}), @EventConfig(listeners={EditCategoryActionListener.class}), @EventConfig(listeners={VoteAnswerActionListener.class}), @EventConfig(listeners={PrintAllQuestionActionListener.class}), @EventConfig(listeners={DiscussForumActionListener.class})})
public class UIQuestions
extends UIContainer {
    private static String SEARCH_INPUT = "SearchInput";
    private static String COMMENT_ITER = "CommentIter";
    private static String ANSWER_ITER = "AnswerIter";
    private static final String OBJECT_ITERATOR = "object_iter";
    private FAQSetting faqSetting_ = null;
    public List<Question> listQuestion_ = null;
    private List<String> listCateId_ = new ArrayList();
    private boolean canEditQuestion = false;
    private Boolean isSortAnswer = null;
    public String categoryId_ = null;
    private String parentId_ = null;
    public String questionView_ = "";
    public static String newPath_ = "";
    private String currentUser_ = "";
    private String link_ = "";
    private String pathParentNode = "";
    private static FAQService faqService_;
    private static boolean isChangeLg;
    public List<QuestionLanguage> listQuestionLanguage = new ArrayList();
    public boolean isChangeLanguage = false;
    public List<String> listLanguage = new ArrayList();
    public String backPath_ = null;
    public static String language_;
    private List<Watch> watchList_ = new ArrayList();
    private Topic topic = new Topic();
    private String[] firstTollbar_ = new String[]{"AddNewQuestion", "QuestionManagament"};
    private String[] menuCateManager = new String[]{"EditCategory", "AddCategory", "DeleteCategory", "Export", "Import"};
    private String[] firstActionCate_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditCategory", "DeleteCategory", "MoveCategory", "MoveDown", "MoveUp", "Watch"};
    private String[] secondActionCate_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditSubCategory", "DeleteCategory", "MoveCategory", "MoveDown", "MoveUp", "Watch"};
    private String[] userActionsCate_ = new String[]{"AddNewQuestion", "Watch"};
    private String[] moderatorActionQues_ = new String[]{"CommentQuestion", "ResponseQuestion", "EditQuestion", "DeleteQuestion", "MoveQuestion", "SendQuestion"};
    private String[] moderatorActionQues2_ = new String[]{"ResponseQuestion", "EditQuestion", "DeleteQuestion", "MoveQuestion", "SendQuestion"};
    private String[] userActionQues_ = new String[]{"CommentQuestion", "SendQuestion"};
    private String[] userActionQues2_ = new String[]{"SendQuestion"};
    private String[] sizes_ = new String[]{"bytes", "KB", "MB"};
    public boolean viewAuthorInfor = false;
    public JCRPageList pageList;
    private UIFAQPageIterator pageIterator = null;
    long pageSelect = 0L;

    public UIQuestions() throws Exception {
        this.currentUser_ = FAQUtils.getCurrentUser();
        this.addChild(UIFAQPageIterator.class, null, OBJECT_ITERATOR);
        faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    }

    public String getRSSLink() {
        String rssLink = "";
        rssLink = "/faq/iFAQRss/" + this.getPortalName() + "/" + this.categoryId_ + "/faq.rss";
        return rssLink;
    }

    private String getLinkDiscuss() {
        FAQSetting faqSetting = new FAQSetting();
        FAQUtils.getPorletPreference((FAQSetting)faqSetting);
        String link = this.getLink();
        String selectedNode = Util.getUIPortal().getSelectedNode().getUri();
        String portalName = "/" + Util.getUIPortal().getName();
        if (link.indexOf(portalName) > 0 && link.indexOf(selectedNode) < 0) {
            link = link.replaceFirst(portalName, selectedNode);
        }
        link = link.replaceAll("faq", "forum").replaceFirst("UIQuestions", "UIBreadcumbs").replaceFirst("Setting", "ChangePath").replaceAll("&amp;", "&");
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String url = portalContext.getRequest().getRequestURL().toString();
        url = url.replaceFirst("http://", "");
        url = url.substring(0, url.indexOf("/"));
        url = "http://" + url;
        this.topic = new Topic();
        link = link.replaceFirst("OBJECTID", this.topic.getId());
        link = url + link;
        return link;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private boolean isDiscussForum() throws Exception {
        FAQSetting faqSetting = new FAQSetting();
        FAQUtils.getPorletPreference((FAQSetting)faqSetting);
        return faqSetting.getIsDiscussForum();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListObject() {
        this.isChangeLanguage = false;
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            if (this.currentUser_ != null && this.currentUser_.trim().length() > 0) {
                FAQServiceUtils serviceUtils = new FAQServiceUtils();
                if (this.faqSetting_.getIsAdmin().equals("TRUE")) {
                    this.faqSetting_.setCanEdit(true);
                } else if (this.categoryId_ != null && this.categoryId_.trim().length() > 0 && Arrays.asList(faqService_.getCategoryById(this.categoryId_, sessionProvider).getModerators()).contains(this.currentUser_)) {
                    this.faqSetting_.setCanEdit(true);
                } else {
                    this.faqSetting_.setCanEdit(false);
                }
            }
            String object = null;
            if (this.pageList != null) {
                object = this.pageList.getObjectRepare_();
            }
            this.pageList = faqService_.getQuestionsByCatetory(this.categoryId_, sessionProvider, this.faqSetting_);
            this.pageList.setPageSize(10L);
            if (object != null && object.trim().length() > 0) {
                this.pageList.setObjectRepare_(object);
            }
            this.pageIterator = (UIFAQPageIterator)this.getChildById(OBJECT_ITERATOR);
            this.pageIterator.updatePageList(this.pageList);
        }
        catch (Exception e) {
            this.pageList = null;
            this.pageList.setPageSize(10L);
            this.pageIterator.updatePageList(this.pageList);
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Answer> getPageListAnswer(String questionId) throws Exception {
        List<Object> list = new ArrayList<Answer>();
        SessionProvider sProvider = FAQUtils.getSystemProvider();
        try {
            String IterId = ANSWER_ITER + questionId;
            if (this.pathParentNode.length() > 0) {
                questionId = questionId + "/" + this.pathParentNode;
            }
            JCRPageList pageListAnswre = faqService_.getPageListAnswer(sProvider, questionId, this.isSortAnswer);
            UIFAQPageIterator iterator = this.getChildById(IterId) == null ? (UIFAQPageIterator)this.addChild(UIFAQPageIterator.class, null, IterId) : (UIFAQPageIterator)this.getChildById(IterId);
            if (pageListAnswre != null) {
                pageListAnswre.setPageSize(6L);
                long page = iterator.getPageSelected();
                if (isChangeLg) {
                    page = 1L;
                }
                iterator.updatePageList(pageListAnswre);
                list = pageListAnswre.getPageItem(page);
                iterator.setSelectPage(pageListAnswre.getCurrentPage());
            } else {
                iterator.updatePageList(null);
                iterator.setSelectPage(1L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return list;
    }

    private List<Comment> getPageListComment(String questionId) throws Exception {
        List<Object> list = new ArrayList<Comment>();
        SessionProvider sProvider = FAQUtils.getSystemProvider();
        try {
            String IterId = COMMENT_ITER + questionId;
            if (this.pathParentNode.length() > 0) {
                questionId = questionId + "/" + this.pathParentNode;
            }
            JCRPageList pageListComment = faqService_.getPageListComment(sProvider, questionId);
            UIFAQPageIterator iterator = this.getChildById(IterId) == null ? (UIFAQPageIterator)this.addChild(UIFAQPageIterator.class, null, IterId) : (UIFAQPageIterator)this.getChildById(IterId);
            if (pageListComment != null) {
                pageListComment.setPageSize(6L);
                long page = iterator.getPageSelected();
                if (isChangeLg) {
                    page = 1L;
                }
                iterator.updatePageList(pageListComment);
                list = pageListComment.getPageItem(page);
                iterator.setSelectPage(pageListComment.getCurrentPage());
            } else {
                iterator.updatePageList(null);
                iterator.setSelectPage(1L);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        sProvider.close();
        isChangeLg = false;
        return list;
    }

    public String[] getActionTollbar() {
        return this.firstTollbar_;
    }

    public String[] getMenuCateManager() {
        return this.menuCateManager;
    }

    public FAQSetting getFAQSetting() {
        return this.faqSetting_;
    }

    private String[] getSecondActionCategory() {
        return this.secondActionCate_;
    }

    private String[] getActionCategoryWithUser() {
        if (this.currentUser_ != null) {
            return this.userActionsCate_;
        }
        if (this.faqSetting_.isEnableAutomaticRSS()) {
            return new String[]{this.userActionsCate_[0], "RSSFAQ"};
        }
        return new String[]{this.userActionsCate_[0]};
    }

    private String[] getActionQuestion() {
        if (this.canEditQuestion) {
            if (!this.faqSetting_.isEnanbleVotesAndComments()) {
                return this.moderatorActionQues2_;
            }
            return this.moderatorActionQues_;
        }
        if (!this.faqSetting_.isEnanbleVotesAndComments()) {
            return this.userActionQues2_;
        }
        if (this.currentUser_ == null || this.currentUser_.trim().length() < 1) {
            return this.userActionQues2_;
        }
        return this.userActionQues_;
    }

    private String getParentId() {
        return this.parentId_;
    }

    public void setQuestions() throws Exception {
        this.pageSelect = this.pageIterator.getPageSelected();
        this.listQuestion_ = new ArrayList();
        this.listQuestion_.addAll(this.pageList.getPage(this.pageSelect, null));
        this.pageSelect = this.pageList.getCurrentPage();
        this.pageIterator.setSelectPage(this.pageSelect);
        this.setIsModerators();
    }

    public void setFAQSetting(FAQSetting setting) {
        this.faqSetting_ = setting;
        this.setListObject();
    }

    public void setFAQService(FAQService service) {
        faqService_ = service;
    }

    private String[] getActionCategory() {
        return this.firstActionCate_;
    }

    private String[] getActionQuestionWithUser() {
        if (!this.faqSetting_.isEnanbleVotesAndComments() || this.currentUser_ == null || this.currentUser_.trim().length() < 1) {
            return this.userActionQues2_;
        }
        return this.userActionQues_;
    }

    public void setParentId(String parentId_) {
        this.parentId_ = parentId_;
    }

    public void setLanguageView(String language) {
        language_ = language;
    }

    public void setCategories(String categoryId) throws Exception {
        this.setCategoryId(categoryId);
    }

    private void setIsModerators() {
        UIFAQContainer container = (UIFAQContainer)this.getAncestorOfType(UIFAQContainer.class);
        this.canEditQuestion = ((UICategories)container.findFirstComponentOfType(UICategories.class)).getCanEditQuestions();
    }

    private boolean canVote(Question question) {
        if (question.getUsersVote() != null) {
            for (String user : question.getUsersVote()) {
                if (!user.contains(this.currentUser_ + "/")) continue;
                return false;
            }
        }
        return true;
    }

    private boolean canVoteAnswer(String[] usersVoted) {
        if (usersVoted != null) {
            for (String user : usersVoted) {
                if (!user.equals(this.currentUser_)) continue;
                return false;
            }
        }
        return true;
    }

    private String[] getActionWithCategory() {
        return null;
    }

    private void getQuestions() throws Exception {
        if (this.isChangeLanguage && this.pageSelect != this.pageIterator.getPageSelected()) {
            this.isChangeLanguage = false;
        }
        if (!this.isChangeLanguage) {
            this.setQuestions();
        }
    }

    public void setIsNotChangeLanguage() {
        this.isChangeLanguage = false;
    }

    public void setListQuestion(List<Question> listQuestion) {
        this.listQuestion_ = listQuestion;
    }

    private String convertSize(long size) {
        String result = "";
        long residual = 0L;
        int i = 0;
        while (size >= 1000L) {
            ++i;
            residual = size % 1024L;
            size /= 1024L;
        }
        if (residual > 500L) {
            String str = residual + "";
            result = size + 1L + " " + this.sizes_[i];
        } else {
            result = size + " " + this.sizes_[i];
        }
        return result;
    }

    public List<Question> getListQuestion() {
        return this.listQuestion_;
    }

    private boolean getCanEditQuestion() {
        return this.canEditQuestion;
    }

    private String getQuestionView() {
        return this.questionView_;
    }

    private List<String> getQuestionLangauges(Question question) {
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            if (!this.isChangeLanguage) {
                this.listLanguage.clear();
                this.listQuestionLanguage.clear();
                QuestionLanguage quesLanguage = new QuestionLanguage();
                quesLanguage.setId(question.getId());
                quesLanguage.setLanguage(question.getLanguage());
                quesLanguage.setQuestion(question.getQuestion());
                quesLanguage.setDetail(question.getDetail());
                this.listQuestionLanguage.add(quesLanguage);
                this.listQuestionLanguage.addAll(faqService_.getQuestionLanguages(question.getId(), sessionProvider));
                for (QuestionLanguage questionLanguage : this.listQuestionLanguage) {
                    this.listLanguage.add(questionLanguage.getLanguage());
                    if (language_ == null || language_.trim().length() <= 0 || !language_.equals(questionLanguage.getLanguage())) continue;
                    question.setLanguage(questionLanguage.getLanguage());
                    question.setQuestion(questionLanguage.getQuestion());
                    question.setDetail(questionLanguage.getDetail());
                }
            }
            sessionProvider.close();
            return this.listLanguage;
        }
        catch (Exception e) {
            e.printStackTrace();
            sessionProvider.close();
            return null;
        }
    }

    private String getFileSource(InputStream input, String fileName, DownloadService dservice) throws Exception {
        byte[] imageBytes = null;
        if (input != null) {
            imageBytes = new byte[input.available()];
            input.read(imageBytes);
            ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
            InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
            dresource.setDownloadName(fileName);
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        return null;
    }

    private String getFileSource(FileAttachment attachment) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        try {
            InputStream input = attachment.getInputStream();
            String fileName = attachment.getName();
            return this.getFileSource(input, fileName, dservice);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getAvatarUrl(String userId, SessionProvider sessionProvider) {
        String url = "";
        try {
            url = FAQUtils.getFileSource((FileAttachment)faqService_.getUserAvatar(userId, sessionProvider), (DownloadService)((DownloadService)this.getApplicationComponent(DownloadService.class)));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url != null && url.trim().length() > 0) {
            return url;
        }
        return "/faq/skin/DefaultSkin/webui/background/Avatar1.gif";
    }

    public void setQuestionView(String questionId) {
        this.questionView_ = questionId;
    }

    public String getCategoryId() {
        return this.categoryId_;
    }

    public void setCategoryId(String categoryId) throws Exception {
        this.categoryId_ = categoryId;
        this.setListObject();
        this.setIsNotChangeLanguage();
    }

    public String getQuestionRelationById(String questionId) {
        Question question = new Question();
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            question = faqService_.getQuestionById(questionId, sessionProvider);
            if (question != null) {
                sessionProvider.close();
                return question.getCategoryId() + "/" + question.getId() + "/" + question.getQuestion();
            }
            sessionProvider.close();
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            sessionProvider.close();
            return "";
        }
    }

    public List<Watch> getListWatch(String categoryId) throws Exception {
        FAQService faqService = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        this.watchList_ = faqService.getListMailInWatch(categoryId, sessionProvider).getAllWatch();
        sessionProvider.close();
        return this.watchList_;
    }

    public void setListWatch(List<Watch> list) {
        this.watchList_ = list;
    }

    public String cutCaret(String name) {
        StringBuffer string = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '/') continue;
            string.append(c);
        }
        return string.toString();
    }

    public String getLink() {
        return this.link_;
    }

    private String getBackPath() {
        return this.backPath_;
    }

    public void setPath(String s) {
        newPath_ = s;
    }

    public String getPathService(String categoryId) throws Exception {
        String oldPath = "";
        String path = "FAQService";
        if (categoryId != null && !categoryId.equals("null")) {
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            List listPath = faqService_.getCategoryPath(sessionProvider, categoryId);
            sessionProvider.close();
            for (int i = listPath.size() - 1; i >= 0; --i) {
                oldPath = oldPath + "/" + (String)listPath.get(i);
            }
            path = path + oldPath;
            oldPath = path.substring(0, path.lastIndexOf("/"));
        } else {
            oldPath = path;
        }
        return oldPath;
    }

    public void setLink(String link) {
        this.link_ = link;
    }

    private List<Category> getSubCategories(String cateId) {
        SessionProvider sProvider = FAQUtils.getSystemProvider();
        ArrayList<Category> listCategories = new ArrayList();
        try {
            listCategories = faqService_.getSubCategories(cateId, sProvider, this.faqSetting_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sProvider.close();
        return listCategories;
    }

    private List<Question> getListSubQuestion(String cateId) {
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        List<Object> listQuestions = new ArrayList<Question>();
        try {
            listQuestions = faqService_.getQuestionsByCatetory(cateId, sessionProvider, this.faqSetting_).getAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sessionProvider.close();
        return listQuestions;
    }

    private List<Category> getAllSubCategory(String categoryId) throws Exception {
        ArrayList<Category> listResult = new ArrayList<Category>();
        Stack<Category> stackCate = new Stack<Category>();
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        Category cate = faqService_.getCategoryById(categoryId, sessionProvider);
        if (categoryId == null || categoryId.equals("null")) {
            cate.setId(null);
        }
        listResult.add(cate);
        for (Category category : faqService_.getSubCategories(categoryId, sessionProvider, this.faqSetting_)) {
            stackCate.push(category);
        }
        while (!stackCate.isEmpty()) {
            cate = (Category)stackCate.pop();
            listResult.add(cate);
            for (Category category : faqService_.getSubCategories(cate.getId(), sessionProvider, this.faqSetting_)) {
                stackCate.push(category);
            }
        }
        sessionProvider.close();
        return listResult;
    }

    public Boolean checkUserWatch(String categoryId) throws Exception {
        List listWatch;
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        if (!FAQUtils.isFieldEmpty((String)FAQUtils.getCurrentUser()) && (listWatch = faqService_.getListMailInWatch(categoryId, sessionProvider).getAllWatch()).size() > 0) {
            ArrayList<String> users = new ArrayList<String>();
            for (Watch watch : listWatch) {
                users.add(watch.getUser());
            }
            if (users.contains(FAQUtils.getCurrentUser())) {
                return true;
            }
        }
        sessionProvider.close();
        return false;
    }

    public Boolean checkUserWatchQuestion(String questionId) throws Exception {
        if (!FAQUtils.isFieldEmpty((String)FAQUtils.getCurrentUser())) {
            SessionProvider sessionProvider = FAQUtils.getSystemProvider();
            ArrayList listWatch = null;
            try {
                listWatch = faqService_.getListMailInWatchQuestion(questionId, sessionProvider).getAllWatch();
            }
            catch (Exception e) {
                listWatch = new ArrayList();
            }
            if (listWatch.size() > 0) {
                ArrayList<String> users = new ArrayList<String>();
                for (Watch watch : listWatch) {
                    users.add(watch.getUser());
                }
                if (users.contains(FAQUtils.getCurrentUser())) {
                    return true;
                }
            }
            sessionProvider.close();
        }
        return false;
    }

    private boolean checkQuestionToView(Question question, UIApplication uiApplication, Event<UIQuestions> event, SessionProvider sessionProvider) {
        if (!question.isActivated() || !question.isApproved() && this.faqSetting_.getDisplayMode().equals(FAQUtils.DISPLAYAPPROVED)) {
            uiApplication.addMessage(new ApplicationMessage("UIQuestions.msg.question-pending", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApplication.getUIPopupMessages());
            event.getRequestContext().addUIComponentToUpdateByAjax(this.getAncestorOfType(UIFAQContainer.class));
            sessionProvider.close();
            return true;
        }
        return false;
    }

    static /* synthetic */ FAQService access$000() {
        return faqService_;
    }

    static /* synthetic */ FAQSetting access$100(UIQuestions x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ boolean access$200(UIQuestions x0) {
        return x0.canEditQuestion;
    }

    static /* synthetic */ Boolean access$300(UIQuestions x0) {
        return x0.isSortAnswer;
    }

    static /* synthetic */ Boolean access$302(UIQuestions x0, Boolean x1) {
        x0.isSortAnswer = x1;
        return x0.isSortAnswer;
    }

    static /* synthetic */ boolean access$400(UIQuestions x0, Question x1, UIApplication x2, Event x3, SessionProvider x4) {
        return x0.checkQuestionToView(x1, x2, x3, x4);
    }

    static /* synthetic */ List access$500(UIQuestions x0) {
        return x0.listCateId_;
    }

    static /* synthetic */ String access$602(UIQuestions x0, String x1) {
        x0.pathParentNode = x1;
        return x0.pathParentNode;
    }

    static /* synthetic */ boolean access$702(boolean x0) {
        isChangeLg = x0;
        return isChangeLg;
    }

    static /* synthetic */ Topic access$800(UIQuestions x0) {
        return x0.topic;
    }

    static /* synthetic */ String access$900(UIQuestions x0) {
        return x0.getLinkDiscuss();
    }

    static /* synthetic */ String access$1000(UIQuestions x0) {
        return x0.currentUser_;
    }

    static /* synthetic */ List access$1100(UIQuestions x0, String x1) throws Exception {
        return x0.getAllSubCategory(x1);
    }

    static {
        isChangeLg = false;
        language_ = "";
    }
}

