/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UISendMailForm;
import org.exoplatform.ks.common.EmailNotifyPlugin;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UISendMailForm.gtmpl", events={@EventConfig(listeners={SendActionListener.class}), @EventConfig(listeners={ToActionListener.class}), @EventConfig(listeners={CcActionListener.class}), @EventConfig(listeners={BccActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={ChangeLanguageActionListener.class})})
public class UISendMailForm
extends UIForm
implements UIPopupComponent {
    private static final String FILED_FROM_NAME = "FromName";
    private static final String FILED_FROM = "From";
    private static final String FILED_TO = "To";
    private static final String FILED_ADD_CC = "AddCc";
    private static final String FILED_ADD_BCC = "AddBcc";
    private static final String FILED_SUBJECT = "Subject";
    private static final String FILED_QUESTION_LANGUAGE = "Language";
    private static final String FILED_MESSAGE = "Message";
    public static final String FIELD_FROM_INPUT = "fromInput";
    private static final String MIMETYPE_TEXTHTML = "text/html".intern();
    private static Map<String, String> serverConfig_ = new HashMap();
    private List<SelectItemOption<String>> listLanguageToReponse = new ArrayList();
    private List<QuestionLanguage> listQuestionLanguage = new ArrayList();
    private String languageIsResponsed = "";
    private static FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    private String questionChanged_ = new String();
    private String link_ = "";
    public List<User> toUsers = new ArrayList();
    public List<User> addCCUsers = new ArrayList();
    public List<User> addBCCUsers = new ArrayList();
    private int posOfResponse = 0;

    public UISendMailForm() throws Exception {
        this.setActions(new String[]{"Send", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getLink() {
        return this.link_;
    }

    public void setLink(String link) {
        this.link_ = link;
    }

    public List<User> getToUsers() {
        return this.toUsers;
    }

    public void setToUsers(List<User> userList) {
        this.toUsers = userList;
    }

    public List<User> getAddCCUsers() {
        return this.addCCUsers;
    }

    public void setAddCCUsers(List<User> userList) {
        this.addCCUsers = userList;
    }

    public List<User> getAddBCCUsers() {
        return this.addBCCUsers;
    }

    public void setAddBCCUsers(List<User> userList) {
        this.addBCCUsers = userList;
    }

    private List<SelectItemOption<String>> getListLanguageToSendFriend() {
        return this.listLanguageToReponse;
    }

    public void addPlugin(ComponentPlugin plugin) throws Exception {
        try {
            serverConfig_ = ((EmailNotifyPlugin)plugin).getServerConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUpdateQuestion(String questionId, String language) throws Exception {
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        Question question = FAQUtils.getFAQService().getQuestionById(questionId, sessionProvider);
        if (language.equals("")) {
            language = question.getLanguage();
        }
        String email = "";
        String name = "";
        String userName = FAQUtils.getCurrentUser();
        if (!FAQUtils.isFieldEmpty((String)userName)) {
            name = FAQUtils.getFullName((String)userName);
            email = FAQUtils.getEmailUser((String)userName);
        }
        this.languageIsResponsed = question.getLanguage();
        QuestionLanguage questionLanguage = new QuestionLanguage();
        questionLanguage.setId(question.getId());
        questionLanguage.setQuestion(question.getQuestion());
        questionLanguage.setDetail(question.getDetail());
        questionLanguage.setLanguage(question.getLanguage());
        questionLanguage.setAnswers(question.getAnswers());
        questionLanguage.setComments(question.getComments());
        this.listQuestionLanguage.add(questionLanguage);
        for (QuestionLanguage questionLanguage2 : faqService_.getQuestionLanguages(questionId, sessionProvider)) {
            String quest2 = questionLanguage2.getDetail().replaceAll("\n", "<br>").replaceAll("'", "&#39;");
            questionLanguage2.setDetail(quest2);
            this.listQuestionLanguage.add(questionLanguage2);
        }
        this.questionChanged_ = question.getQuestion();
        for (QuestionLanguage quesLanguage : this.listQuestionLanguage) {
            this.listLanguageToReponse.add(new SelectItemOption(quesLanguage.getLanguage(), (Object)quesLanguage.getLanguage()));
        }
        sessionProvider.close();
        this.addChild((UIComponent)new UIFormStringInput(FILED_FROM_NAME, FILED_FROM_NAME, name));
        this.addChild((UIComponent)new UIFormStringInput(FILED_FROM, FILED_FROM, email));
        this.addChild((UIComponent)new UIFormStringInput(FILED_TO, FILED_TO, null));
        this.addChild((UIComponent)new UIFormStringInput(FILED_ADD_CC, FILED_ADD_CC, null));
        this.addChild((UIComponent)new UIFormStringInput(FILED_ADD_BCC, FILED_ADD_BCC, null));
        UIFormSelectBox questionLanguages = new UIFormSelectBox(FILED_QUESTION_LANGUAGE, FILED_QUESTION_LANGUAGE, this.getListLanguageToSendFriend());
        questionLanguages.setSelectedValues(new String[]{language});
        questionLanguages.setOnChange("ChangeLanguage");
        this.addChild((UIComponent)questionLanguages);
        String content = "";
        String contenQuestion = "";
        for (QuestionLanguage questionLangua : this.listQuestionLanguage) {
            if (!questionLangua.getLanguage().equals(language)) continue;
            contenQuestion = questionLangua.getQuestion();
            Answer[] answers = questionLangua.getAnswers();
            if (answers == null || answers.length < 1) {
                content = this.getLabel("change-content1") + this.getLabel("change-content2") + "<p><b>" + this.getLabel("Question") + "</b> " + contenQuestion + "</p>";
                if (questionLangua.getDetail() != null && questionLangua.getDetail().trim().length() > 0) {
                    content = content + "<p><b>" + this.getLabel("Detail") + "</b> " + questionLangua.getDetail() + "</p>";
                }
                content = content + "<p>" + this.getLabel("Link1") + "<a href =" + this.link_ + ">" + this.getLabel("Link2") + "</a>" + this.getLabel("Link3") + "</p>";
                break;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getLabel("change-content1")).append(this.getLabel("change-content2")).append("<p><b>").append(this.getLabel("Question")).append("</b> " + contenQuestion + "</p>");
            if (questionLangua.getDetail() != null && questionLangua.getDetail().trim().length() > 0) {
                stringBuffer.append("<p><b>").append(this.getLabel("Detail")).append("</b> " + questionLangua.getDetail() + "</p>");
            }
            stringBuffer.append("<p><b>" + this.getLabel("Response") + "</b> ");
            for (Answer answer : answers) {
                stringBuffer.append(answer.getResponses() + "</p>");
            }
            stringBuffer.append("<p>" + this.getLabel("Link1") + "<a href =" + this.link_ + ">" + this.getLabel("Link2") + "</a>" + this.getLabel("Link3") + "</p>");
            content = stringBuffer.toString();
            break;
        }
        this.addChild((UIComponent)new UIFormStringInput(FILED_SUBJECT, FILED_SUBJECT, this.getLabel("change-title") + " " + contenQuestion.replaceAll("<br>", " ")));
        this.addChild((UIComponent)new UIFormWYSIWYGInput(FILED_MESSAGE, FILED_MESSAGE, content));
    }

    public void setFieldToValue(String value) {
        this.getUIStringInput(FILED_TO).setValue((Object)value);
    }

    public String getFieldToValue() {
        return (String)this.getUIStringInput(FILED_TO).getValue();
    }

    public void setFieldCCValue(String value) {
        this.getUIStringInput(FILED_ADD_CC).setValue((Object)value);
    }

    public String getFieldCCValue() {
        return (String)this.getUIStringInput(FILED_ADD_CC).getValue();
    }

    public void setFieldBCCValue(String value) {
        this.getUIStringInput(FILED_ADD_BCC).setValue((Object)value);
    }

    public String getFieldBCCValue() {
        return (String)this.getUIStringInput(FILED_ADD_BCC).getValue();
    }

    static /* synthetic */ Map access$000() {
        return serverConfig_;
    }

    static /* synthetic */ String access$100() {
        return MIMETYPE_TEXTHTML;
    }

    static /* synthetic */ FAQService access$200() {
        return faqService_;
    }

    static /* synthetic */ List access$300(UISendMailForm x0) {
        return x0.listQuestionLanguage;
    }

    static /* synthetic */ String access$402(UISendMailForm x0, String x1) {
        x0.languageIsResponsed = x1;
        return x0.languageIsResponsed;
    }

    static /* synthetic */ int access$500(UISendMailForm x0) {
        return x0.posOfResponse;
    }
}

