/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Watch;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIFAQPageIterator;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UIWatchManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIWatchManager.gtmpl", events={@EventConfig(listeners={LinkActionListener.class}), @EventConfig(listeners={EditEmailActionListener.class}), @EventConfig(listeners={DeleteEmailActionListener.class}, confirm="UIWatchManager.msg.confirm-delete-watch"), @EventConfig(listeners={DeleteWatchQuesitonActionListener.class}, confirm="UIWatchManager.msg.confirm-delete-watch"), @EventConfig(listeners={CancelActionListener.class})})
public class UIWatchManager
extends UIForm
implements UIPopupComponent {
    private static String categoryId_ = "";
    private List<Watch> listWatchs_ = new ArrayList();
    private String LIST_EMAILS_WATCH = "listEmailsWatch";
    private UIFAQPageIterator pageIterator;
    private JCRPageList pageList;
    private Boolean check_ = false;
    public long curentPage_ = 1L;
    private String questionID_ = null;
    private static FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);

    public UIWatchManager() throws Exception {
        this.addChild(UIFAQPageIterator.class, null, this.LIST_EMAILS_WATCH);
        this.setActions(new String[]{"Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getCategoryID() {
        return categoryId_;
    }

    public void setCategoryID(String s) throws Exception {
        categoryId_ = s;
        this.listWatchs_ = new ArrayList();
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            this.pageList = faqService_.getListMailInWatch(categoryId_, sessionProvider);
            this.pageList.setPageSize(5L);
            this.pageIterator = (UIFAQPageIterator)this.getChildById(this.LIST_EMAILS_WATCH);
            this.pageIterator.updatePageList(this.pageList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sessionProvider.close();
    }

    public void setQuestionID(String questionId) {
        this.questionID_ = questionId;
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            this.pageList = faqService_.getListMailInWatchQuestion(this.questionID_, sessionProvider);
            this.pageList.setPageSize(5L);
            this.pageIterator = (UIFAQPageIterator)this.getChildById(this.LIST_EMAILS_WATCH);
            this.pageIterator.updatePageList(this.pageList);
        }
        catch (Exception e) {
            this.listWatchs_ = new ArrayList();
        }
        sessionProvider.close();
    }

    public void setCurentPage(long page) {
        this.curentPage_ = page;
    }

    public List<String> getListMails(List<Watch> listWatchs) {
        ArrayList<String> listEmails = new ArrayList<String>();
        for (Watch watch : listWatchs) {
            listEmails.add(watch.getEmails());
        }
        return listEmails;
    }

    private long getTotalpages(String pageInteratorId) {
        UIFAQPageIterator pageIterator = (UIFAQPageIterator)this.getChildById(this.LIST_EMAILS_WATCH);
        try {
            return (Long)pageIterator.getInfoPage().get(3);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1L;
        }
    }

    public List<Watch> getListWatch() throws Exception {
        long pageSelected;
        if (!this.check_.booleanValue()) {
            if (this.curentPage_ > 1L) {
                pageSelected = this.curentPage_;
                this.curentPage_ = 0L;
            } else {
                pageSelected = this.pageIterator.getPageSelected();
            }
        } else {
            pageSelected = this.pageIterator.getPageSelected();
        }
        this.listWatchs_ = new ArrayList();
        try {
            this.listWatchs_.addAll(this.pageList.getPageListWatch(pageSelected, FAQUtils.getCurrentUser()));
            if (this.listWatchs_.isEmpty()) {
                UIFAQPageIterator pageIterator = null;
                while (this.listWatchs_.isEmpty() && pageSelected > 1L) {
                    pageIterator = (UIFAQPageIterator)this.getChildById(this.LIST_EMAILS_WATCH);
                    this.listWatchs_.addAll(this.pageList.getPageListWatch(pageSelected, FAQUtils.getCurrentUser()));
                    pageIterator.setSelectPage(--pageSelected);
                }
            } else {
                this.pageIterator.setSelectPage(pageSelected);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.check_ = false;
        return this.listWatchs_;
    }

    public static String getSubString(String str, int max) {
        int l;
        if (!FAQUtils.isFieldEmpty((String)str) && (l = str.length()) > max) {
            int comma = (str = str.substring(0, max - 3)).lastIndexOf(",");
            str = comma > 0 ? str.substring(0, comma) + "..." : str + "...";
        }
        return str;
    }

    static /* synthetic */ String access$000() {
        return categoryId_;
    }

    static /* synthetic */ FAQService access$100() {
        return faqService_;
    }

    static /* synthetic */ UIFAQPageIterator access$200(UIWatchManager x0) {
        return x0.pageIterator;
    }

    static /* synthetic */ Boolean access$302(UIWatchManager x0, Boolean x1) {
        x0.check_ = x1;
        return x0.check_;
    }

    static /* synthetic */ String access$400(UIWatchManager x0) {
        return x0.questionID_;
    }
}

