/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIBreadcumbs;
import org.exoplatform.faq.webui.UICategories;
import org.exoplatform.faq.webui.UIQuestions;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;

@ComponentConfig(template="app:/templates/faq/webui/UIFAQContainer.gtmpl")
public class UIFAQContainer
extends UIContainer {
    private FAQSetting faqSetting_ = null;
    private String currentUser_;

    public UIFAQContainer() throws Exception {
        FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        this.currentUser_ = FAQUtils.getCurrentUser();
        this.faqSetting_ = new FAQSetting();
        FAQUtils.getPorletPreference((FAQSetting)this.faqSetting_);
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        if (this.currentUser_ != null && this.currentUser_.trim().length() > 0) {
            if (this.faqSetting_.getIsAdmin() == null || this.faqSetting_.getIsAdmin().trim().length() < 1) {
                if (faqService_.isAdminRole(this.currentUser_, sessionProvider)) {
                    this.faqSetting_.setIsAdmin("TRUE");
                } else {
                    this.faqSetting_.setIsAdmin("FALSE");
                }
            }
            faqService_.getUserSetting(sessionProvider, this.currentUser_, this.faqSetting_);
        } else {
            this.faqSetting_.setIsAdmin("FALSE");
        }
        ((UIBreadcumbs)this.addChild(UIBreadcumbs.class, null, null)).setRendered(true);
        UIQuestions uiQuestions = (UIQuestions)((UIQuestions)this.addChild(UIQuestions.class, null, null)).setRendered(true);
        uiQuestions.setFAQService(faqService_);
        uiQuestions.setFAQSetting(this.faqSetting_);
        try {
            uiQuestions.viewAuthorInfor = faqService_.getCategoryById(null, sessionProvider).isViewAuthorInfor();
        }
        catch (Exception e) {
            e.printStackTrace();
            uiQuestions.viewAuthorInfor = false;
        }
        UICategories uiCategories = (UICategories)((UICategories)this.addChild(UICategories.class, null, null)).setRendered(true);
        uiCategories.setFAQSetting(this.faqSetting_);
        uiCategories.setFAQService(faqService_);
        sessionProvider.close();
    }

    public FAQSetting getFAQSetting() {
        return this.faqSetting_;
    }

    public void updateIsRender(boolean isRender) throws Exception {
        ((UICategories)this.getChild(UICategories.class)).setRendered(isRender);
        ((UIBreadcumbs)this.getChild(UIBreadcumbs.class)).setRendered(isRender);
        ((UIQuestions)this.getChild(UIQuestions.class)).setRendered(isRender);
    }
}

