/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UIPrintAllQuestions;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIPrintAllQuestions.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIPrintAllQuestions
extends UIForm
implements UIPopupComponent {
    private String[] sizes_ = new String[]{"bytes", "KB", "MB"};
    private String categoryId = null;
    private String currentUser_;
    private boolean canEditQuestion = false;
    private FAQService faqService_ = null;
    private FAQSetting faqSetting_ = null;
    private boolean viewAuthorInfor = true;

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public UIPrintAllQuestions() {
        try {
            this.currentUser_ = FAQUtils.getCurrentUser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getQuestionRelationById(String questionId) {
        Question question = new Question();
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        try {
            question = this.faqService_.getQuestionById(questionId, sessionProvider);
            if (question != null) {
                sessionProvider.close();
                return question.getCategoryId() + "/" + question.getId() + "/" + question.getQuestion();
            }
            sessionProvider.close();
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            sessionProvider.close();
            return "";
        }
    }

    private String getFileSource(InputStream input, String fileName, DownloadService dservice) throws Exception {
        byte[] imageBytes = null;
        if (input != null) {
            imageBytes = new byte[input.available()];
            input.read(imageBytes);
            ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
            InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
            dresource.setDownloadName(fileName);
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        return null;
    }

    private String getFileSource(FileAttachment attachment) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        try {
            InputStream input = attachment.getInputStream();
            String fileName = attachment.getName();
            return this.getFileSource(input, fileName, dservice);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private String getAvatarUrl(String userId, SessionProvider sessionProvider) {
        String url = "";
        try {
            url = FAQUtils.getFileSource((FileAttachment)this.faqService_.getUserAvatar(userId, sessionProvider), (DownloadService)((DownloadService)this.getApplicationComponent(DownloadService.class)));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url != null && url.trim().length() > 0) {
            return url;
        }
        return "/faq/skin/DefaultSkin/webui/background/Avatar1.gif";
    }

    private String convertSize(long size) {
        String result = "";
        long residual = 0L;
        int i = 0;
        while (size >= 1000L) {
            ++i;
            residual = size % 1024L;
            size /= 1024L;
        }
        if (residual > 500L) {
            String str = residual + "";
            result = size + 1L + " " + this.sizes_[i];
        } else {
            result = size + " " + this.sizes_[i];
        }
        return result;
    }

    public void setCategoryId(String cateId, FAQService service, FAQSetting setting, boolean canEdit) {
        this.categoryId = cateId;
        this.faqService_ = service;
        this.faqSetting_ = setting;
        this.canEditQuestion = this.faqSetting_.isAdmin();
        if (!this.canEditQuestion) {
            this.canEditQuestion = canEdit;
        }
    }

    public List<Question> getListQuestion(SessionProvider sProvider) {
        try {
            return this.faqService_.getQuestionsByCatetory(this.categoryId, sProvider, this.faqSetting_).getAll();
        }
        catch (Exception e) {
            return new ArrayList<Question>();
        }
    }

    public List<Answer> getListAnswers(String questionId, SessionProvider sProvider) {
        try {
            return this.faqService_.getPageListAnswer(sProvider, questionId, Boolean.valueOf(false)).getPageItem(0L);
        }
        catch (Exception e) {
            return new ArrayList<Answer>();
        }
    }

    public List<Comment> getListComments(String questionId, SessionProvider provider) {
        try {
            return this.faqService_.getPageListComment(provider, questionId).getPageItem(0L);
        }
        catch (Exception e) {
            return new ArrayList<Comment>();
        }
    }
}

