/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQServiceUtils;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIFAQPageIterator;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UIQuestionsInfo;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIQuestionsInfo.gtmpl", events={@EventConfig(listeners={ChangeCategoryActionListener.class}), @EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={EditQuestionActionListener.class}), @EventConfig(listeners={DeleteQuestionActionListener.class}), @EventConfig(listeners={ChangeTabActionListener.class}), @EventConfig(listeners={ChangeQuestionStatusActionListener.class}), @EventConfig(listeners={ResponseQuestionActionListener.class})})
public class UIQuestionsInfo
extends UIForm
implements UIPopupComponent {
    private static final String LIST_QUESTION_INTERATOR = "FAQUserPageIteratorTab1";
    private static final String LIST_QUESTION_NOT_ANSWERED_INTERATOR = "FAQUserPageIteratorTab2";
    private static final String LIST_CATEGORIES = "ListCategories";
    private FAQSetting faqSetting_ = new FAQSetting();
    private static FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    private JCRPageList pageList;
    private JCRPageList pageListNotAnswer;
    private UIFAQPageIterator pageIterator;
    private UIFAQPageIterator pageQuesNotAnswerIterator;
    private List<Question> listQuestion_ = new ArrayList();
    private List<Question> listQuestionNotYetAnswered_ = new ArrayList();
    private List<SelectItemOption<String>> listCategories = new ArrayList();
    private long pageSelect = 1L;
    private long pageSelectNotAnswer = 1L;
    private boolean isEditTab_ = true;
    private boolean isResponseTab_ = false;
    private boolean isChangeTab_ = false;
    private String cateId_ = "All";

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public UIQuestionsInfo() throws Exception {
        this.addChild(UIFAQPageIterator.class, null, LIST_QUESTION_INTERATOR);
        this.addChild(UIFAQPageIterator.class, null, LIST_QUESTION_NOT_ANSWERED_INTERATOR);
        this.setActions(new String[]{""});
    }

    public void setFAQSetting(FAQSetting setting) throws Exception {
        this.faqSetting_ = setting;
        FAQUtils.getEmailSetting((FAQSetting)this.faqSetting_, (boolean)false, (boolean)false);
        this.setListQuestion();
        this.setListCate();
        UIFormSelectBox selectCategory = new UIFormSelectBox(LIST_CATEGORIES, LIST_CATEGORIES, this.listCategories);
        selectCategory.setOnChange("ChangeCategory");
        this.addUIFormInput((UIFormInput)selectCategory);
    }

    private boolean hasInGroup(List<String> listGroup, String[] listPermission) {
        for (String per : listPermission) {
            if (per == null || per.trim().length() <= 0 || !listGroup.contains(per)) continue;
            return true;
        }
        return false;
    }

    private void setListCate() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        this.listCategories.add(new SelectItemOption(res.getString("UIQuestionsInfo.label.All"), (Object)"All"));
        FAQService faqService = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        SessionProvider sessionProvider = FAQUtils.getSystemProvider();
        ArrayList<Cate> listCate = new ArrayList<Cate>();
        Cate parentCate = new Cate(this);
        Cate childCate = new Cate(this);
        for (Category category : faqService.getSubCategories(null, sessionProvider, this.faqSetting_)) {
            if (category == null) continue;
            Cate cate = new Cate(this);
            cate.setCategory(category);
            cate.setDeft(0);
            listCate.add(cate);
        }
        String dept = "";
        boolean isAdmin = this.faqSetting_.isAdmin();
        List listGroup = FAQServiceUtils.getAllGroupAndMembershipOfUser((String)FAQUtils.getCurrentUser());
        while (!listCate.isEmpty()) {
            int i;
            parentCate = new Cate(this);
            parentCate = (Cate)listCate.get(0);
            listCate.remove(0);
            for (i = 0; i < parentCate.getDeft(); ++i) {
                dept = dept + "  ";
            }
            if (isAdmin || this.hasInGroup(listGroup, parentCate.getCategory().getModerators())) {
                this.listCategories.add(new SelectItemOption(dept + parentCate.getCategory().getName(), (Object)parentCate.getCategory().getId()));
            }
            i = 0;
            for (Category category : faqService.getSubCategories(parentCate.getCategory().getId(), sessionProvider, this.faqSetting_)) {
                if (category == null) continue;
                childCate = new Cate(this);
                childCate.setCategory(category);
                childCate.setDeft(parentCate.getDeft() + 1);
                listCate.add(i++, childCate);
            }
        }
        sessionProvider.close();
    }

    private String[] getQuestionActions() {
        return new String[]{"AddLanguage", "Attachment", "Save", "Close"};
    }

    private String[] getQuestionNotAnsweredActions() {
        return new String[]{"QuestionRelation", "Attachment", "Save", "Close"};
    }

    private String[] getTab() {
        return new String[]{"Question managerment", "Question not yet answered"};
    }

    private boolean getIsEdit() {
        return this.isEditTab_;
    }

    private boolean getIsResponse() {
        return this.isResponseTab_;
    }

    private long getTotalpages(String pageInteratorId) {
        UIFAQPageIterator pageIterator = (UIFAQPageIterator)this.getChildById(pageInteratorId);
        try {
            return (Long)pageIterator.getInfoPage().get(3);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1L;
        }
    }

    public void setListQuestion() throws Exception {
        this.listQuestion_.clear();
        this.listQuestionNotYetAnswered_.clear();
        String user = FAQUtils.getCurrentUser();
        this.pageIterator = (UIFAQPageIterator)this.getChildById(LIST_QUESTION_INTERATOR);
        this.pageQuesNotAnswerIterator = (UIFAQPageIterator)this.getChildById(LIST_QUESTION_NOT_ANSWERED_INTERATOR);
        SessionProvider sProvider = FAQUtils.getSystemProvider();
        if (!this.faqSetting_.isAdmin()) {
            ArrayList<String> listCateId = new ArrayList<String>();
            if (this.cateId_.equals("All")) {
                listCateId.addAll(faqService_.getListCateIdByModerator(user, sProvider));
                for (int i = 0; i < listCateId.size(); ++i) {
                    for (Category category : faqService_.getSubCategories((String)listCateId.get(i), sProvider, this.faqSetting_)) {
                        if (listCateId.contains(category.getId())) continue;
                        listCateId.add(category.getId());
                    }
                }
            } else {
                listCateId.add(this.cateId_);
            }
            if (!listCateId.isEmpty() && listCateId.size() > 0) {
                this.pageList = faqService_.getQuestionsByListCatetory(listCateId, false, sProvider);
                this.pageList.setPageSize(5L);
                this.pageIterator.updatePageList(this.pageList);
                this.pageListNotAnswer = faqService_.getQuestionsByListCatetory(listCateId, true, sProvider);
                this.pageListNotAnswer.setPageSize(5L);
                this.pageQuesNotAnswerIterator.updatePageList(this.pageListNotAnswer);
            } else {
                this.pageList = null;
                this.pageList.setPageSize(5L);
                this.pageIterator.updatePageList(this.pageList);
                this.pageListNotAnswer = null;
                this.pageListNotAnswer.setPageSize(5L);
                this.pageQuesNotAnswerIterator.updatePageList(this.pageListNotAnswer);
            }
        } else {
            if (this.cateId_.equals("All")) {
                this.pageList = faqService_.getAllQuestions(sProvider);
                this.pageListNotAnswer = faqService_.getQuestionsNotYetAnswer(sProvider, "All");
            } else {
                this.pageList = faqService_.getAllQuestionsByCatetory(this.cateId_, sProvider, this.faqSetting_);
                this.pageListNotAnswer = faqService_.getQuestionsNotYetAnswer(sProvider, this.cateId_);
            }
            this.pageList.setPageSize(5L);
            this.pageIterator.updatePageList(this.pageList);
            this.pageListNotAnswer.setPageSize(5L);
            this.pageQuesNotAnswerIterator.updatePageList(this.pageListNotAnswer);
        }
        sProvider.close();
    }

    private List<Question> getListQuestion() {
        if (!this.isChangeTab_) {
            this.pageSelect = this.pageIterator.getPageSelected();
            this.listQuestion_ = new ArrayList();
            try {
                this.listQuestion_.addAll(this.pageList.getPage(this.pageSelect, null));
                if (this.listQuestion_.isEmpty()) {
                    UIFAQPageIterator pageIterator = null;
                    while (this.listQuestion_.isEmpty() && this.pageSelect > 1L) {
                        pageIterator = (UIFAQPageIterator)this.getChildById(LIST_QUESTION_INTERATOR);
                        this.listQuestion_.addAll(this.pageList.getPage(--this.pageSelect, null));
                        pageIterator.setSelectPage(this.pageSelect);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isChangeTab_ = false;
        return this.listQuestion_;
    }

    private List<Question> getListQuestionNotAnswered() {
        if (!this.isChangeTab_) {
            this.pageSelectNotAnswer = this.pageQuesNotAnswerIterator.getPageSelected();
            this.listQuestionNotYetAnswered_.clear();
            try {
                this.listQuestionNotYetAnswered_.addAll(this.pageListNotAnswer.getPage(this.pageSelectNotAnswer, null));
                UIFAQPageIterator pageIterator = null;
                while (this.listQuestionNotYetAnswered_.isEmpty() && this.pageSelectNotAnswer > 1L) {
                    pageIterator = (UIFAQPageIterator)this.getChildById(LIST_QUESTION_NOT_ANSWERED_INTERATOR);
                    this.listQuestionNotYetAnswered_.addAll(this.pageListNotAnswer.getPage(--this.pageSelectNotAnswer, null));
                    pageIterator.setSelectPage(this.pageSelectNotAnswer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isChangeTab_ = false;
        return this.listQuestionNotYetAnswered_;
    }

    static /* synthetic */ FAQService access$000() {
        return faqService_;
    }

    static /* synthetic */ FAQSetting access$100(UIQuestionsInfo x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ List access$200(UIQuestionsInfo x0) {
        return x0.listQuestion_;
    }

    static /* synthetic */ String access$302(UIQuestionsInfo x0, String x1) {
        x0.cateId_ = x1;
        return x0.cateId_;
    }

    static /* synthetic */ boolean access$402(UIQuestionsInfo x0, boolean x1) {
        x0.isEditTab_ = x1;
        return x0.isEditTab_;
    }

    static /* synthetic */ boolean access$502(UIQuestionsInfo x0, boolean x1) {
        x0.isResponseTab_ = x1;
        return x0.isResponseTab_;
    }

    static /* synthetic */ boolean access$602(UIQuestionsInfo x0, boolean x1) {
        x0.isChangeTab_ = x1;
        return x0.isChangeTab_;
    }
}

