/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIAnswersContainer;
import org.exoplatform.faq.webui.UIAnswersPageIterator;
import org.exoplatform.faq.webui.UIQuestions;
import org.exoplatform.ks.common.bbcode.BBCode;
import org.exoplatform.ks.rss.RSS;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/faq/webui/UIQuestions.gtmpl", events={@EventConfig(listeners={DownloadAttachActionListener.class}), @EventConfig(listeners={DeleteCategoryActionListener.class}, confirm="UIQuestions.msg.confirm-delete-category"), @EventConfig(listeners={ChangeStatusAnswerActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={AddNewQuestionActionListener.class}), @EventConfig(listeners={SettingActionListener.class}), @EventConfig(listeners={QuestionManagamentActionListener.class}), @EventConfig(listeners={ViewQuestionActionListener.class}), @EventConfig(listeners={OpenQuestionActionListener.class}), @EventConfig(listeners={CloseQuestionActionListener.class}), @EventConfig(listeners={ViewUserProfileActionListener.class}), @EventConfig(listeners={ResponseQuestionActionListener.class}), @EventConfig(listeners={EditAnswerActionListener.class}), @EventConfig(listeners={EditQuestionActionListener.class}), @EventConfig(listeners={DeleteQuestionActionListener.class}), @EventConfig(listeners={MoveQuestionActionListener.class}), @EventConfig(listeners={SendQuestionActionListener.class}), @EventConfig(listeners={CommentQuestionActionListener.class}), @EventConfig(listeners={DeleteCommentActionListener.class}, confirm="UIQuestions.msg.confirm-delete-comment"), @EventConfig(listeners={DeleteAnswerActionListener.class}, confirm="UIQuestions.msg.confirm-delete-answer"), @EventConfig(listeners={UnVoteQuestionActionListener.class}, confirm="UIQuestions.msg.confirm-unvote-question"), @EventConfig(listeners={CommentToAnswerActionListener.class}), @EventConfig(listeners={VoteQuestionActionListener.class}), @EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={SortAnswerActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={RSSActionListener.class}), @EventConfig(listeners={EditCategoryActionListener.class}), @EventConfig(listeners={VoteAnswerActionListener.class}), @EventConfig(listeners={PrintAllQuestionActionListener.class}), @EventConfig(listeners={DiscussForumActionListener.class})})
public class UIQuestions
extends UIContainer {
    private static Log log = ExoLogger.getLogger(UIQuestions.class);
    private static String SEARCH_INPUT = "SearchInput";
    private static String COMMENT_ITER = "CommentIter";
    private static String ANSWER_ITER = "AnswerIter";
    public static final String OBJECT_ITERATOR = "object_iter";
    private FAQSetting faqSetting_ = null;
    private Map<String, Question> questionMap_ = new LinkedHashMap();
    public JCRPageList pageList;
    private boolean canEditQuestion = false;
    private Boolean isSortAnswerUp = null;
    public String categoryId_ = null;
    public String viewingQuestionId_ = "";
    private String currentUser_ = "";
    private String link_ = "";
    private static FAQService faqService_ = null;
    private Map<String, QuestionLanguage> languageMap = new HashMap();
    public boolean isChangeLanguage = false;
    public List<String> listLanguage = new ArrayList();
    public String backPath_ = null;
    public static String language_ = FAQUtils.getDefaultLanguage();
    private String discussId = "";
    private String[] firstTollbar_ = new String[]{"AddNewQuestion", "QuestionManagament"};
    private String[] menuCateManager = new String[]{"EditCategory", "AddCategory", "DeleteCategory", "Export", "Import"};
    private String[] userActionsCate_ = new String[]{"AddNewQuestion", "Watch"};
    private String[] moderatorActionQues_ = new String[]{"CommentQuestion", "ResponseQuestion", "EditQuestion", "DeleteQuestion", "MoveQuestion", "SendQuestion"};
    private String[] moderatorActionQues2_ = new String[]{"ResponseQuestion", "EditQuestion", "DeleteQuestion", "MoveQuestion", "SendQuestion"};
    private String[] userActionQues_ = new String[]{"CommentQuestion", "SendQuestion"};
    private String[] userActionQues2_ = new String[]{"SendQuestion"};
    private String[] sizes_ = new String[]{"bytes", "KB", "MB"};
    public boolean viewAuthorInfor = false;
    private boolean isGetSv = true;
    private List<BBCode> listBBCode = new ArrayList();
    private boolean isGetQuestion = true;
    public UIAnswersPageIterator pageIterator = null;
    public long pageSelect = 0L;

    public UIQuestions() throws Exception {
        this.currentUser_ = FAQUtils.getCurrentUser();
        this.addChild(UIAnswersPageIterator.class, null, OBJECT_ITERATOR);
        if (faqService_ == null) {
            faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        }
        if (FAQUtils.isFieldEmpty((String)this.getId())) {
            this.setId("UIQuestions");
        }
    }

    public String getRSSLink() {
        return RSS.getRSSLink((String)"faq", (String)this.getPortalName(), (String)this.categoryId_);
    }

    private String getLinkDiscuss(String topicId) {
        FAQSetting faqSetting = new FAQSetting();
        FAQUtils.getPorletPreference((FAQSetting)faqSetting);
        String link = this.getLink().replaceAll("answers", "forum");
        link = FAQUtils.getLink((String)link, (String)this.getId(), (String)"UIBreadcumbs", (String)"Setting", (String)"ChangePath", (String)topicId);
        return link;
    }

    private String convertLinkToForum(String s) {
        s = s.replaceAll("answers", "forum").replaceFirst(this.getId(), "UIBreadcumbs").replaceFirst("DiscussForum", "ChangePath").replaceAll("amp;", "");
        return s;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private boolean isDiscussForum() throws Exception {
        FAQSetting faqSetting = new FAQSetting();
        FAQUtils.getPorletPreference((FAQSetting)faqSetting);
        return faqSetting.getIsDiscussForum();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public boolean isGetQuestion() {
        return this.isGetQuestion;
    }

    public void setGetQuestion() {
        try {
            boolean b = ((UIAnswersContainer)this.getParent()).isRenderCategory(this.categoryId_);
            if (b != this.isGetQuestion) {
                this.isGetQuestion = b;
                this.setListObject();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setListObject() {
        try {
            if (this.isGetQuestion) {
                String objectId = null;
                if (this.pageList != null) {
                    objectId = this.pageList.getObjectId();
                }
                this.pageList = faqService_.getQuestionsByCatetory(this.categoryId_, this.faqSetting_);
                this.pageList.setPageSize(10L);
                if (objectId != null && objectId.trim().length() > 0) {
                    this.pageList.setObjectId(objectId);
                }
                this.pageIterator = (UIAnswersPageIterator)this.getChildById(OBJECT_ITERATOR);
                this.pageIterator.updatePageList(this.pageList);
            } else {
                this.pageList = null;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to set list question by category.", (Throwable)e);
        }
    }

    private Answer[] getPageListAnswer(String questionId) throws Exception {
        if (this.isSortAnswerUp != null) {
            Answer[] answers = ((QuestionLanguage)this.languageMap.get(language_)).getAnswers();
            for (int i = 0; i < answers.length - 1; ++i) {
                for (int j = i + 1; j < answers.length; ++j) {
                    Answer temp;
                    if (this.isSortAnswerUp.booleanValue()) {
                        if (answers[j].getMarkVotes() >= answers[i].getMarkVotes()) continue;
                        temp = answers[i];
                        answers[i] = answers[j];
                        answers[j] = temp;
                        continue;
                    }
                    if (answers[j].getMarkVotes() <= answers[i].getMarkVotes()) continue;
                    temp = answers[i];
                    answers[i] = answers[j];
                    answers[j] = temp;
                }
            }
            return answers;
        }
        return ((QuestionLanguage)this.languageMap.get(language_)).getAnswers();
    }

    private Comment[] getPageListComment(String questionId) throws Exception {
        return ((QuestionLanguage)this.languageMap.get(language_)).getComments();
    }

    private String[] getActionTollbar() {
        return this.firstTollbar_;
    }

    private String[] getMenuCateManager() {
        return this.menuCateManager;
    }

    public FAQSetting getFAQSetting() {
        return this.faqSetting_;
    }

    private String[] getActionCategoryWithUser() {
        if (this.currentUser_ != null) {
            return this.userActionsCate_;
        }
        if (this.faqSetting_.isEnableAutomaticRSS()) {
            return new String[]{this.userActionsCate_[0], "RSSFAQ"};
        }
        return new String[]{this.userActionsCate_[0]};
    }

    private String[] getActionQuestion() {
        if (this.canEditQuestion) {
            if (!this.faqSetting_.isEnanbleVotesAndComments()) {
                return this.moderatorActionQues2_;
            }
            return this.moderatorActionQues_;
        }
        if (!this.faqSetting_.isEnanbleVotesAndComments()) {
            return this.userActionQues2_;
        }
        if (this.currentUser_ == null || this.currentUser_.trim().length() < 1) {
            return this.userActionQues2_;
        }
        return this.userActionQues_;
    }

    public void updateCurrentQuestionList() throws Exception {
        this.questionMap_.clear();
        this.pageSelect = this.pageIterator.getPageSelected();
        if (this.pageList != null) {
            for (Question question : this.pageList.getPage(this.pageSelect, null)) {
                this.questionMap_.put(question.getId(), question);
            }
            this.pageSelect = this.pageList.getCurrentPage();
            this.pageIterator.setSelectPage(this.pageSelect);
        }
    }

    public void setFAQSetting(FAQSetting setting) {
        this.faqSetting_ = setting;
    }

    public void setFAQService(FAQService service) {
        faqService_ = service;
    }

    private String[] getActionQuestionWithUser() {
        if (!this.faqSetting_.isEnanbleVotesAndComments() || this.currentUser_ == null || this.currentUser_.trim().length() < 1) {
            return this.userActionQues2_;
        }
        return this.userActionQues_;
    }

    public void setLanguageView(String language) {
        language_ = language;
    }

    private String getQuestionContent() {
        if (this.languageMap.containsKey(language_)) {
            return ((QuestionLanguage)this.languageMap.get(language_)).getQuestion();
        }
        return "";
    }

    private String getQuestionDetail() {
        return ((QuestionLanguage)this.languageMap.get(language_)).getDetail();
    }

    private void setIsModerators() throws Exception {
        this.canEditQuestion = this.faqSetting_.isAdmin() || faqService_.isCategoryModerator(this.categoryId_, this.currentUser_);
    }

    private boolean canVote(Question question) {
        if (question.getUsersVote() != null) {
            for (String user : question.getUsersVote()) {
                if (!user.contains(this.currentUser_ + "/")) continue;
                return false;
            }
        }
        return true;
    }

    public void setDefaultLanguage() {
        language_ = FAQUtils.getDefaultLanguage();
    }

    private String convertSize(long size) {
        String result = "";
        long residual = 0L;
        int i = 0;
        while (size >= 1000L) {
            ++i;
            residual = size % 1024L;
            size /= 1024L;
        }
        if (residual > 500L) {
            String str = residual + "";
            result = size + 1L + " " + this.sizes_[i];
        } else {
            result = size + " " + this.sizes_[i];
        }
        return result;
    }

    private Question[] getListQuestion() {
        try {
            this.updateCurrentQuestionList();
        }
        catch (Exception e) {
            log.error((Object)"Failed to get list question.", (Throwable)e);
        }
        return this.questionMap_.values().toArray(new Question[0]);
    }

    private boolean getCanEditQuestion() {
        return this.canEditQuestion;
    }

    private String getQuestionView() {
        return this.viewingQuestionId_;
    }

    private String[] getQuestionLangauges(String questionPath) {
        return this.languageMap.keySet().toArray(new String[0]);
    }

    private String getAvatarUrl(String userId) throws Exception {
        return FAQUtils.getUserAvatar((String)userId);
    }

    public String getCategoryId() {
        return this.categoryId_;
    }

    public void setCategoryId(String categoryId) throws Exception {
        this.viewAuthorInfor = faqService_.isViewAuthorInfo(categoryId);
        this.categoryId_ = categoryId;
        this.setGetQuestion();
        this.setListObject();
    }

    public void viewQuestion(Question question) throws Exception {
        if (!this.questionMap_.containsKey(question.getLanguage())) {
            List languages = faqService_.getQuestionLanguages(question.getPath());
            this.languageMap.clear();
            for (QuestionLanguage lang : languages) {
                this.languageMap.put(lang.getLanguage(), lang);
            }
            if (!this.questionMap_.containsKey(question.getId())) {
                this.questionMap_.put(question.getLanguage(), question);
            }
            this.viewingQuestionId_ = question.getPath();
        }
    }

    public void updateCurrentLanguage() throws Exception {
        if (this.viewingQuestionId_ != null && this.viewingQuestionId_.length() > 0) {
            this.languageMap.put(language_, faqService_.getQuestionLanguageByLanguage(this.viewingQuestionId_, language_));
        } else {
            this.languageMap.clear();
        }
    }

    public void updateQuestionLanguageByLanguage(String questionPath, String language) throws Exception {
        this.languageMap.put(language, faqService_.getQuestionLanguageByLanguage(questionPath, language));
    }

    public void updateLanguageMap() throws Exception {
        try {
            this.languageMap.clear();
            if (this.viewingQuestionId_ != null && this.viewingQuestionId_.length() > 0) {
                List languages = faqService_.getQuestionLanguages(this.viewingQuestionId_);
                for (QuestionLanguage lang : languages) {
                    this.languageMap.put(lang.getLanguage(), lang);
                }
            }
        }
        catch (Exception e) {
            this.viewingQuestionId_ = "";
            log.error((Object)"Failed to update language map.", (Throwable)e);
        }
    }

    private String getQuestionRelationById(String questionId) {
        try {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(questionId);
            return (String)faqService_.getQuestionContents(ids).get(0);
        }
        catch (Exception e) {
            log.error((Object)("Failed to get question content by id: " + questionId), (Throwable)e);
            return "";
        }
    }

    private String getLink() {
        return this.link_;
    }

    private String getBackPath() {
        return this.backPath_;
    }

    public void setPath(String s) {
    }

    private void setLink(String link) {
        this.link_ = link;
    }

    public void setIsGetSv(boolean isGetSv) {
        this.isGetSv = isGetSv;
    }

    private String getReplaceByBBCode(String s) throws Exception {
        List bbcName = new ArrayList();
        if (this.isGetSv) {
            ArrayList<BBCode> bbcs = new ArrayList<BBCode>();
            try {
                bbcName = faqService_.getActiveBBCode();
                this.isGetSv = false;
                boolean isAdd = true;
                for (String string : bbcName) {
                    isAdd = true;
                    for (BBCode bbc : this.listBBCode) {
                        if (!bbc.getTagName().equals(string) && (!bbc.getTagName().equals(string.replaceFirst("=", "")) || !bbc.isOption())) continue;
                        bbcs.add(bbc);
                        isAdd = false;
                        break;
                    }
                    if (!isAdd) continue;
                    BBCode bbCode = new BBCode();
                    if (string.indexOf("=") >= 0) {
                        bbCode.setOption(true);
                        string = string.replaceFirst("=", "");
                        bbCode.setId(string + "_option");
                    } else {
                        bbCode.setId(string);
                    }
                    bbCode.setTagName(string);
                    bbcs.add(bbCode);
                }
                this.listBBCode.clear();
                this.listBBCode.addAll(bbcs);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!this.listBBCode.isEmpty()) {
            try {
                s = Utils.getReplacementByBBcode((String)s, (List)this.listBBCode, (FAQService)faqService_);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    private boolean checkQuestionToView(Question question, UIApplication uiApplication, Event<UIQuestions> event) {
        if (!question.isActivated() || !question.isApproved() && this.faqSetting_.getDisplayMode().equals(FAQUtils.DISPLAYAPPROVED)) {
            uiApplication.addMessage(new ApplicationMessage("UIQuestions.msg.question-pending", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApplication.getUIPopupMessages());
            event.getRequestContext().addUIComponentToUpdateByAjax(this.getAncestorOfType(UIAnswersContainer.class));
            return true;
        }
        return false;
    }

    static /* synthetic */ FAQSetting access$000(UIQuestions x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ FAQService access$100() {
        return faqService_;
    }

    static /* synthetic */ boolean access$200(UIQuestions x0) {
        return x0.canEditQuestion;
    }

    static /* synthetic */ Boolean access$300(UIQuestions x0) {
        return x0.isSortAnswerUp;
    }

    static /* synthetic */ Boolean access$302(UIQuestions x0, Boolean x1) {
        x0.isSortAnswerUp = x1;
        return x0.isSortAnswerUp;
    }

    static /* synthetic */ boolean access$400(UIQuestions x0, Question x1, UIApplication x2, Event x3) {
        return x0.checkQuestionToView(x1, x2, x3);
    }

    static /* synthetic */ Map access$500(UIQuestions x0) {
        return x0.questionMap_;
    }

    static /* synthetic */ Log access$600() {
        return log;
    }

    static /* synthetic */ String access$700(UIQuestions x0) {
        return x0.getLink();
    }

    static /* synthetic */ Map access$800(UIQuestions x0) {
        return x0.languageMap;
    }

    static /* synthetic */ String access$902(UIQuestions x0, String x1) {
        x0.discussId = x1;
        return x0.discussId;
    }

    static /* synthetic */ String access$1000(UIQuestions x0, String x1) {
        return x0.getLinkDiscuss(x1);
    }
}

