/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Cate;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQServiceUtils;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIAnswersPageIterator;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UIQuestionsInfo;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIQuestionsInfo.gtmpl", events={@EventConfig(listeners={ChangeCategoryActionListener.class}), @EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={EditQuestionActionListener.class}), @EventConfig(listeners={DeleteQuestionActionListener.class}), @EventConfig(listeners={ChangeTabActionListener.class}), @EventConfig(listeners={ChangeQuestionStatusActionListener.class}), @EventConfig(listeners={ResponseQuestionActionListener.class})})
public class UIQuestionsInfo
extends UIForm
implements UIPopupComponent {
    private static final String LIST_QUESTION_INTERATOR = "FAQUserPageIteratorTab1";
    private static final String LIST_QUESTION_NOT_ANSWERED_INTERATOR = "FAQUserPageIteratorTab2";
    private static final String LIST_CATEGORIES = "ListCategories";
    private FAQSetting faqSetting_ = new FAQSetting();
    private static FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    private JCRPageList pageList;
    private JCRPageList pageListNotAnswer;
    private UIAnswersPageIterator pageIterator;
    private UIAnswersPageIterator pageQuesNotAnswerIterator;
    private List<Question> listQuestion_ = new ArrayList();
    private List<Question> listQuestionNotYetAnswered_ = new ArrayList();
    private List<SelectItemOption<String>> listCategories = new ArrayList();
    private long pageSelect = 1L;
    private long pageSelectNotAnswer = 1L;
    private List<String> moderateCates = new ArrayList();
    private boolean isEditTab_ = true;
    private boolean isResponseTab_ = false;
    private boolean isChangeTab_ = false;
    private String cateId_ = Utils.ALL;

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public UIQuestionsInfo() throws Exception {
        this.addChild(UIAnswersPageIterator.class, null, LIST_QUESTION_INTERATOR);
        this.addChild(UIAnswersPageIterator.class, null, LIST_QUESTION_NOT_ANSWERED_INTERATOR);
        this.setActions(new String[]{""});
    }

    public void setFAQSetting(FAQSetting setting) throws Exception {
        this.faqSetting_ = setting;
        FAQUtils.getEmailSetting((FAQSetting)this.faqSetting_, (boolean)false, (boolean)false);
        this.setListCate();
        UIFormSelectBox selectCategory = new UIFormSelectBox(LIST_CATEGORIES, LIST_CATEGORIES, this.listCategories);
        selectCategory.setOnChange("ChangeCategory");
        this.addUIFormInput((UIFormInput)selectCategory);
        this.setListQuestion();
    }

    private boolean hasInGroup(List<String> listGroup, String[] listPermission) {
        for (String per : listPermission) {
            if (per == null || per.trim().length() <= 0 || !listGroup.contains(per)) continue;
            return true;
        }
        return false;
    }

    private void setListCate() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        this.listCategories.add(new SelectItemOption(res.getString("UIQuestionsInfo.label.All"), (Object)Utils.ALL));
        FAQService faqService = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        if (this.faqSetting_.isAdmin()) {
            List listCate = faqService.listingCategoryTree();
            this.listCategories.add(new SelectItemOption(faqService_.getCategoryNameOf(Utils.CATEGORY_HOME), (Object)Utils.CATEGORY_HOME));
            for (Cate cat : listCate) {
                this.listCategories.add(new SelectItemOption(cat.getCategory().getName(), (Object)cat.getCategory().getPath()));
            }
        } else {
            List listCate = faqService_.getListCateIdByModerator(FAQUtils.getCurrentUser());
            this.moderateCates.clear();
            for (String str : listCate) {
                try {
                    this.listCategories.add(new SelectItemOption(str.substring(40), (Object)str.substring(0, 40)));
                    this.moderateCates.add(str.substring(0, 40));
                }
                catch (StringIndexOutOfBoundsException e) {
                    if (str.indexOf(Utils.CATEGORY_HOME) != 0) continue;
                    this.listCategories.add(new SelectItemOption(str.substring(Utils.CATEGORY_HOME.length()), (Object)Utils.CATEGORY_HOME));
                    this.moderateCates.add(Utils.CATEGORY_HOME);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String[] getQuestionActions() {
        return new String[]{"AddLanguage", "Attachment", "Save", "Close"};
    }

    private String[] getQuestionNotAnsweredActions() {
        return new String[]{"QuestionRelation", "Attachment", "Save", "Close"};
    }

    private String[] getTab() {
        return new String[]{"Question managerment", "Question not yet answered"};
    }

    private boolean getIsEdit() {
        return this.isEditTab_;
    }

    private boolean getIsResponse() {
        return this.isResponseTab_;
    }

    private long getTotalpages(String pageInteratorId) {
        UIAnswersPageIterator pageIterator = (UIAnswersPageIterator)this.getChildById(pageInteratorId);
        try {
            return (Long)pageIterator.getInfoPage().get(3);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1L;
        }
    }

    public void setListQuestion() throws Exception {
        this.listQuestion_.clear();
        this.listQuestionNotYetAnswered_.clear();
        String user = FAQUtils.getCurrentUser();
        this.pageIterator = (UIAnswersPageIterator)this.getChildById(LIST_QUESTION_INTERATOR);
        this.pageQuesNotAnswerIterator = (UIAnswersPageIterator)this.getChildById(LIST_QUESTION_NOT_ANSWERED_INTERATOR);
        List userPrivates = FAQServiceUtils.getAllGroupAndMembershipOfUser((String)FAQUtils.getCurrentUser());
        if (this.faqSetting_.isAdmin()) {
            if (this.cateId_.equals(Utils.ALL)) {
                this.pageList = faqService_.getAllQuestions();
                this.pageListNotAnswer = faqService_.getQuestionsNotYetAnswer(Utils.ALL, false);
            } else {
                String cateId = this.cateId_;
                if (cateId.indexOf("/") > 0) {
                    cateId = cateId.substring(cateId.lastIndexOf("/") + 1);
                }
                this.pageList = faqService_.getAllQuestionsByCatetory(cateId, this.faqSetting_);
                this.pageListNotAnswer = faqService_.getQuestionsNotYetAnswer(cateId, false);
            }
            this.pageList.setPageSize(5L);
            this.pageIterator.updatePageList(this.pageList);
            this.pageListNotAnswer.setPageSize(5L);
            this.pageQuesNotAnswerIterator.updatePageList(this.pageListNotAnswer);
        } else {
            ArrayList<String> listCateId = new ArrayList<String>();
            if (this.cateId_.equals(Utils.ALL)) {
                listCateId.addAll(this.moderateCates);
            } else if (this.cateId_.indexOf("/") > 0) {
                listCateId.add(this.cateId_.substring(this.cateId_.lastIndexOf("/") + 1));
            } else {
                listCateId.add(this.cateId_);
            }
            if (listCateId.size() > 0) {
                this.pageList = faqService_.getQuestionsByListCatetory(listCateId, false);
                this.pageList.setPageSize(5L);
                this.pageIterator.updatePageList(this.pageList);
                this.pageListNotAnswer = faqService_.getQuestionsByListCatetory(listCateId, true);
                this.pageListNotAnswer.setPageSize(5L);
                this.pageQuesNotAnswerIterator.updatePageList(this.pageListNotAnswer);
            }
        }
    }

    private String getCategoryPath(String questionPath) {
        try {
            return faqService_.getParentCategoriesName(questionPath.substring(0, questionPath.indexOf("/" + Utils.QUESTION_HOME)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return questionPath;
        }
    }

    private List<Question> getListQuestion() {
        if (!this.isChangeTab_) {
            this.pageSelect = this.pageIterator.getPageSelected();
            this.listQuestion_ = new ArrayList();
            try {
                this.listQuestion_.addAll(this.pageList.getPage(this.pageSelect, null));
                if (this.listQuestion_.isEmpty()) {
                    UIAnswersPageIterator pageIterator = null;
                    while (this.listQuestion_.isEmpty() && this.pageSelect > 1L) {
                        pageIterator = (UIAnswersPageIterator)this.getChildById(LIST_QUESTION_INTERATOR);
                        this.listQuestion_.addAll(this.pageList.getPage(--this.pageSelect, null));
                        pageIterator.setSelectPage(this.pageSelect);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isChangeTab_ = false;
        return this.listQuestion_;
    }

    private List<Question> getListQuestionNotAnswered() {
        if (!this.isChangeTab_) {
            this.pageSelectNotAnswer = this.pageQuesNotAnswerIterator.getPageSelected();
            this.listQuestionNotYetAnswered_.clear();
            try {
                this.listQuestionNotYetAnswered_.addAll(this.pageListNotAnswer.getPage(this.pageSelectNotAnswer, null));
                UIAnswersPageIterator pageIterator = null;
                while (this.listQuestionNotYetAnswered_.isEmpty() && this.pageSelectNotAnswer > 1L) {
                    pageIterator = (UIAnswersPageIterator)this.getChildById(LIST_QUESTION_NOT_ANSWERED_INTERATOR);
                    this.listQuestionNotYetAnswered_.addAll(this.pageListNotAnswer.getPage(--this.pageSelectNotAnswer, null));
                    pageIterator.setSelectPage(this.pageSelectNotAnswer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isChangeTab_ = false;
        return this.listQuestionNotYetAnswered_;
    }

    static /* synthetic */ FAQService access$000() {
        return faqService_;
    }

    static /* synthetic */ FAQSetting access$100(UIQuestionsInfo x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ List access$200(UIQuestionsInfo x0) {
        return x0.listQuestion_;
    }

    static /* synthetic */ String access$302(UIQuestionsInfo x0, String x1) {
        x0.cateId_ = x1;
        return x0.cateId_;
    }

    static /* synthetic */ boolean access$402(UIQuestionsInfo x0, boolean x1) {
        x0.isEditTab_ = x1;
        return x0.isEditTab_;
    }

    static /* synthetic */ boolean access$502(UIQuestionsInfo x0, boolean x1) {
        x0.isResponseTab_ = x1;
        return x0.isResponseTab_;
    }

    static /* synthetic */ boolean access$602(UIQuestionsInfo x0, boolean x1) {
        x0.isChangeTab_ = x1;
        return x0.isChangeTab_;
    }
}

