/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.viewer;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.CategoryInfo;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.viewer.FAQResourceResolver;
import org.exoplatform.faq.webui.viewer.UIViewer;
import org.exoplatform.ks.common.bbcode.BBCode;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={ChangePathActionListener.class})})
public class UIViewer
extends UIContainer {
    private FAQService fAqService;
    private String path = Utils.CATEGORY_HOME;
    private boolean useAjax = false;
    private List<BBCode> listBBCode = new ArrayList();

    public UIViewer() {
        this.fAqService = (FAQService)PortalContainer.getComponent(FAQService.class);
    }

    private List<String> arrangeList(List<String> list) {
        ArrayList<String> newList = new ArrayList<String>();
        if (list.isEmpty() || list.size() == 0) {
            newList.add("<img src=\"/faq/skin/DefaultSkin/webui/background/HomeIcon.gif\" alt=\"" + Utils.CATEGORY_HOME + "\"/>");
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (i == list.size() - 1) {
                    newList.add("<img src=\"/faq/skin/DefaultSkin/webui/background/HomeIcon.gif\" alt=\"" + list.get(i) + "\"/>");
                    continue;
                }
                newList.add(list.get(i));
            }
        }
        return newList;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return new FAQResourceResolver();
    }

    public String getTemplate() {
        return "FAQViewerTemplate";
    }

    private CategoryInfo getCategoryInfo() throws Exception {
        CategoryInfo categoryInfo = new CategoryInfo();
        List list = new ArrayList();
        list = FAQUtils.getCategoriesIdFAQPortlet();
        this.useAjax = FAQUtils.getUseAjaxFAQPortlet();
        categoryInfo = this.fAqService.getCategoryInfo(this.path, list);
        List bbcName = new ArrayList();
        ArrayList<BBCode> bbcs = new ArrayList<BBCode>();
        bbcName = this.fAqService.getActiveBBCode();
        boolean isAdd = true;
        for (String string : bbcName) {
            isAdd = true;
            try {
                for (BBCode bbc : this.listBBCode) {
                    if (!bbc.getTagName().equals(string) && (!bbc.getTagName().equals(string.replaceFirst("=", "")) || !bbc.isOption())) continue;
                    bbcs.add(bbc);
                    isAdd = false;
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!isAdd) continue;
            BBCode bbCode = new BBCode();
            if (string.indexOf("=") >= 0) {
                bbCode.setOption(true);
                string = string.replaceFirst("=", "");
                bbCode.setId(string + "_option");
            } else {
                bbCode.setId(string);
            }
            bbCode.setTagName(string);
            bbcs.add(bbCode);
        }
        this.listBBCode.clear();
        this.listBBCode.addAll(bbcs);
        return categoryInfo;
    }

    private String getReplaceByBBCode(String s) throws Exception {
        try {
            s = Utils.getReplacementByBBcode((String)s, (List)this.listBBCode, (FAQService)this.fAqService);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    static /* synthetic */ String access$002(UIViewer x0, String x1) {
        x0.path = x1;
        return x0.path;
    }
}

